/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.errorprone.apply.FileDestination;
import com.google.errorprone.apply.SourceFile;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class PatchFileDestination
implements FileDestination {
    private static final Splitter LINE_SPLITTER = Splitter.on('\n');
    private final Path baseDir;
    private final Path rootPath;
    private final Map<URI, String> diffByFile = new TreeMap<URI, String>();

    public PatchFileDestination(Path baseDir, Path rootPath) {
        this.baseDir = baseDir;
        this.rootPath = rootPath;
    }

    @Override
    public void writeFile(SourceFile update) throws IOException {
        String newSource;
        Path sourceFilePath = this.rootPath.resolve(update.getPath());
        String oldSource = new String(Files.readAllBytes(sourceFilePath), StandardCharsets.UTF_8);
        if (!oldSource.equals(newSource = update.getSourceText())) {
            List<String> originalLines = LINE_SPLITTER.splitToList(oldSource);
            Patch<String> diff = DiffUtils.diff(originalLines, LINE_SPLITTER.splitToList(newSource));
            String relativePath = this.relativize(sourceFilePath);
            List<String> unifiedDiff = DiffUtils.generateUnifiedDiff(relativePath, relativePath, originalLines, diff, 2);
            String diffString = Joiner.on("\n").join(unifiedDiff) + "\n";
            this.diffByFile.put(sourceFilePath.toUri(), diffString);
        }
    }

    private String relativize(Path sourceFilePath) {
        return this.baseDir.relativize(sourceFilePath).toString();
    }

    public String patchFile(URI uri) {
        return this.diffByFile.remove(uri);
    }

    @Override
    public void flush() throws IOException {
    }
}

