/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class BugChecker
implements Suppressible,
Serializable {
    private final BugCheckerInfo info = BugCheckerInfo.create(this.getClass());

    @CheckReturnValue
    protected Description describeMatch(Tree node, Fix fix) {
        return this.buildDescription(node).addFix(fix).build();
    }

    @CheckReturnValue
    protected Description describeMatch(Tree node) {
        return this.buildDescription(node).build();
    }

    @CheckReturnValue
    protected Description describeMatch(Tree node, Optional<? extends Fix> fix) {
        return this.buildDescription(node).addFix(fix).build();
    }

    @CheckReturnValue
    protected Description.Builder buildDescription(Tree node) {
        return BugChecker.buildDescriptionFromChecker(node, this);
    }

    @CheckReturnValue
    protected Description.Builder buildDescription(JCDiagnostic.DiagnosticPosition position) {
        return BugChecker.buildDescriptionFromChecker(position, this);
    }

    @CheckReturnValue
    protected Description.Builder buildDescription(JCTree tree) {
        return BugChecker.buildDescriptionFromChecker((JCDiagnostic.DiagnosticPosition)tree, this);
    }

    @CheckReturnValue
    public static Description.Builder buildDescriptionFromChecker(Tree node, BugChecker checker) {
        return Description.builder(Preconditions.checkNotNull(node), checker.canonicalName(), checker.linkUrl(), checker.defaultSeverity(), checker.message());
    }

    @CheckReturnValue
    public static Description.Builder buildDescriptionFromChecker(JCDiagnostic.DiagnosticPosition position, BugChecker checker) {
        return Description.builder(position, checker.canonicalName(), checker.linkUrl(), checker.defaultSeverity(), checker.message());
    }

    @CheckReturnValue
    public static Description.Builder buildDescriptionFromChecker(JCTree tree, BugChecker checker) {
        return Description.builder((JCDiagnostic.DiagnosticPosition)tree, checker.canonicalName(), checker.linkUrl(), checker.defaultSeverity(), checker.message());
    }

    @Override
    public String canonicalName() {
        return this.info.canonicalName();
    }

    @Override
    public Set<String> allNames() {
        return this.info.allNames();
    }

    public String message() {
        return this.info.message();
    }

    public BugPattern.SeverityLevel defaultSeverity() {
        return this.info.defaultSeverity();
    }

    public BugPattern.SeverityLevel severity(Map<String, BugPattern.SeverityLevel> severities) {
        return MoreObjects.firstNonNull(severities.get(this.canonicalName()), this.defaultSeverity());
    }

    public String linkUrl() {
        return this.info.linkUrl();
    }

    @Override
    public boolean supportsSuppressWarnings() {
        return this.info.supportsSuppressWarnings();
    }

    @Override
    public Set<Class<? extends Annotation>> customSuppressionAnnotations() {
        return this.info.customSuppressionAnnotations();
    }

    public boolean isSuppressed(Tree tree) {
        SuppressWarnings suppression = ASTHelpers.getAnnotation(tree, SuppressWarnings.class);
        return suppression != null && !Collections.disjoint(Arrays.asList(suppression.value()), this.allNames());
    }

    public boolean isSuppressed(Symbol symbol) {
        SuppressWarnings suppression = ASTHelpers.getAnnotation(symbol, SuppressWarnings.class);
        return suppression != null && !Collections.disjoint(Arrays.asList(suppression.value()), this.allNames());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BugChecker)) {
            return false;
        }
        BugChecker that = (BugChecker)obj;
        return this.canonicalName().equals(that.canonicalName()) && this.defaultSeverity().equals((Object)that.defaultSeverity()) && this.supportsSuppressWarnings() == that.supportsSuppressWarnings() && this.customSuppressionAnnotations().equals(that.customSuppressionAnnotations());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.canonicalName(), this.defaultSeverity(), this.supportsSuppressWarnings(), this.customSuppressionAnnotations()});
    }

    public static interface WildcardTreeMatcher
    extends Suppressible {
        public Description matchWildcard(WildcardTree var1, VisitorState var2);
    }

    public static interface WhileLoopTreeMatcher
    extends Suppressible {
        public Description matchWhileLoop(WhileLoopTree var1, VisitorState var2);
    }

    public static interface VariableTreeMatcher
    extends Suppressible {
        public Description matchVariable(VariableTree var1, VisitorState var2);
    }

    public static interface UnionTypeTreeMatcher
    extends Suppressible {
        public Description matchUnionType(UnionTypeTree var1, VisitorState var2);
    }

    public static interface UnaryTreeMatcher
    extends Suppressible {
        public Description matchUnary(UnaryTree var1, VisitorState var2);
    }

    public static interface TypeParameterTreeMatcher
    extends Suppressible {
        public Description matchTypeParameter(TypeParameterTree var1, VisitorState var2);
    }

    public static interface TypeCastTreeMatcher
    extends Suppressible {
        public Description matchTypeCast(TypeCastTree var1, VisitorState var2);
    }

    public static interface TryTreeMatcher
    extends Suppressible {
        public Description matchTry(TryTree var1, VisitorState var2);
    }

    public static interface ThrowTreeMatcher
    extends Suppressible {
        public Description matchThrow(ThrowTree var1, VisitorState var2);
    }

    public static interface SynchronizedTreeMatcher
    extends Suppressible {
        public Description matchSynchronized(SynchronizedTree var1, VisitorState var2);
    }

    public static interface SwitchTreeMatcher
    extends Suppressible {
        public Description matchSwitch(SwitchTree var1, VisitorState var2);
    }

    public static interface ReturnTreeMatcher
    extends Suppressible {
        public Description matchReturn(ReturnTree var1, VisitorState var2);
    }

    public static interface PrimitiveTypeTreeMatcher
    extends Suppressible {
        public Description matchPrimitiveType(PrimitiveTypeTree var1, VisitorState var2);
    }

    public static interface ParenthesizedTreeMatcher
    extends Suppressible {
        public Description matchParenthesized(ParenthesizedTree var1, VisitorState var2);
    }

    public static interface ParameterizedTypeTreeMatcher
    extends Suppressible {
        public Description matchParameterizedType(ParameterizedTypeTree var1, VisitorState var2);
    }

    public static interface NewClassTreeMatcher
    extends Suppressible {
        public Description matchNewClass(NewClassTree var1, VisitorState var2);
    }

    public static interface NewArrayTreeMatcher
    extends Suppressible {
        public Description matchNewArray(NewArrayTree var1, VisitorState var2);
    }

    public static interface ModifiersTreeMatcher
    extends Suppressible {
        public Description matchModifiers(ModifiersTree var1, VisitorState var2);
    }

    public static interface MethodInvocationTreeMatcher
    extends Suppressible {
        public Description matchMethodInvocation(MethodInvocationTree var1, VisitorState var2);
    }

    public static interface MethodTreeMatcher
    extends Suppressible {
        public Description matchMethod(MethodTree var1, VisitorState var2);
    }

    public static interface MemberSelectTreeMatcher
    extends Suppressible {
        public Description matchMemberSelect(MemberSelectTree var1, VisitorState var2);
    }

    public static interface MemberReferenceTreeMatcher
    extends Suppressible {
        public Description matchMemberReference(MemberReferenceTree var1, VisitorState var2);
    }

    public static interface LiteralTreeMatcher
    extends Suppressible {
        public Description matchLiteral(LiteralTree var1, VisitorState var2);
    }

    public static interface LambdaExpressionTreeMatcher
    extends Suppressible {
        public Description matchLambdaExpression(LambdaExpressionTree var1, VisitorState var2);
    }

    public static interface LabeledStatementTreeMatcher
    extends Suppressible {
        public Description matchLabeledStatement(LabeledStatementTree var1, VisitorState var2);
    }

    public static interface IntersectionTypeTreeMatcher
    extends Suppressible {
        public Description matchIntersectionType(IntersectionTypeTree var1, VisitorState var2);
    }

    public static interface InstanceOfTreeMatcher
    extends Suppressible {
        public Description matchInstanceOf(InstanceOfTree var1, VisitorState var2);
    }

    public static interface ImportTreeMatcher
    extends Suppressible {
        public Description matchImport(ImportTree var1, VisitorState var2);
    }

    public static interface IfTreeMatcher
    extends Suppressible {
        public Description matchIf(IfTree var1, VisitorState var2);
    }

    public static interface IdentifierTreeMatcher
    extends Suppressible {
        public Description matchIdentifier(IdentifierTree var1, VisitorState var2);
    }

    public static interface ForLoopTreeMatcher
    extends Suppressible {
        public Description matchForLoop(ForLoopTree var1, VisitorState var2);
    }

    public static interface ExpressionStatementTreeMatcher
    extends Suppressible {
        public Description matchExpressionStatement(ExpressionStatementTree var1, VisitorState var2);
    }

    public static interface EnhancedForLoopTreeMatcher
    extends Suppressible {
        public Description matchEnhancedForLoop(EnhancedForLoopTree var1, VisitorState var2);
    }

    public static interface EmptyStatementTreeMatcher
    extends Suppressible {
        public Description matchEmptyStatement(EmptyStatementTree var1, VisitorState var2);
    }

    public static interface DoWhileLoopTreeMatcher
    extends Suppressible {
        public Description matchDoWhileLoop(DoWhileLoopTree var1, VisitorState var2);
    }

    public static interface ContinueTreeMatcher
    extends Suppressible {
        public Description matchContinue(ContinueTree var1, VisitorState var2);
    }

    public static interface ConditionalExpressionTreeMatcher
    extends Suppressible {
        public Description matchConditionalExpression(ConditionalExpressionTree var1, VisitorState var2);
    }

    public static interface CompoundAssignmentTreeMatcher
    extends Suppressible {
        public Description matchCompoundAssignment(CompoundAssignmentTree var1, VisitorState var2);
    }

    public static interface CompilationUnitTreeMatcher
    extends Suppressible {
        public Description matchCompilationUnit(CompilationUnitTree var1, VisitorState var2);
    }

    public static interface ClassTreeMatcher
    extends Suppressible {
        public Description matchClass(ClassTree var1, VisitorState var2);
    }

    public static interface CatchTreeMatcher
    extends Suppressible {
        public Description matchCatch(CatchTree var1, VisitorState var2);
    }

    public static interface CaseTreeMatcher
    extends Suppressible {
        public Description matchCase(CaseTree var1, VisitorState var2);
    }

    public static interface BreakTreeMatcher
    extends Suppressible {
        public Description matchBreak(BreakTree var1, VisitorState var2);
    }

    public static interface BlockTreeMatcher
    extends Suppressible {
        public Description matchBlock(BlockTree var1, VisitorState var2);
    }

    public static interface BinaryTreeMatcher
    extends Suppressible {
        public Description matchBinary(BinaryTree var1, VisitorState var2);
    }

    public static interface AssignmentTreeMatcher
    extends Suppressible {
        public Description matchAssignment(AssignmentTree var1, VisitorState var2);
    }

    public static interface AssertTreeMatcher
    extends Suppressible {
        public Description matchAssert(AssertTree var1, VisitorState var2);
    }

    public static interface ArrayTypeTreeMatcher
    extends Suppressible {
        public Description matchArrayType(ArrayTypeTree var1, VisitorState var2);
    }

    public static interface ArrayAccessTreeMatcher
    extends Suppressible {
        public Description matchArrayAccess(ArrayAccessTree var1, VisitorState var2);
    }

    public static interface AnnotatedTypeTreeMatcher
    extends Suppressible {
        public Description matchAnnotatedType(AnnotatedTypeTree var1, VisitorState var2);
    }

    public static interface AnnotationTreeMatcher
    extends Suppressible {
        public Description matchAnnotation(AnnotationTree var1, VisitorState var2);
    }
}

