/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.errorprone.dataflow.AccessPath;
import com.google.errorprone.dataflow.AccessPathValues;
import com.google.errorprone.dataflow.AutoValue_AccessPathStore;
import com.google.errorprone.dataflow.LocalVariableValues;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;

@AutoValue
public abstract class AccessPathStore<V extends AbstractValue<V>>
implements Store<AccessPathStore<V>>,
LocalVariableValues<V>,
AccessPathValues<V> {
    private static final AccessPathStore<?> EMPTY = AccessPathStore.create(ImmutableMap.of());

    public abstract ImmutableMap<AccessPath, V> heap();

    private static <V extends AbstractValue<V>> AccessPathStore<V> create(ImmutableMap<AccessPath, V> heap) {
        return new AutoValue_AccessPathStore<V>(heap);
    }

    public static <V extends AbstractValue<V>> AccessPathStore<V> empty() {
        return EMPTY;
    }

    @Override
    public V valueOfLocalVariable(LocalVariableNode node, V defaultValue) {
        return this.valueOfAccessPath(AccessPath.fromLocalVariable(node), defaultValue);
    }

    @Nullable
    private V getInformation(AccessPath ap) {
        return (V)((AbstractValue)this.heap().get(Preconditions.checkNotNull(ap)));
    }

    public Builder<V> toBuilder() {
        return new Builder(this);
    }

    @Override
    public V valueOfAccessPath(AccessPath path, V defaultValue) {
        V result = this.getInformation(path);
        return result != null ? result : defaultValue;
    }

    @Override
    public AccessPathStore<V> copy() {
        return this;
    }

    @Override
    public AccessPathStore<V> leastUpperBound(AccessPathStore<V> other) {
        ImmutableMap.Builder<AccessPath, AbstractValue> resultHeap = ImmutableMap.builder();
        for (AccessPath aPath : Sets.intersection(this.heap().keySet(), other.heap().keySet())) {
            resultHeap.put(aPath, ((AbstractValue)this.heap().get(aPath)).leastUpperBound((AbstractValue)other.heap().get(aPath)));
        }
        return AccessPathStore.create(resultHeap.build());
    }

    @Override
    public AccessPathStore<V> widenedUpperBound(AccessPathStore<V> vAccessPathStore) {
        return this.leastUpperBound(vAccessPathStore);
    }

    @Override
    public boolean canAlias(FlowExpressions.Receiver a, FlowExpressions.Receiver b) {
        return true;
    }

    @Override
    public void visualize(CFGVisualizer<?, AccessPathStore<V>, ?> cfgVisualizer) {
        throw new UnsupportedOperationException("DOT output not supported");
    }

    public static final class Builder<V extends AbstractValue<V>> {
        private final Map<AccessPath, V> heap;

        Builder(AccessPathStore<V> prototype) {
            this.heap = new LinkedHashMap<AccessPath, V>(prototype.heap());
        }

        public Builder<V> setInformation(AccessPath aPath, V value) {
            this.heap.put(Preconditions.checkNotNull(aPath), Preconditions.checkNotNull(value));
            return this;
        }

        public AccessPathStore<V> build() {
            return AccessPathStore.create(ImmutableMap.copyOf(this.heap));
        }
    }
}

