/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.dataflow.AutoValue_DataFlow_AnalysisParams;
import com.google.errorprone.dataflow.AutoValue_DataFlow_CfgParams;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;

public final class DataFlow {
    private static final LoadingCache<AnalysisParams, Analysis<?, ?, ?>> analysisCache = CacheBuilder.newBuilder().build(new CacheLoader<AnalysisParams, Analysis<?, ?, ?>>(){

        @Override
        public Analysis<?, ?, ?> load(AnalysisParams key) {
            ProcessingEnvironment env = key.environment();
            ControlFlowGraph cfg = key.cfg();
            TransferFunction<?, ?> transfer = key.transferFunction();
            Analysis analysis = new Analysis(transfer, env);
            analysis.performAnalysis(cfg);
            return analysis;
        }
    });
    private static final LoadingCache<CfgParams, ControlFlowGraph> cfgCache = CacheBuilder.newBuilder().maximumSize(1L).build(new CacheLoader<CfgParams, ControlFlowGraph>(){

        @Override
        public ControlFlowGraph load(CfgParams key) {
            UnderlyingAST ast;
            TreePath methodPath = key.methodPath();
            ClassTree classTree = null;
            for (Tree parent : methodPath) {
                if (!(parent instanceof ClassTree)) continue;
                classTree = (ClassTree)parent;
                break;
            }
            if (methodPath.getLeaf() instanceof LambdaExpressionTree) {
                ast = new UnderlyingAST.CFGLambda((LambdaExpressionTree)methodPath.getLeaf());
            } else if (methodPath.getLeaf() instanceof MethodTree) {
                MethodTree method = (MethodTree)methodPath.getLeaf();
                ast = new UnderlyingAST.CFGMethod(method, classTree);
            } else {
                ast = new UnderlyingAST.CFGStatement(methodPath.getLeaf(), classTree);
            }
            ProcessingEnvironment env = key.environment();
            analysisCache.invalidateAll();
            CompilationUnitTree root = methodPath.getCompilationUnit();
            return CFGBuilder.build(root, ast, false, false, env);
        }
    });

    private static <T> TreePath findEnclosingMethodOrLambdaOrInitializer(TreePath path) {
        while (path != null) {
            if (path.getLeaf() instanceof MethodTree) {
                return path;
            }
            TreePath parent = path.getParentPath();
            if (parent != null) {
                if (parent.getLeaf() instanceof ClassTree) {
                    if (path.getLeaf() instanceof BlockTree) {
                        return path;
                    }
                    if (path.getLeaf() instanceof VariableTree && ((VariableTree)path.getLeaf()).getInitializer() != null) {
                        return path;
                    }
                }
                if (parent.getLeaf() instanceof LambdaExpressionTree) {
                    return parent;
                }
            }
            path = parent;
        }
        return null;
    }

    private static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> Result<A, S, T> methodDataflow(TreePath methodPath, Context context, T transfer) {
        ControlFlowGraph cfg;
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(context);
        try {
            cfg = cfgCache.getUnchecked(CfgParams.create(methodPath, env));
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause() instanceof Symbol.CompletionFailure ? (Symbol.CompletionFailure)e.getCause() : e;
        }
        AnalysisParams aparams = AnalysisParams.create(transfer, cfg, env);
        final Analysis<?, ?, ?> analysis = analysisCache.getUnchecked(aparams);
        return new Result<A, S, T>(){

            @Override
            public Analysis<A, S, T> getAnalysis() {
                return analysis;
            }

            @Override
            public ControlFlowGraph getControlFlowGraph() {
                return cfg;
            }
        };
    }

    @Nullable
    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> A expressionDataflow(TreePath exprPath, Context context, T transfer) {
        Tree leaf = exprPath.getLeaf();
        Preconditions.checkArgument(leaf instanceof ExpressionTree, "Leaf of exprPath must be of type ExpressionTree, but was %s", (Object)leaf.getClass().getName());
        ExpressionTree expr = (ExpressionTree)leaf;
        TreePath enclosingMethodPath = DataFlow.findEnclosingMethodOrLambdaOrInitializer(exprPath);
        if (enclosingMethodPath == null) {
            return null;
        }
        Tree method = enclosingMethodPath.getLeaf();
        if (method instanceof MethodTree && ((MethodTree)method).getBody() == null) {
            return null;
        }
        return DataFlow.methodDataflow(enclosingMethodPath, context, transfer).getAnalysis().getValue(expr);
    }

    @AutoValue
    static abstract class AnalysisParams {
        private ProcessingEnvironment environment;

        AnalysisParams() {
        }

        abstract TransferFunction<?, ?> transferFunction();

        abstract ControlFlowGraph cfg();

        private static AnalysisParams create(TransferFunction<?, ?> transferFunction, ControlFlowGraph cfg, ProcessingEnvironment environment) {
            AutoValue_DataFlow_AnalysisParams ap = new AutoValue_DataFlow_AnalysisParams(transferFunction, cfg);
            ap.environment = environment;
            return ap;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }
    }

    @AutoValue
    static abstract class CfgParams {
        private ProcessingEnvironment environment;

        CfgParams() {
        }

        abstract TreePath methodPath();

        private static CfgParams create(TreePath methodPath, ProcessingEnvironment environment) {
            AutoValue_DataFlow_CfgParams cp = new AutoValue_DataFlow_CfgParams(methodPath);
            cp.environment = environment;
            return cp;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }
    }

    public static interface Result<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> {
        public Analysis<A, S, T> getAnalysis();

        public ControlFlowGraph getControlFlowGraph();
    }
}

