/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.errorprone.dataflow.LocalVariableValues;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.javacutil.trees.DetachedVarSymbol;

public final class LocalStore<V extends AbstractValue<V>>
implements Store<LocalStore<V>>,
LocalVariableValues<V> {
    private static final LocalStore<?> EMPTY = new LocalStore(ImmutableMap.of());
    private final ImmutableMap<Element, V> contents;

    public static <V extends AbstractValue<V>> LocalStore<V> empty() {
        return EMPTY;
    }

    private LocalStore(Map<Element, V> contents) {
        this.contents = ImmutableMap.copyOf(contents);
    }

    @Override
    public V valueOfLocalVariable(LocalVariableNode node, V defaultValue) {
        V result = this.getInformation(node.getElement());
        return result != null ? result : defaultValue;
    }

    @Nullable
    private V getInformation(Element element) {
        LocalStore.checkElementType(element);
        return (V)((AbstractValue)this.contents.get(Preconditions.checkNotNull(element)));
    }

    public Builder<V> toBuilder() {
        return new Builder(this);
    }

    @Override
    public LocalStore<V> copy() {
        return this;
    }

    @Override
    public LocalStore<V> leastUpperBound(LocalStore<V> other) {
        Builder<V> result = LocalStore.empty().toBuilder();
        for (Element var : Sets.intersection(this.contents.keySet(), other.contents.keySet())) {
            ((Builder)result).contents.put(var, ((AbstractValue)this.contents.get(var)).leastUpperBound((AbstractValue)other.contents.get(var)));
        }
        return result.build();
    }

    @Override
    public LocalStore<V> widenedUpperBound(LocalStore<V> vLocalStore) {
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalStore)) {
            return false;
        }
        LocalStore other = (LocalStore)o;
        return this.contents.equals(other.contents);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public String toString() {
        return this.contents.toString();
    }

    @Override
    public boolean canAlias(FlowExpressions.Receiver a, FlowExpressions.Receiver b) {
        return true;
    }

    @Override
    public void visualize(CFGVisualizer<?, LocalStore<V>, ?> cfgVisualizer) {
        throw new UnsupportedOperationException("DOT output not supported");
    }

    private static void checkElementType(Element element) {
        Preconditions.checkArgument(element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.PARAMETER || element.getKind() == ElementKind.EXCEPTION_PARAMETER || element.getKind() == ElementKind.RESOURCE_VARIABLE || element instanceof DetachedVarSymbol, "unexpected element type: %s (%s)", (Object)element.getKind(), (Object)element);
    }

    public static final class Builder<V extends AbstractValue<V>> {
        private final Map<Element, V> contents;

        Builder(LocalStore<V> prototype) {
            this.contents = new HashMap<Element, V>(((LocalStore)prototype).contents);
        }

        public Builder<V> setInformation(Element element, V value) {
            LocalStore.checkElementType(element);
            this.contents.put(Preconditions.checkNotNull(element), Preconditions.checkNotNull(value));
            return this;
        }

        public LocalStore<V> build() {
            return new LocalStore(this.contents);
        }
    }
}

