/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.dataflow.AccessPath;
import com.google.errorprone.dataflow.AccessPathStore;
import com.google.errorprone.dataflow.AccessPathValues;
import com.google.errorprone.dataflow.LocalVariableValues;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessPropagationTransfer;
import com.sun.source.tree.MethodInvocationTree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.ArrayTypeNode;
import org.checkerframework.dataflow.cfg.node.AssertionErrorNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.CaseNode;
import org.checkerframework.dataflow.cfg.node.CharacterLiteralNode;
import org.checkerframework.dataflow.cfg.node.ClassDeclarationNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.DoubleLiteralNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.FloatLiteralNode;
import org.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.LambdaResultExpressionNode;
import org.checkerframework.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.LongLiteralNode;
import org.checkerframework.dataflow.cfg.node.MarkerNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.NullChkNode;
import org.checkerframework.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.PackageNameNode;
import org.checkerframework.dataflow.cfg.node.ParameterizedTypeNode;
import org.checkerframework.dataflow.cfg.node.PrimitiveTypeNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.ShortLiteralNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.ThrowNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;

abstract class AbstractNullnessPropagationTransfer
implements TransferFunction<Nullness, AccessPathStore<Nullness>> {
    private static final boolean NO_STORE_CHANGE = false;

    AbstractNullnessPropagationTransfer() {
    }

    @Override
    public AccessPathStore<Nullness> initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        return AccessPathStore.empty();
    }

    Nullness visitValueLiteral() {
        return Nullness.NULLABLE;
    }

    Nullness visitBitwiseOperation() {
        return Nullness.NULLABLE;
    }

    Nullness visitNumericalComparison() {
        return Nullness.NULLABLE;
    }

    Nullness visitNumericalOperation() {
        return Nullness.NULLABLE;
    }

    Nullness visitThisLiteral() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNullLiteral(NullLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitNullLiteral();
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitNullLiteral() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitTypeCast(TypeCastNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitTypeCast(node, AbstractNullnessPropagationTransfer.values(input));
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    @Override
    Nullness visitTypeCast(TypeCastNode node, SubNodeValues inputs) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNumericalAddition(NumericalAdditionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitNumericalAddition();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitNumericalAddition() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNarrowingConversion(NarrowingConversionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitNarrowingConversion();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitNarrowingConversion() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitEqualTo(EqualToNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        this.visitEqualTo(node, AbstractNullnessPropagationTransfer.values(input), thenUpdates, elseUpdates);
        ResultingStore thenStore = AbstractNullnessPropagationTransfer.updateStore(input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AbstractNullnessPropagationTransfer.updateStore(input.getElseStore(), elseUpdates);
        return AbstractNullnessPropagationTransfer.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
    }

    void visitEqualTo(EqualToNode node, SubNodeValues inputs, Updates thenUpdates, Updates elseUpdates) {
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNotEqual(NotEqualNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        this.visitNotEqual(node, AbstractNullnessPropagationTransfer.values(input), thenUpdates, elseUpdates);
        ResultingStore thenStore = AbstractNullnessPropagationTransfer.updateStore(input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AbstractNullnessPropagationTransfer.updateStore(input.getElseStore(), elseUpdates);
        return AbstractNullnessPropagationTransfer.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
    }

    void visitNotEqual(NotEqualNode node, SubNodeValues inputs, Updates thenUpdates, Updates elseUpdates) {
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitAssignment(AssignmentNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitAssignment(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitAssignment(AssignmentNode node, SubNodeValues inputs, Updates updates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitLocalVariable(LocalVariableNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitLocalVariable(node, (LocalVariableValues<Nullness>)input.getRegularStore());
        return this.updateRegularStore(result, input, updates);
    }

    @Override
    Nullness visitLocalVariable(LocalVariableNode node, LocalVariableValues<Nullness> store) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitFieldAccess(FieldAccessNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitFieldAccess(node, updates, (AccessPathValues<Nullness>)input.getRegularStore());
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitFieldAccess(FieldAccessNode node, Updates updates, AccessPathValues<Nullness> store) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitMethodInvocation(MethodInvocationNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        ReadableUpdates bothUpdates = new ReadableUpdates();
        Nullness result = this.visitMethodInvocation(node, thenUpdates, elseUpdates, bothUpdates);
        if (NullnessPropagationTransfer.tryGetMethodSymbol((MethodInvocationTree)node.getTree(), null).isBoolean) {
            ResultingStore thenStore = AbstractNullnessPropagationTransfer.updateStore(input.getThenStore(), thenUpdates, bothUpdates);
            ResultingStore elseStore = AbstractNullnessPropagationTransfer.updateStore(input.getElseStore(), elseUpdates, bothUpdates);
            return AbstractNullnessPropagationTransfer.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
        }
        return this.updateRegularStore(result, input, bothUpdates);
    }

    Nullness visitMethodInvocation(MethodInvocationNode node, Updates thenUpdates, Updates elseUpdates, Updates bothUpdates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitConditionalAnd(ConditionalAndNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        return AbstractNullnessPropagationTransfer.conditionalResult(input.getThenStore(), input.getElseStore(), false);
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitConditionalOr(ConditionalOrNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        return AbstractNullnessPropagationTransfer.conditionalResult(input.getThenStore(), input.getElseStore(), false);
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitConditionalNot(ConditionalNotNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        boolean storeChanged = !input.getThenStore().equals(input.getElseStore());
        return AbstractNullnessPropagationTransfer.conditionalResult(input.getElseStore(), input.getThenStore(), storeChanged);
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitObjectCreation(ObjectCreationNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitObjectCreation();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitObjectCreation() {
        return Nullness.NULLABLE;
    }

    private static TransferResult<Nullness, AccessPathStore<Nullness>> noStoreChanges(Nullness value, TransferInput<?, AccessPathStore<Nullness>> input) {
        return new RegularTransferResult<Nullness, AccessPathStore<Nullness>>(value, input.getRegularStore());
    }

    @CheckReturnValue
    private TransferResult<Nullness, AccessPathStore<Nullness>> updateRegularStore(Nullness value, TransferInput<?, AccessPathStore<Nullness>> input, ReadableUpdates updates) {
        ResultingStore newStore = AbstractNullnessPropagationTransfer.updateStore(input.getRegularStore(), updates);
        return new RegularTransferResult<Nullness, AccessPathStore<Nullness>>(value, newStore.store, newStore.storeChanged);
    }

    private static TransferResult<Nullness, AccessPathStore<Nullness>> conditionalResult(AccessPathStore<Nullness> thenStore, AccessPathStore<Nullness> elseStore, boolean storeChanged) {
        return new ConditionalTransferResult<Nullness, AccessPathStore<Nullness>>(Nullness.NONNULL, thenStore, elseStore, storeChanged);
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitShortLiteral(ShortLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitShortLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitShortLiteral() {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitIntegerLiteral(IntegerLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitIntegerLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitIntegerLiteral() {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitLongLiteral(LongLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitLongLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitLongLiteral() {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitFloatLiteral(FloatLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitFloatLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitFloatLiteral() {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitDoubleLiteral(DoubleLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitDoubleLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitDoubleLiteral() {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitBooleanLiteral(BooleanLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitBooleanLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitBooleanLiteral() {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitCharacterLiteral(CharacterLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitCharacterLiteral(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitCharacterLiteral(CharacterLiteralNode node, SubNodeValues inputs, Updates updates) {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitStringLiteral(StringLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitStringLiteral(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitStringLiteral(StringLiteralNode node, SubNodeValues inputs, Updates updates) {
        return this.visitValueLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNumericalMinus(NumericalMinusNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitNumericalMinus();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalMinus() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNumericalPlus(NumericalPlusNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitNumericalPlus();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalPlus() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitBitwiseComplement(BitwiseComplementNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitBitwiseComplement();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseComplement() {
        return this.visitBitwiseOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNullChk(NullChkNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitNullChk();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNullChk() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitStringConcatenate(StringConcatenateNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitStringConcatenate();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitStringConcatenate() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNumericalSubtraction(NumericalSubtractionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitNumericalSubtraction();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalSubtraction() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitNumericalMultiplication(NumericalMultiplicationNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitNumericalMultiplication();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalMultiplication() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitIntegerDivision(IntegerDivisionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitIntegerDivision();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitIntegerDivision() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitFloatingDivision(FloatingDivisionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitFloatingDivision();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitFloatingDivision() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitIntegerRemainder(IntegerRemainderNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitIntegerRemainder();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitIntegerRemainder() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitFloatingRemainder(FloatingRemainderNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitFloatingRemainder();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitFloatingRemainder() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitLeftShift(LeftShiftNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitLeftShift();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitLeftShift() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitSignedRightShift(SignedRightShiftNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitSignedRightShift();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitSignedRightShift() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitUnsignedRightShift(UnsignedRightShiftNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitUnsignedRightShift();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitUnsignedRightShift() {
        return this.visitNumericalOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitBitwiseAnd(BitwiseAndNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitBitwiseAnd();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseAnd() {
        return this.visitBitwiseOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitBitwiseOr(BitwiseOrNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitBitwiseOr();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseOr() {
        return this.visitBitwiseOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitBitwiseXor(BitwiseXorNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitBitwiseXor();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseXor() {
        return this.visitBitwiseOperation();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitStringConcatenateAssignment(StringConcatenateAssignmentNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitStringConcatenateAssignment();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitStringConcatenateAssignment() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitLessThan(LessThanNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitLessThan();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitLessThan() {
        return this.visitNumericalComparison();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitLessThanOrEqual(LessThanOrEqualNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitLessThanOrEqual();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitLessThanOrEqual() {
        return this.visitNumericalComparison();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitGreaterThan(GreaterThanNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitGreaterThan();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitGreaterThan() {
        return this.visitNumericalComparison();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitGreaterThanOrEqual(GreaterThanOrEqualNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitGreaterThanOrEqual();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitGreaterThanOrEqual() {
        return this.visitNumericalComparison();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitTernaryExpression(TernaryExpressionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitTernaryExpression(node, AbstractNullnessPropagationTransfer.values(input));
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    @Override
    Nullness visitTernaryExpression(TernaryExpressionNode node, SubNodeValues inputs) {
        return inputs.valueOfSubNode(node.getThenOperand()).leastUpperBound(inputs.valueOfSubNode(node.getElseOperand()));
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitVariableDeclaration(VariableDeclarationNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        this.visitVariableDeclaration(node, AbstractNullnessPropagationTransfer.values(input), updates);
        Nullness result = Nullness.BOTTOM;
        return this.updateRegularStore(result, input, updates);
    }

    void visitVariableDeclaration(VariableDeclarationNode node, SubNodeValues inputs, Updates updates) {
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitMethodAccess(MethodAccessNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitMethodAccess();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitMethodAccess() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitArrayAccess(ArrayAccessNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitArrayAccess(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitArrayAccess(ArrayAccessNode node, SubNodeValues inputs, Updates updates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitImplicitThisLiteral(ImplicitThisLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitImplicitThisLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitImplicitThisLiteral() {
        return this.visitThisLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitExplicitThisLiteral(ExplicitThisLiteralNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitExplicitThisLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitExplicitThisLiteral() {
        return this.visitThisLiteral();
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitSuper(SuperNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitSuper();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitSuper() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitReturn(ReturnNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitReturn();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitReturn() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitLambdaResultExpression(LambdaResultExpressionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitLambdaResultExpression();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitLambdaResultExpression() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitStringConversion(StringConversionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitStringConversion();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitStringConversion() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitWideningConversion(WideningConversionNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitWideningConversion();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitWideningConversion() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitInstanceOf(InstanceOfNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        Nullness result = this.visitInstanceOf(node, AbstractNullnessPropagationTransfer.values(input), thenUpdates, elseUpdates);
        ResultingStore thenStore = AbstractNullnessPropagationTransfer.updateStore(input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AbstractNullnessPropagationTransfer.updateStore(input.getElseStore(), elseUpdates);
        return new ConditionalTransferResult<Nullness, AccessPathStore<Nullness>>(result, thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
    }

    Nullness visitInstanceOf(InstanceOfNode node, SubNodeValues inputs, Updates thenUpdates, Updates elseUpdates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitSynchronized(SynchronizedNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitSynchronized(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitSynchronized(SynchronizedNode node, SubNodeValues inputs, Updates updates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitAssertionError(AssertionErrorNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitAssertionError();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitAssertionError() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitThrow(ThrowNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitThrow(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitThrow(ThrowNode node, SubNodeValues inputs, Updates updates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitCase(CaseNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitCase();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitCase() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitMemberReference(FunctionalInterfaceNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitMemberReference(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitMemberReference(FunctionalInterfaceNode node, SubNodeValues inputs, Updates updates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitArrayCreation(ArrayCreationNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitArrayCreation(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitArrayCreation(ArrayCreationNode node, SubNodeValues inputs, Updates updates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitArrayType(ArrayTypeNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitArrayType();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitArrayType() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitPrimitiveType(PrimitiveTypeNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitPrimitiveType();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitPrimitiveType() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitClassName(ClassNameNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitClassName();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitClassName() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitPackageName(PackageNameNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitPackageName();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitPackageName() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitParameterizedType(ParameterizedTypeNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness value = this.visitParameterizedType();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitParameterizedType() {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitMarker(MarkerNode node, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Nullness result = this.visitMarker(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitMarker(MarkerNode node, SubNodeValues inputs, Updates updates) {
        return Nullness.NULLABLE;
    }

    @Override
    public final TransferResult<Nullness, AccessPathStore<Nullness>> visitClassDeclaration(ClassDeclarationNode classDeclarationNode, TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        Nullness result = this.visitClassDeclaration();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitClassDeclaration() {
        return Nullness.NULLABLE;
    }

    @CheckReturnValue
    private static ResultingStore updateStore(AccessPathStore<Nullness> oldStore, ReadableUpdates ... updates) {
        AccessPathStore<Nullness> newStore;
        AccessPathStore.Builder<Nullness> builder = oldStore.toBuilder();
        for (ReadableUpdates update : updates) {
            for (Map.Entry<AccessPath, Nullness> entry : update.values.entrySet()) {
                builder.setInformation(entry.getKey(), (Nullness)((AbstractValue)entry.getValue()));
            }
        }
        return new ResultingStore(newStore, !(newStore = builder.build()).equals(oldStore));
    }

    private static SubNodeValues values(TransferInput<Nullness, AccessPathStore<Nullness>> input) {
        return input::getValueOfSubNode;
    }

    private static final class ResultingStore {
        final AccessPathStore<Nullness> store;
        final boolean storeChanged;

        ResultingStore(AccessPathStore<Nullness> store, boolean storeChanged) {
            this.store = store;
            this.storeChanged = storeChanged;
        }
    }

    private static final class ReadableUpdates
    implements Updates {
        final Map<AccessPath, Nullness> values = new HashMap<AccessPath, Nullness>();

        private ReadableUpdates() {
        }

        @Override
        public void set(LocalVariableNode node, Nullness value) {
            this.values.put(AccessPath.fromLocalVariable(node), Preconditions.checkNotNull(value));
        }

        @Override
        public void set(VariableDeclarationNode node, Nullness value) {
            this.values.put(AccessPath.fromVariableDecl(node), Preconditions.checkNotNull(value));
        }

        @Override
        public void set(FieldAccessNode node, Nullness value) {
            AccessPath path = AccessPath.fromFieldAccess(node);
            if (path != null) {
                this.values.put(path, Preconditions.checkNotNull(value));
            }
        }

        @Override
        public void set(AccessPath path, Nullness value) {
            this.values.put(Preconditions.checkNotNull(path), Preconditions.checkNotNull(value));
        }
    }

    static interface Updates {
        public void set(LocalVariableNode var1, Nullness var2);

        public void set(VariableDeclarationNode var1, Nullness var2);

        public void set(FieldAccessNode var1, Nullness var2);

        public void set(AccessPath var1, Nullness var2);
    }

    static interface SubNodeValues {
        public Nullness valueOfSubNode(Node var1);
    }
}

