/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.dataflow.AccessPath;
import com.google.errorprone.dataflow.AccessPathStore;
import com.google.errorprone.dataflow.AccessPathValues;
import com.google.errorprone.dataflow.LocalVariableValues;
import com.google.errorprone.dataflow.nullnesspropagation.AbstractNullnessPropagationTransfer;
import com.google.errorprone.dataflow.nullnesspropagation.MethodInfo;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.inference.InferredNullability;
import com.google.errorprone.dataflow.nullnesspropagation.inference.NullnessQualifierInference;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.javacutil.TreeUtils;

class NullnessPropagationTransfer
extends AbstractNullnessPropagationTransfer
implements Serializable {
    private static final long serialVersionUID = -2413953917354086984L;
    private final transient Set<Symbol.VarSymbol> traversed = new HashSet<Symbol.VarSymbol>();
    protected final Nullness defaultAssumption;
    private final Predicate<MethodInfo> methodReturnsNonNull;
    private transient Context context;
    private transient CompilationUnitTree compilationUnit;
    @Nullable
    private transient InferredNullability inferenceResults;
    @VisibleForTesting
    static final ImmutableSet<String> CLASSES_WITH_NON_NULL_CONSTANTS = ImmutableSet.of(BigInteger.class.getName(), BigDecimal.class.getName(), UnsignedInteger.class.getName(), UnsignedLong.class.getName(), StandardCharsets.class.getName());
    @VisibleForTesting
    static final ImmutableSetMultimap<MemberName, Integer> REQUIRED_NON_NULL_PARAMETERS = ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)new ImmutableSetMultimap.Builder().put(NullnessPropagationTransfer.member(Objects.class, "requireNonNull"), (Object)0)).put(NullnessPropagationTransfer.member(Preconditions.class, "checkNotNull"), (Object)0)).put(NullnessPropagationTransfer.member(Verify.class, "verifyNotNull"), (Object)0)).put(NullnessPropagationTransfer.member("junit.framework.Assert", "assertNotNull"), (Object)-1)).put(NullnessPropagationTransfer.member("org.junit.Assert", "assertNotNull"), (Object)-1)).build();
    @VisibleForTesting
    static final ImmutableSetMultimap<MemberName, Integer> NULL_IMPLIES_TRUE_PARAMETERS = ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)new ImmutableSetMultimap.Builder().put(NullnessPropagationTransfer.member(Strings.class, "isNullOrEmpty"), (Object)0)).put(NullnessPropagationTransfer.member("android.text.TextUtils", "isEmpty"), (Object)0)).build();
    private static final ImmutableSetMultimap<MemberName, Integer> NONNULL_IFF_TRUE_PARAMETERS = ((ImmutableSetMultimap.Builder)new ImmutableSetMultimap.Builder().put(NullnessPropagationTransfer.member(Objects.class, "nonNull"), (Object)0)).build();
    private static final ImmutableSetMultimap<MemberName, Integer> NULL_IFF_TRUE_PARAMETERS = ((ImmutableSetMultimap.Builder)new ImmutableSetMultimap.Builder().put(NullnessPropagationTransfer.member(Objects.class, "isNull"), (Object)0)).build();

    @Override
    public AccessPathStore<Nullness> initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        if (parameters == null) {
            return AccessPathStore.empty();
        }
        AccessPathStore.Builder<Nullness> result = AccessPathStore.empty().toBuilder();
        for (LocalVariableNode param : parameters) {
            Nullness declared = Nullness.fromAnnotationsOn((Symbol)param.getElement()).orElse(this.defaultAssumption);
            result.setInformation(AccessPath.fromLocalVariable(param), declared);
        }
        return result.build();
    }

    private Nullness getInferredNullness(MethodInvocationNode node, ClassAndMethod callee) {
        Nullness baselineNullness;
        Nullness nullness = baselineNullness = this.methodReturnsNonNull.apply(callee) ? Nullness.NONNULL : Nullness.NULLABLE;
        if (!callee.isGenericResult) {
            return baselineNullness;
        }
        if (this.inferenceResults == null) {
            TreePath pathToNode = node.getTreePath();
            Tree procedureTree = TreeUtils.enclosingOfClass(pathToNode, LambdaExpressionTree.class);
            if (procedureTree == null) {
                procedureTree = TreeUtils.enclosingOfClass(pathToNode, MethodTree.class);
            }
            if (procedureTree == null) {
                procedureTree = TreeUtils.enclosingOfClass(pathToNode, BlockTree.class);
            }
            if (procedureTree == null) {
                procedureTree = TreeUtils.enclosingOfClass(pathToNode, VariableTree.class);
            }
            this.inferenceResults = NullnessQualifierInference.getInferredNullability(Preconditions.checkNotNull(procedureTree, "Call `%s` is not contained in an lambda, initializer or method.", (Object)node));
        }
        return this.inferenceResults.getExprNullness(node.getTree()).orElse(baselineNullness);
    }

    public NullnessPropagationTransfer() {
        this(Nullness.NULLABLE, new ReturnValueIsNonNull());
    }

    public NullnessPropagationTransfer(Predicate<MethodInfo> additionalNonNullReturningMethods) {
        this(Nullness.NULLABLE, Predicates.or(new ReturnValueIsNonNull(), additionalNonNullReturningMethods));
    }

    protected NullnessPropagationTransfer(Nullness defaultAssumption, Predicate<MethodInfo> methodReturnsNonNull) {
        this.defaultAssumption = defaultAssumption;
        this.methodReturnsNonNull = methodReturnsNonNull;
    }

    NullnessPropagationTransfer setContext(@Nullable Context context) {
        Preconditions.checkArgument(context == null || this.context == null, "Context already set: reset after use and don't use this class concurrently");
        this.context = context;
        this.traversed.clear();
        this.inferenceResults = null;
        return this;
    }

    NullnessPropagationTransfer setCompilationUnit(@Nullable CompilationUnitTree compilationUnit) {
        this.compilationUnit = compilationUnit;
        return this;
    }

    @Override
    Nullness visitThisLiteral() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitSuper() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitValueLiteral() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNullLiteral() {
        return Nullness.NULL;
    }

    @Override
    Nullness visitBitwiseOperation() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNumericalComparison() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNumericalOperation() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitInstanceOf(InstanceOfNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates thenUpdates, AbstractNullnessPropagationTransfer.Updates elseUpdates) {
        NullnessPropagationTransfer.setNonnullIfTrackable(thenUpdates, node.getOperand());
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitTypeCast(TypeCastNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs) {
        ImmutableList<String> annotations = node.getType().getAnnotationMirrors().stream().map(Object::toString).collect(ImmutableList.toImmutableList());
        return Nullness.fromAnnotations(annotations).orElseGet(() -> NullnessPropagationTransfer.hasPrimitiveType(node) ? Nullness.NONNULL : inputs.valueOfSubNode(node.getOperand()));
    }

    @Override
    Nullness visitStringConcatenate() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitStringConversion() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitNarrowingConversion() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitWideningConversion() {
        return Nullness.NONNULL;
    }

    @Override
    void visitEqualTo(EqualToNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates thenUpdates, AbstractNullnessPropagationTransfer.Updates elseUpdates) {
        NullnessPropagationTransfer.handleEqualityComparison(true, node.getLeftOperand(), node.getRightOperand(), inputs, thenUpdates, elseUpdates);
    }

    @Override
    void visitNotEqual(NotEqualNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates thenUpdates, AbstractNullnessPropagationTransfer.Updates elseUpdates) {
        NullnessPropagationTransfer.handleEqualityComparison(false, node.getLeftOperand(), node.getRightOperand(), inputs, thenUpdates, elseUpdates);
    }

    @Override
    Nullness visitAssignment(AssignmentNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates updates) {
        Nullness value = inputs.valueOfSubNode(node.getExpression());
        Node target = node.getTarget();
        if (target instanceof LocalVariableNode) {
            updates.set((LocalVariableNode)target, value);
        }
        if (target instanceof ArrayAccessNode) {
            NullnessPropagationTransfer.setNonnullIfTrackable(updates, ((ArrayAccessNode)target).getArray());
        }
        if (target instanceof FieldAccessNode) {
            FieldAccessNode fieldAccess = (FieldAccessNode)target;
            if (!fieldAccess.isStatic()) {
                NullnessPropagationTransfer.setNonnullIfTrackable(updates, fieldAccess.getReceiver());
            }
            updates.set(fieldAccess, value);
        }
        return value;
    }

    @Override
    Nullness visitLocalVariable(LocalVariableNode node, LocalVariableValues<Nullness> values) {
        return NullnessPropagationTransfer.hasPrimitiveType(node) || NullnessPropagationTransfer.hasNonNullConstantValue(node) ? Nullness.NONNULL : values.valueOfLocalVariable(node, this.defaultAssumption);
    }

    @Override
    Nullness visitFieldAccess(FieldAccessNode node, AbstractNullnessPropagationTransfer.Updates updates, AccessPathValues<Nullness> store) {
        if (!node.isStatic()) {
            NullnessPropagationTransfer.setNonnullIfTrackable(updates, node.getReceiver());
        }
        ClassAndField accessed = NullnessPropagationTransfer.tryGetFieldSymbol(node.getTree());
        return this.fieldNullness(accessed, AccessPath.fromFieldAccess(node), store);
    }

    @Override
    Nullness visitArrayAccess(ArrayAccessNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates updates) {
        NullnessPropagationTransfer.setNonnullIfTrackable(updates, node.getArray());
        return NullnessPropagationTransfer.hasPrimitiveType(node) ? Nullness.NONNULL : this.defaultAssumption;
    }

    @Override
    Nullness visitMethodInvocation(MethodInvocationNode node, AbstractNullnessPropagationTransfer.Updates thenUpdates, AbstractNullnessPropagationTransfer.Updates elseUpdates, AbstractNullnessPropagationTransfer.Updates bothUpdates) {
        ClassAndMethod callee = NullnessPropagationTransfer.tryGetMethodSymbol(node.getTree(), Types.instance(this.context));
        if (callee != null && !callee.isStatic) {
            NullnessPropagationTransfer.setNonnullIfTrackable(bothUpdates, node.getTarget().getReceiver());
        }
        NullnessPropagationTransfer.setUnconditionalArgumentNullness(bothUpdates, node.getArguments(), callee);
        NullnessPropagationTransfer.setConditionalArgumentNullness(thenUpdates, elseUpdates, node.getArguments(), callee, Types.instance(this.context), Symtab.instance(this.context));
        return this.returnValueNullness(node, callee);
    }

    @Override
    Nullness visitObjectCreation() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitClassDeclaration() {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitArrayCreation(ArrayCreationNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates updates) {
        return Nullness.NONNULL;
    }

    @Override
    Nullness visitMemberReference(FunctionalInterfaceNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates updates) {
        return Nullness.NONNULL;
    }

    @Override
    void visitVariableDeclaration(VariableDeclarationNode node, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates updates) {
        if (NullnessPropagationTransfer.isCatchVariable(node)) {
            updates.set(node, Nullness.NONNULL);
        }
    }

    private static boolean isCatchVariable(VariableDeclarationNode node) {
        return TreeUtils.elementFromDeclaration(node.getTree()).getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    private static void handleEqualityComparison(boolean equalTo, Node leftNode, Node rightNode, AbstractNullnessPropagationTransfer.SubNodeValues inputs, AbstractNullnessPropagationTransfer.Updates thenUpdates, AbstractNullnessPropagationTransfer.Updates elseUpdates) {
        Nullness leftVal = inputs.valueOfSubNode(leftNode);
        Nullness rightVal = inputs.valueOfSubNode(rightNode);
        Nullness equalBranchValue = leftVal.greatestLowerBound(rightVal);
        AbstractNullnessPropagationTransfer.Updates equalBranchUpdates = equalTo ? thenUpdates : elseUpdates;
        AbstractNullnessPropagationTransfer.Updates notEqualBranchUpdates = equalTo ? elseUpdates : thenUpdates;
        AccessPath leftOperand = AccessPath.fromNodeIfTrackable(leftNode);
        AccessPath rightOperand = AccessPath.fromNodeIfTrackable(rightNode);
        if (leftOperand != null) {
            equalBranchUpdates.set(leftOperand, equalBranchValue);
            notEqualBranchUpdates.set(leftOperand, leftVal.greatestLowerBound(rightVal.deducedValueWhenNotEqual()));
        }
        if (rightOperand != null) {
            equalBranchUpdates.set(rightOperand, equalBranchValue);
            notEqualBranchUpdates.set(rightOperand, rightVal.greatestLowerBound(leftVal.deducedValueWhenNotEqual()));
        }
    }

    private static boolean hasPrimitiveType(Node node) {
        return node.getType().getKind().isPrimitive();
    }

    private static boolean hasNonNullConstantValue(LocalVariableNode node) {
        if (node.getElement() instanceof VariableElement) {
            VariableElement element = (VariableElement)node.getElement();
            return element.getConstantValue() != null;
        }
        return false;
    }

    private static ClassAndField tryGetFieldSymbol(Tree tree) {
        Symbol symbol = NullnessPropagationTransfer.tryGetSymbol(tree);
        if (symbol instanceof Symbol.VarSymbol) {
            return ClassAndField.make((Symbol.VarSymbol)symbol);
        }
        return null;
    }

    static ClassAndMethod tryGetMethodSymbol(MethodInvocationTree tree, Types types) {
        Symbol symbol = NullnessPropagationTransfer.tryGetSymbol(tree.getMethodSelect());
        if (symbol instanceof Symbol.MethodSymbol) {
            return ClassAndMethod.make((Symbol.MethodSymbol)symbol, types);
        }
        return null;
    }

    private static Symbol tryGetSymbol(Tree tree) {
        if (tree instanceof JCTree.JCIdent) {
            return ((JCTree.JCIdent)tree).sym;
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)tree).sym;
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            return ((JCTree.JCVariableDecl)tree).sym;
        }
        return null;
    }

    Nullness fieldNullness(ClassAndField accessed, @Nullable AccessPath path, AccessPathValues<Nullness> store) {
        Nullness dataflowResult;
        if (accessed == null) {
            return this.defaultAssumption;
        }
        if (accessed.field.equals("class")) {
            return Nullness.NONNULL;
        }
        if (accessed.isEnumConstant()) {
            return Nullness.NONNULL;
        }
        if (accessed.isPrimitive()) {
            return Nullness.NONNULL;
        }
        if (accessed.hasNonNullConstantValue()) {
            return Nullness.NONNULL;
        }
        if (accessed.isStatic() && accessed.isFinal()) {
            if (CLASSES_WITH_NON_NULL_CONSTANTS.contains(accessed.clazz)) {
                return Nullness.NONNULL;
            }
            Nullness initializer = this.fieldInitializerNullnessIfAvailable(accessed);
            if (initializer != null) {
                return initializer;
            }
        }
        Nullness nullness = dataflowResult = path == null ? Nullness.BOTTOM : store.valueOfAccessPath(path, Nullness.BOTTOM);
        if (dataflowResult != Nullness.BOTTOM) {
            return dataflowResult;
        }
        Optional<Nullness> declaredNullness = Nullness.fromAnnotations(MoreAnnotations.getDeclarationAndTypeAttributes(accessed.symbol).map(Object::toString).collect(ImmutableList.toImmutableList()));
        return declaredNullness.orElseGet(() -> Nullness.fromAnnotations(NullnessPropagationTransfer.inheritedAnnotations(accessed.symbol.type)).orElse(this.defaultAssumption));
    }

    private Nullness returnValueNullness(MethodInvocationNode node, @Nullable ClassAndMethod callee) {
        if (callee == null) {
            return this.defaultAssumption;
        }
        Optional<Nullness> declaredNullness = Nullness.fromAnnotations(callee.annotations);
        if (declaredNullness.isPresent()) {
            return declaredNullness.get();
        }
        if (AccessPath.isAutoValueAccessor(node.getTree())) {
            return Nullness.NONNULL;
        }
        ImmutableCollection annotations = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(NullnessPropagationTransfer.inheritedAnnotations(node.getTarget().getMethod().getReturnType()))).addAll((Iterable)node.getType().getAnnotationMirrors().stream().map(Object::toString).collect(ImmutableList.toImmutableList()))).build();
        return this.getInferredNullness(node, callee).greatestLowerBound(Nullness.fromAnnotations(annotations).orElse(Nullness.NULLABLE));
    }

    private static ImmutableList<String> inheritedAnnotations(TypeMirror type) {
        ImmutableSet.Builder inheritedAnnotations = ImmutableSet.builder();
        inheritedAnnotations.addAll(type.getAnnotationMirrors());
        if (type.getKind() == TypeKind.TYPEVAR) {
            Element genericElt;
            TypeVariable typeVar = (TypeVariable)type;
            inheritedAnnotations.addAll(typeVar.getUpperBound().getAnnotationMirrors());
            if (typeVar.asElement().getKind() == ElementKind.TYPE_PARAMETER && ((genericElt = ((TypeParameterElement)typeVar.asElement()).getGenericElement()).getKind().isClass() || genericElt.getKind().isInterface())) {
                ((TypeElement)genericElt).getTypeParameters().stream().filter(typeParam -> typeParam.getSimpleName().equals(typeVar.asElement().getSimpleName())).findFirst().ifPresent(decl -> inheritedAnnotations.addAll(decl.getAnnotationMirrors()));
            }
        }
        return inheritedAnnotations.build().stream().map(Object::toString).collect(ImmutableList.toImmutableList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Nullness fieldInitializerNullnessIfAvailable(ClassAndField accessed) {
        if (!this.traversed.add(accessed.symbol)) {
            return Nullness.NULL;
        }
        try {
            JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(this.context);
            TreePath fieldDeclPath = Trees.instance(javacEnv).getPath(accessed.symbol);
            if (fieldDeclPath == null || fieldDeclPath.getCompilationUnit() != this.compilationUnit || !(fieldDeclPath.getLeaf() instanceof VariableTree)) {
                Nullness nullness = null;
                return nullness;
            }
            ExpressionTree initializer = ((VariableTree)fieldDeclPath.getLeaf()).getInitializer();
            if (initializer == null) {
                Nullness nullness = null;
                return nullness;
            }
            ClassTree classTree = (ClassTree)fieldDeclPath.getParentPath().getLeaf();
            TreePath initializerPath = TreePath.getPath(fieldDeclPath, (Tree)initializer);
            UnderlyingAST.CFGStatement ast = new UnderlyingAST.CFGStatement(initializerPath.getLeaf(), classTree);
            ControlFlowGraph cfg = CFGBuilder.build(initializerPath, (UnderlyingAST)ast, false, false, (ProcessingEnvironment)javacEnv);
            Analysis analysis = new Analysis(this, javacEnv);
            analysis.performAnalysis(cfg);
            Nullness nullness = (Nullness)analysis.getValue(initializerPath.getLeaf());
            return nullness;
        }
        finally {
            this.traversed.remove(accessed.symbol);
        }
    }

    private static void setNonnullIfTrackable(AbstractNullnessPropagationTransfer.Updates updates, Node node) {
        if (node instanceof LocalVariableNode) {
            updates.set((LocalVariableNode)node, Nullness.NONNULL);
        } else if (node instanceof FieldAccessNode) {
            updates.set((FieldAccessNode)node, Nullness.NONNULL);
        } else if (node instanceof VariableDeclarationNode) {
            updates.set((VariableDeclarationNode)node, Nullness.NONNULL);
        }
    }

    private static void setUnconditionalArgumentNullness(AbstractNullnessPropagationTransfer.Updates bothUpdates, List<Node> arguments, ClassAndMethod callee) {
        ImmutableCollection requiredNonNullParameters = REQUIRED_NON_NULL_PARAMETERS.get((Object)callee.name());
        for (LocalVariableNode var : NullnessPropagationTransfer.variablesAtIndexes((Set<Integer>)((Object)requiredNonNullParameters), arguments)) {
            bothUpdates.set(var, Nullness.NONNULL);
        }
    }

    private static void setConditionalArgumentNullness(AbstractNullnessPropagationTransfer.Updates thenUpdates, AbstractNullnessPropagationTransfer.Updates elseUpdates, List<Node> arguments, ClassAndMethod callee, Types types, Symtab symtab) {
        MemberName calleeName = callee.name();
        for (LocalVariableNode var : NullnessPropagationTransfer.variablesAtIndexes((Set<Integer>)((Object)NULL_IMPLIES_TRUE_PARAMETERS.get((Object)calleeName)), arguments)) {
            elseUpdates.set(var, Nullness.NONNULL);
        }
        for (LocalVariableNode var : NullnessPropagationTransfer.variablesAtIndexes((Set<Integer>)((Object)NONNULL_IFF_TRUE_PARAMETERS.get((Object)calleeName)), arguments)) {
            thenUpdates.set(var, Nullness.NONNULL);
            elseUpdates.set(var, Nullness.NULL);
        }
        for (LocalVariableNode var : NullnessPropagationTransfer.variablesAtIndexes((Set<Integer>)((Object)NULL_IFF_TRUE_PARAMETERS.get((Object)calleeName)), arguments)) {
            thenUpdates.set(var, Nullness.NULL);
            elseUpdates.set(var, Nullness.NONNULL);
        }
        if (NullnessPropagationTransfer.isEqualsMethod(calleeName, arguments, types, symtab)) {
            LocalVariableNode var = NullnessPropagationTransfer.variablesAtIndexes(ImmutableSet.of(Integer.valueOf(0)), arguments).get(0);
            thenUpdates.set(var, Nullness.NONNULL);
        }
    }

    private static boolean isEqualsMethod(MemberName calleeName, List<Node> arguments, Types types, Symtab symtab) {
        if (!calleeName.member.equals("equals") || arguments.size() != 1) {
            return false;
        }
        if (!(Iterables.getOnlyElement(arguments).getTree() instanceof JCTree.JCIdent)) {
            return false;
        }
        Symbol sym = ((JCTree.JCIdent)Iterables.getOnlyElement(arguments).getTree()).sym;
        if (sym == null || sym.type == null) {
            return false;
        }
        return types.isSameType(sym.type, symtab.objectType) && !NullnessPropagationTransfer.variablesAtIndexes(ImmutableSet.of(Integer.valueOf(0)), arguments).isEmpty();
    }

    private static List<LocalVariableNode> variablesAtIndexes(Set<Integer> indexes, List<Node> arguments) {
        ArrayList<LocalVariableNode> result = new ArrayList<LocalVariableNode>();
        for (Integer i : indexes) {
            Node argument;
            if (i < 0) {
                i = arguments.size() + i;
            }
            if (i < 0 || i >= arguments.size() || !((argument = arguments.get(i)) instanceof LocalVariableNode)) continue;
            result.add((LocalVariableNode)argument);
        }
        return result;
    }

    private static MemberName member(Class<?> clazz, String member) {
        return NullnessPropagationTransfer.member(clazz.getName(), member);
    }

    private static MemberName member(String clazz, String member) {
        return new MemberName(clazz, member);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Preconditions.checkState(this.context == null, "Can't serialize while analyzing a method");
        Preconditions.checkState(this.compilationUnit == null, "Can't serialize while analyzing a method");
        out.defaultWriteObject();
    }

    static /* synthetic */ MemberName access$000(String x0, String x1) {
        return NullnessPropagationTransfer.member(x0, x1);
    }

    static final class ClassAndField
    implements Member {
        final Symbol.VarSymbol symbol;
        final String clazz;
        final String field;

        private ClassAndField(Symbol.VarSymbol symbol) {
            this.symbol = symbol;
            this.clazz = symbol.owner.getQualifiedName().toString();
            this.field = ((Name)symbol.getSimpleName()).toString();
        }

        static ClassAndField make(Symbol.VarSymbol symbol) {
            return new ClassAndField(symbol);
        }

        @Override
        public boolean isStatic() {
            return this.symbol.isStatic();
        }

        public boolean isFinal() {
            return (this.symbol.flags() & 0x10L) == 16L;
        }

        public boolean isPrimitive() {
            return this.symbol.type.isPrimitive();
        }

        public boolean isEnumConstant() {
            return this.symbol.isEnum();
        }

        public boolean hasNonNullConstantValue() {
            return this.symbol.getConstValue() != null;
        }
    }

    static final class ClassAndMethod
    implements Member,
    MethodInfo {
        final String clazz;
        final String method;
        final ImmutableList<String> annotations;
        final boolean isStatic;
        final boolean isPrimitive;
        final boolean isBoolean;
        final boolean isGenericResult;
        final boolean isNonNullReturning;

        private ClassAndMethod(String clazz, String method, ImmutableList<String> annotations, boolean isStatic, boolean isPrimitive, boolean isBoolean, boolean isGenericResult, boolean isNonNullReturning) {
            this.clazz = clazz;
            this.method = method;
            this.annotations = annotations;
            this.isStatic = isStatic;
            this.isPrimitive = isPrimitive;
            this.isBoolean = isBoolean;
            this.isGenericResult = isGenericResult;
            this.isNonNullReturning = isNonNullReturning;
        }

        static ClassAndMethod make(Symbol.MethodSymbol methodSymbol, @Nullable Types types) {
            ImmutableList<String> annotations = MoreAnnotations.getDeclarationAndTypeAttributes(methodSymbol).map(c -> c.getAnnotationType().asElement().toString()).collect(ImmutableList.toImmutableList());
            Symbol.ClassSymbol clazzSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
            return new ClassAndMethod(clazzSymbol.getQualifiedName().toString(), ((Name)methodSymbol.getSimpleName()).toString(), annotations, methodSymbol.isStatic(), methodSymbol.getReturnType().isPrimitive(), methodSymbol.getReturnType().getTag() == TypeTag.BOOLEAN, ClassAndMethod.hasGenericResult(methodSymbol), ClassAndMethod.knownNonNullMethod(methodSymbol, clazzSymbol, types));
        }

        private static boolean hasGenericResult(Symbol.MethodSymbol methodSymbol) {
            Type resultType = methodSymbol.getReturnType();
            for (Symbol.TypeVariableSymbol var : methodSymbol.getTypeParameters()) {
                if (!resultType.tsym.equals(var)) continue;
                return true;
            }
            return false;
        }

        private static boolean knownNonNullMethod(Symbol.MethodSymbol methodSymbol, Symbol.ClassSymbol clazzSymbol, @Nullable Types types) {
            if (types == null) {
                return false;
            }
            if (methodSymbol.name.toString().startsWith("get") && methodSymbol.params().isEmpty() && !methodSymbol.isStatic()) {
                Symbol.TypeSymbol typeSymbol;
                Type type = clazzSymbol.type;
                while (type != null && (typeSymbol = type.asElement()) != null) {
                    if (typeSymbol.getQualifiedName().contentEquals("com.google.protobuf.AbstractMessageLite")) {
                        return true;
                    }
                    type = types.supertype(type);
                }
            }
            return false;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        MemberName name() {
            return new MemberName(this.clazz, this.method);
        }

        @Override
        public String clazz() {
            return this.clazz;
        }

        @Override
        public String method() {
            return this.method;
        }

        public ImmutableList<String> annotations() {
            return this.annotations;
        }

        @Override
        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        @Override
        public boolean isKnownNonNullReturning() {
            return this.isNonNullReturning;
        }
    }

    @VisibleForTesting
    static final class MemberName {
        final String clazz;
        final String member;

        MemberName(String clazz, String member) {
            this.clazz = clazz;
            this.member = member;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberName) {
                MemberName other = (MemberName)obj;
                return this.clazz.equals(other.clazz) && this.member.equals(other.member);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.member);
        }
    }

    static interface Member {
        public boolean isStatic();
    }

    private static class ReturnValueIsNonNull
    implements Predicate<MethodInfo>,
    Serializable {
        private static final long serialVersionUID = -6277529478866058532L;
        private static final ImmutableSet<MemberName> METHODS_WITH_NON_NULLABLE_RETURNS = ImmutableSet.of(NullnessPropagationTransfer.access$000(Files.class.getName(), "toString"), NullnessPropagationTransfer.access$000(Class.class.getName(), "getName"), NullnessPropagationTransfer.access$000(Class.class.getName(), "getSimpleName"), NullnessPropagationTransfer.access$000(Class.class.getName(), "forName"), NullnessPropagationTransfer.access$000(Charset.class.getName(), "forName"));
        private static final ImmutableSet<String> CLASSES_WITH_NON_NULLABLE_RETURNS = ImmutableSet.of(com.google.common.base.Optional.class.getName(), Preconditions.class.getName(), Verify.class.getName(), String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), new String[]{UnsignedInteger.class.getName(), UnsignedLong.class.getName(), Objects.class.getName()});
        private static final ImmutableSet<String> CLASSES_WITH_NON_NULLABLE_VALUE_OF_METHODS = ImmutableSet.of(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), new String[]{Long.class.getName(), Short.class.getName(), Enum.class.getName(), String.class.getName()});

        private ReturnValueIsNonNull() {
        }

        @Override
        public boolean apply(MethodInfo methodInfo) {
            for (String annotation2 : methodInfo.annotations()) {
                if (!annotation2.endsWith(".Nullable") && !annotation2.endsWith(".NullableDecl")) continue;
                return false;
            }
            if (methodInfo.method().equals("valueOf") && CLASSES_WITH_NON_NULLABLE_VALUE_OF_METHODS.contains(methodInfo.clazz())) {
                return true;
            }
            if (methodInfo.isPrimitive()) {
                return true;
            }
            if (methodInfo.isKnownNonNullReturning()) {
                return true;
            }
            if (CLASSES_WITH_NON_NULLABLE_RETURNS.contains(methodInfo.clazz())) {
                return true;
            }
            MemberName searchMemberName = new MemberName(methodInfo.clazz(), methodInfo.method());
            return METHODS_WITH_NON_NULLABLE_RETURNS.contains(searchMemberName);
        }
    }
}

