/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.base.Predicate;
import com.google.errorprone.dataflow.AccessPath;
import com.google.errorprone.dataflow.AccessPathValues;
import com.google.errorprone.dataflow.nullnesspropagation.MethodInfo;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessPropagationTransfer;
import javax.annotation.Nullable;

class TrustingNullnessPropagation
extends NullnessPropagationTransfer {
    private static final long serialVersionUID = -3128676755493202966L;

    TrustingNullnessPropagation() {
        super(Nullness.NONNULL, TrustReturnAnnotation.INSTANCE);
    }

    @Override
    Nullness fieldNullness(@Nullable NullnessPropagationTransfer.ClassAndField accessed, @Nullable AccessPath path, AccessPathValues<Nullness> store) {
        if (accessed == null) {
            return Nullness.NONNULL;
        }
        Nullness defaultValue = Nullness.fromAnnotationsOn(accessed.symbol).orElse(this.defaultAssumption);
        return path == null ? defaultValue : store.valueOfAccessPath(path, defaultValue);
    }

    private static enum TrustReturnAnnotation implements Predicate<MethodInfo>
    {
        INSTANCE;


        @Override
        public boolean apply(MethodInfo input) {
            return Nullness.fromAnnotations(input.annotations()).orElse(Nullness.NONNULL) == Nullness.NONNULL;
        }
    }
}

