/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation.inference;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.inference.InferenceVariable;
import com.google.errorprone.dataflow.nullnesspropagation.inference.ProperInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeArgInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeVariableInferenceVar;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.Map;
import java.util.Optional;

public class InferredNullability {
    private final ImmutableGraph<InferenceVariable> constraintGraph;
    private final Map<InferenceVariable, Optional<Nullness>> lowerBoundMemoTable = Maps.newHashMap();
    private final Map<InferenceVariable, Optional<Nullness>> upperBoundMemoTable = Maps.newHashMap();

    InferredNullability(Graph<InferenceVariable> constraints) {
        this.constraintGraph = ImmutableGraph.copyOf(constraints);
    }

    public ImmutableMap<Symbol.TypeVariableSymbol, Nullness> getNullnessGenerics(MethodInvocationTree callsite) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Symbol.TypeVariableSymbol tvs : TreeInfo.symbol((JCTree)((Object)callsite.getMethodSelect())).getTypeParameters()) {
            InferenceVariable iv = TypeVariableInferenceVar.create(tvs, callsite);
            this.getUpperBound(iv).ifPresent(nullness -> result.put(tvs, nullness));
        }
        return result.build();
    }

    public Optional<Nullness> getExprNullness(ExpressionTree exprTree) {
        InferenceVariable iv = TypeArgInferenceVar.create(ImmutableList.of(), exprTree);
        return this.constraintGraph.nodes().contains(iv) ? this.getUpperBound(iv) : Optional.empty();
    }

    private Optional<Nullness> getLowerBound(InferenceVariable iv) {
        if (iv instanceof ProperInferenceVar) {
            return Optional.of(((ProperInferenceVar)iv).nullness());
        }
        Optional<Nullness> result = this.lowerBoundMemoTable.get(iv);
        if (result != null) {
            return result;
        }
        this.lowerBoundMemoTable.put(iv, Optional.empty());
        result = this.constraintGraph.predecessors((Object)iv).stream().map(this::getLowerBound).filter(Optional::isPresent).map(Optional::get).reduce(Nullness::leastUpperBound);
        this.lowerBoundMemoTable.put(iv, result);
        return result;
    }

    private Optional<Nullness> getUpperBound(InferenceVariable iv) {
        if (iv instanceof ProperInferenceVar) {
            return Optional.of(((ProperInferenceVar)iv).nullness());
        }
        Optional<Nullness> result = this.upperBoundMemoTable.get(iv);
        if (result != null) {
            return result;
        }
        this.upperBoundMemoTable.put(iv, Optional.empty());
        result = this.constraintGraph.successors((Object)iv).stream().map(this::getUpperBound).filter(Optional::isPresent).map(Optional::get).reduce(Nullness::greatestLowerBound);
        if (!result.isPresent() && this.getLowerBound(iv).equals(Optional.of(Nullness.NULLABLE))) {
            result = Optional.of(Nullness.NULLABLE);
        }
        this.upperBoundMemoTable.put(iv, result);
        return result;
    }
}

