/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.AbstractSimpleMatcher;
import com.google.errorprone.matchers.method.ConstructorClassMatcherImpl;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

public class ConstructorMatcherImpl
extends AbstractSimpleMatcher<MatchState>
implements MethodMatchers.ConstructorMatcher {
    @Override
    protected Optional<MatchState> matchResult(ExpressionTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ConstructorMatcherImpl.getConstructor(tree);
        if (sym == null) {
            return Optional.absent();
        }
        return Optional.of(MatchState.create(sym.owner.type, sym));
    }

    private static Symbol.MethodSymbol getConstructor(ExpressionTree tree) {
        switch (tree.getKind()) {
            case NEW_CLASS: 
            case METHOD_INVOCATION: {
                break;
            }
            default: {
                return null;
            }
        }
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return null;
        }
        Symbol.MethodSymbol method = (Symbol.MethodSymbol)sym;
        if (!method.isConstructor()) {
            return null;
        }
        return method;
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(TypePredicate typePredicate) {
        return new ConstructorClassMatcherImpl(this, typePredicate);
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(String className) {
        return new ConstructorClassMatcherImpl(this, TypePredicates.isExactType(className));
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(Supplier<Type> classType) {
        return new ConstructorClassMatcherImpl(this, TypePredicates.isExactType(classType));
    }
}

