/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodClassMatcherImpl;
import com.google.errorprone.matchers.method.MethodMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Type;

class InstanceMethodMatcherImpl
extends MethodMatcher
implements MethodMatchers.InstanceMethodMatcher {
    InstanceMethodMatcherImpl() {
    }

    @Override
    protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
        if (method.sym().isStatic()) {
            return Optional.absent();
        }
        return Optional.of(method);
    }

    @Override
    public MethodClassMatcherImpl onClass(TypePredicate predicate) {
        return new MethodClassMatcherImpl(this, predicate);
    }

    @Override
    public MethodClassMatcherImpl onExactClass(String className) {
        return new MethodClassMatcherImpl(this, TypePredicates.isExactType(className));
    }

    @Override
    public MethodClassMatcherImpl onExactClass(Supplier<Type> classType) {
        return new MethodClassMatcherImpl(this, TypePredicates.isExactType(classType));
    }

    @Override
    public MethodClassMatcherImpl onDescendantOf(String className) {
        return new MethodClassMatcherImpl(this, TypePredicates.isDescendantOf(className));
    }

    @Override
    public MethodClassMatcherImpl onDescendantOf(Supplier<Type> classType) {
        return new MethodClassMatcherImpl(this, TypePredicates.isDescendantOf(classType));
    }

    @Override
    public MethodClassMatcherImpl onDescendantOfAny(Iterable<String> classTypes) {
        return new MethodClassMatcherImpl(this, TypePredicates.isDescendantOfAny(classTypes));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOfAny(String ... classTypes) {
        return this.onDescendantOfAny(ImmutableList.copyOf(classTypes));
    }

    @Override
    public MethodClassMatcherImpl anyClass() {
        return new MethodClassMatcherImpl(this, TypePredicates.anyType());
    }
}

