/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.AbstractChainedMatcher;
import com.google.errorprone.matchers.method.AbstractSimpleMatcher;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.matchers.method.MethodNameMatcherImpl;
import com.google.errorprone.matchers.method.MethodSignatureMatcherImpl;
import com.google.errorprone.predicates.TypePredicate;
import com.sun.source.tree.ExpressionTree;
import java.util.regex.Pattern;

class MethodClassMatcherImpl
extends AbstractChainedMatcher<MatchState, MatchState>
implements MethodMatchers.MethodClassMatcher {
    private final TypePredicate predicate;

    MethodClassMatcherImpl(AbstractSimpleMatcher<MatchState> baseMatcher, TypePredicate predicate) {
        super(baseMatcher);
        this.predicate = predicate;
    }

    @Override
    protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
        return this.predicate.apply(method.ownerType(), state) ? Optional.of(method) : Optional.absent();
    }

    @Override
    public MethodMatchers.MethodNameMatcher named(String name) {
        return new MethodNameMatcherImpl.Exact(this, name);
    }

    @Override
    public MethodMatchers.MethodNameMatcher namedAnyOf(String ... names) {
        return this.namedAnyOf(ImmutableList.copyOf(names));
    }

    @Override
    public MethodMatchers.MethodNameMatcher namedAnyOf(Iterable<String> names) {
        return new MethodNameMatcherImpl.AnyOf(this, names);
    }

    @Override
    public MethodMatchers.MethodNameMatcher withAnyName() {
        return new MethodNameMatcherImpl.Any(this);
    }

    @Override
    public MethodMatchers.MethodSignatureMatcher withSignature(String signature) {
        return new MethodSignatureMatcherImpl(this, signature);
    }

    @Override
    public MethodMatchers.MethodNameMatcher withNameMatching(Pattern pattern) {
        return new MethodNameMatcherImpl.Regex(this, pattern);
    }
}

