/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.AbstractChainedMatcher;
import com.google.errorprone.matchers.method.AbstractSimpleMatcher;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Symbol;

abstract class MethodMatcher
extends AbstractChainedMatcher<MatchState, MatchState> {
    private static final AbstractSimpleMatcher<MatchState> BASE_METHOD_MATCHER = new AbstractSimpleMatcher<MatchState>(){

        @Override
        public Optional<MatchState> matchResult(ExpressionTree tree, VisitorState state) {
            Symbol sym = ASTHelpers.getSymbol(tree);
            if (!(sym instanceof Symbol.MethodSymbol)) {
                return Optional.absent();
            }
            if (tree instanceof NewClassTree) {
                return Optional.absent();
            }
            if (tree instanceof MethodInvocationTree) {
                tree = ((MethodInvocationTree)tree).getMethodSelect();
            }
            return Optional.of(MatchState.create(ASTHelpers.getReceiverType(tree), (Symbol.MethodSymbol)sym));
        }
    };

    MethodMatcher() {
        super(BASE_METHOD_MATCHER);
    }
}

