/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodClassMatcherImpl;
import com.google.errorprone.matchers.method.MethodMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Type;

class StaticMethodMatcherImpl
extends MethodMatcher
implements MethodMatchers.StaticMethodMatcher {
    StaticMethodMatcherImpl() {
    }

    @Override
    protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
        if (!method.sym().isStatic()) {
            return Optional.absent();
        }
        return Optional.of(method);
    }

    @Override
    public MethodClassMatcherImpl onClass(TypePredicate predicate) {
        return new MethodClassMatcherImpl(this, predicate);
    }

    @Override
    public MethodClassMatcherImpl onClass(String className) {
        return new MethodClassMatcherImpl(this, TypePredicates.isExactType(className));
    }

    @Override
    public MethodClassMatcherImpl onClassAny(Iterable<String> classNames) {
        return new MethodClassMatcherImpl(this, TypePredicates.isExactTypeAny(classNames));
    }

    @Override
    public MethodClassMatcherImpl onClassAny(String ... classNames) {
        return this.onClassAny(ImmutableList.copyOf(classNames));
    }

    @Override
    public MethodClassMatcherImpl onClass(Supplier<Type> classType) {
        return new MethodClassMatcherImpl(this, TypePredicates.isExactType(classType));
    }

    @Override
    public MethodMatchers.MethodClassMatcher anyClass() {
        return new MethodClassMatcherImpl(this, TypePredicates.anyType());
    }
}

