/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneError;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.JCDiagnostic;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ErrorProneScanner
extends Scanner {
    private final Set<Class<? extends Annotation>> customSuppressionAnnotations = new HashSet<Class<? extends Annotation>>();
    private final Map<String, BugPattern.SeverityLevel> severities;
    private final ImmutableSet<BugChecker> bugCheckers;
    private final List<BugChecker.AnnotationTreeMatcher> annotationMatchers = new ArrayList<BugChecker.AnnotationTreeMatcher>();
    private final List<BugChecker.AnnotatedTypeTreeMatcher> annotatedTypeMatchers = new ArrayList<BugChecker.AnnotatedTypeTreeMatcher>();
    private final List<BugChecker.ArrayAccessTreeMatcher> arrayAccessMatchers = new ArrayList<BugChecker.ArrayAccessTreeMatcher>();
    private final List<BugChecker.ArrayTypeTreeMatcher> arrayTypeMatchers = new ArrayList<BugChecker.ArrayTypeTreeMatcher>();
    private final List<BugChecker.AssertTreeMatcher> assertMatchers = new ArrayList<BugChecker.AssertTreeMatcher>();
    private final List<BugChecker.AssignmentTreeMatcher> assignmentMatchers = new ArrayList<BugChecker.AssignmentTreeMatcher>();
    private final List<BugChecker.BinaryTreeMatcher> binaryMatchers = new ArrayList<BugChecker.BinaryTreeMatcher>();
    private final List<BugChecker.BlockTreeMatcher> blockMatchers = new ArrayList<BugChecker.BlockTreeMatcher>();
    private final List<BugChecker.BreakTreeMatcher> breakMatchers = new ArrayList<BugChecker.BreakTreeMatcher>();
    private final List<BugChecker.CaseTreeMatcher> caseMatchers = new ArrayList<BugChecker.CaseTreeMatcher>();
    private final List<BugChecker.CatchTreeMatcher> catchMatchers = new ArrayList<BugChecker.CatchTreeMatcher>();
    private final List<BugChecker.ClassTreeMatcher> classMatchers = new ArrayList<BugChecker.ClassTreeMatcher>();
    private final List<BugChecker.CompilationUnitTreeMatcher> compilationUnitMatchers = new ArrayList<BugChecker.CompilationUnitTreeMatcher>();
    private final List<BugChecker.CompoundAssignmentTreeMatcher> compoundAssignmentMatchers = new ArrayList<BugChecker.CompoundAssignmentTreeMatcher>();
    private final List<BugChecker.ConditionalExpressionTreeMatcher> conditionalExpressionMatchers = new ArrayList<BugChecker.ConditionalExpressionTreeMatcher>();
    private final List<BugChecker.ContinueTreeMatcher> continueMatchers = new ArrayList<BugChecker.ContinueTreeMatcher>();
    private final List<BugChecker.DoWhileLoopTreeMatcher> doWhileLoopMatchers = new ArrayList<BugChecker.DoWhileLoopTreeMatcher>();
    private final List<BugChecker.EmptyStatementTreeMatcher> emptyStatementMatchers = new ArrayList<BugChecker.EmptyStatementTreeMatcher>();
    private final List<BugChecker.EnhancedForLoopTreeMatcher> enhancedForLoopMatchers = new ArrayList<BugChecker.EnhancedForLoopTreeMatcher>();
    private final List<BugChecker.ExpressionStatementTreeMatcher> expressionStatementMatchers = new ArrayList<BugChecker.ExpressionStatementTreeMatcher>();
    private final List<BugChecker.ForLoopTreeMatcher> forLoopMatchers = new ArrayList<BugChecker.ForLoopTreeMatcher>();
    private final List<BugChecker.IdentifierTreeMatcher> identifierMatchers = new ArrayList<BugChecker.IdentifierTreeMatcher>();
    private final List<BugChecker.IfTreeMatcher> ifMatchers = new ArrayList<BugChecker.IfTreeMatcher>();
    private final List<BugChecker.ImportTreeMatcher> importMatchers = new ArrayList<BugChecker.ImportTreeMatcher>();
    private final List<BugChecker.InstanceOfTreeMatcher> instanceOfMatchers = new ArrayList<BugChecker.InstanceOfTreeMatcher>();
    private final List<BugChecker.IntersectionTypeTreeMatcher> intersectionTypeMatchers = new ArrayList<BugChecker.IntersectionTypeTreeMatcher>();
    private final List<BugChecker.LabeledStatementTreeMatcher> labeledStatementMatchers = new ArrayList<BugChecker.LabeledStatementTreeMatcher>();
    private final List<BugChecker.LambdaExpressionTreeMatcher> lambdaExpressionMatchers = new ArrayList<BugChecker.LambdaExpressionTreeMatcher>();
    private final List<BugChecker.LiteralTreeMatcher> literalMatchers = new ArrayList<BugChecker.LiteralTreeMatcher>();
    private final List<BugChecker.MemberReferenceTreeMatcher> memberReferenceMatchers = new ArrayList<BugChecker.MemberReferenceTreeMatcher>();
    private final List<BugChecker.MemberSelectTreeMatcher> memberSelectMatchers = new ArrayList<BugChecker.MemberSelectTreeMatcher>();
    private final List<BugChecker.MethodTreeMatcher> methodMatchers = new ArrayList<BugChecker.MethodTreeMatcher>();
    private final List<BugChecker.MethodInvocationTreeMatcher> methodInvocationMatchers = new ArrayList<BugChecker.MethodInvocationTreeMatcher>();
    private final List<BugChecker.ModifiersTreeMatcher> modifiersMatchers = new ArrayList<BugChecker.ModifiersTreeMatcher>();
    private final List<BugChecker.NewArrayTreeMatcher> newArrayMatchers = new ArrayList<BugChecker.NewArrayTreeMatcher>();
    private final List<BugChecker.NewClassTreeMatcher> newClassMatchers = new ArrayList<BugChecker.NewClassTreeMatcher>();
    private final List<BugChecker.ParameterizedTypeTreeMatcher> parameterizedTypeMatchers = new ArrayList<BugChecker.ParameterizedTypeTreeMatcher>();
    private final List<BugChecker.ParenthesizedTreeMatcher> parenthesizedMatchers = new ArrayList<BugChecker.ParenthesizedTreeMatcher>();
    private final List<BugChecker.PrimitiveTypeTreeMatcher> primitiveTypeMatchers = new ArrayList<BugChecker.PrimitiveTypeTreeMatcher>();
    private final List<BugChecker.ReturnTreeMatcher> returnMatchers = new ArrayList<BugChecker.ReturnTreeMatcher>();
    private final List<BugChecker.SwitchTreeMatcher> switchMatchers = new ArrayList<BugChecker.SwitchTreeMatcher>();
    private final List<BugChecker.SynchronizedTreeMatcher> synchronizedMatchers = new ArrayList<BugChecker.SynchronizedTreeMatcher>();
    private final List<BugChecker.ThrowTreeMatcher> throwMatchers = new ArrayList<BugChecker.ThrowTreeMatcher>();
    private final List<BugChecker.TryTreeMatcher> tryMatchers = new ArrayList<BugChecker.TryTreeMatcher>();
    private final List<BugChecker.TypeCastTreeMatcher> typeCastMatchers = new ArrayList<BugChecker.TypeCastTreeMatcher>();
    private final List<BugChecker.TypeParameterTreeMatcher> typeParameterMatchers = new ArrayList<BugChecker.TypeParameterTreeMatcher>();
    private final List<BugChecker.UnaryTreeMatcher> unaryMatchers = new ArrayList<BugChecker.UnaryTreeMatcher>();
    private final List<BugChecker.UnionTypeTreeMatcher> unionTypeMatchers = new ArrayList<BugChecker.UnionTypeTreeMatcher>();
    private final List<BugChecker.VariableTreeMatcher> variableMatchers = new ArrayList<BugChecker.VariableTreeMatcher>();
    private final List<BugChecker.WhileLoopTreeMatcher> whileLoopMatchers = new ArrayList<BugChecker.WhileLoopTreeMatcher>();
    private final List<BugChecker.WildcardTreeMatcher> wildcardMatchers = new ArrayList<BugChecker.WildcardTreeMatcher>();

    public ErrorProneScanner(BugChecker ... checkers) {
        this(Arrays.asList(checkers));
    }

    private static Map<String, BugPattern.SeverityLevel> defaultSeverities(Iterable<BugChecker> checkers) {
        ImmutableMap.Builder<String, BugPattern.SeverityLevel> builder = ImmutableMap.builder();
        for (BugChecker check : checkers) {
            builder.put(check.canonicalName(), check.defaultSeverity());
        }
        return builder.build();
    }

    public ErrorProneScanner(Iterable<BugChecker> checkers) {
        this(checkers, ErrorProneScanner.defaultSeverities(checkers));
    }

    public ErrorProneScanner(Iterable<BugChecker> checkers, Map<String, BugPattern.SeverityLevel> severities) {
        this.bugCheckers = ImmutableSet.copyOf(checkers);
        this.severities = severities;
        for (BugChecker checker : this.bugCheckers) {
            this.registerNodeTypes(checker);
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getCustomSuppressionAnnotations() {
        return this.customSuppressionAnnotations;
    }

    private void registerNodeTypes(BugChecker checker) {
        this.customSuppressionAnnotations.addAll(checker.customSuppressionAnnotations());
        if (checker instanceof BugChecker.AnnotationTreeMatcher) {
            this.annotationMatchers.add((BugChecker.AnnotationTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.AnnotatedTypeTreeMatcher) {
            this.annotatedTypeMatchers.add((BugChecker.AnnotatedTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ArrayAccessTreeMatcher) {
            this.arrayAccessMatchers.add((BugChecker.ArrayAccessTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ArrayTypeTreeMatcher) {
            this.arrayTypeMatchers.add((BugChecker.ArrayTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.AssertTreeMatcher) {
            this.assertMatchers.add((BugChecker.AssertTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.AssignmentTreeMatcher) {
            this.assignmentMatchers.add((BugChecker.AssignmentTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.BinaryTreeMatcher) {
            this.binaryMatchers.add((BugChecker.BinaryTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.BlockTreeMatcher) {
            this.blockMatchers.add((BugChecker.BlockTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.BreakTreeMatcher) {
            this.breakMatchers.add((BugChecker.BreakTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CaseTreeMatcher) {
            this.caseMatchers.add((BugChecker.CaseTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CatchTreeMatcher) {
            this.catchMatchers.add((BugChecker.CatchTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ClassTreeMatcher) {
            this.classMatchers.add((BugChecker.ClassTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CompilationUnitTreeMatcher) {
            this.compilationUnitMatchers.add((BugChecker.CompilationUnitTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CompoundAssignmentTreeMatcher) {
            this.compoundAssignmentMatchers.add((BugChecker.CompoundAssignmentTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ConditionalExpressionTreeMatcher) {
            this.conditionalExpressionMatchers.add((BugChecker.ConditionalExpressionTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ContinueTreeMatcher) {
            this.continueMatchers.add((BugChecker.ContinueTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.DoWhileLoopTreeMatcher) {
            this.doWhileLoopMatchers.add((BugChecker.DoWhileLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.EmptyStatementTreeMatcher) {
            this.emptyStatementMatchers.add((BugChecker.EmptyStatementTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.EnhancedForLoopTreeMatcher) {
            this.enhancedForLoopMatchers.add((BugChecker.EnhancedForLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ExpressionStatementTreeMatcher) {
            this.expressionStatementMatchers.add((BugChecker.ExpressionStatementTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ForLoopTreeMatcher) {
            this.forLoopMatchers.add((BugChecker.ForLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.IdentifierTreeMatcher) {
            this.identifierMatchers.add((BugChecker.IdentifierTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.IfTreeMatcher) {
            this.ifMatchers.add((BugChecker.IfTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ImportTreeMatcher) {
            this.importMatchers.add((BugChecker.ImportTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.InstanceOfTreeMatcher) {
            this.instanceOfMatchers.add((BugChecker.InstanceOfTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.IntersectionTypeTreeMatcher) {
            this.intersectionTypeMatchers.add((BugChecker.IntersectionTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.LabeledStatementTreeMatcher) {
            this.labeledStatementMatchers.add((BugChecker.LabeledStatementTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.LambdaExpressionTreeMatcher) {
            this.lambdaExpressionMatchers.add((BugChecker.LambdaExpressionTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.LiteralTreeMatcher) {
            this.literalMatchers.add((BugChecker.LiteralTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MemberReferenceTreeMatcher) {
            this.memberReferenceMatchers.add((BugChecker.MemberReferenceTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MemberSelectTreeMatcher) {
            this.memberSelectMatchers.add((BugChecker.MemberSelectTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MethodTreeMatcher) {
            this.methodMatchers.add((BugChecker.MethodTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MethodInvocationTreeMatcher) {
            this.methodInvocationMatchers.add((BugChecker.MethodInvocationTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ModifiersTreeMatcher) {
            this.modifiersMatchers.add((BugChecker.ModifiersTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.NewArrayTreeMatcher) {
            this.newArrayMatchers.add((BugChecker.NewArrayTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.NewClassTreeMatcher) {
            this.newClassMatchers.add((BugChecker.NewClassTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ParameterizedTypeTreeMatcher) {
            this.parameterizedTypeMatchers.add((BugChecker.ParameterizedTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ParenthesizedTreeMatcher) {
            this.parenthesizedMatchers.add((BugChecker.ParenthesizedTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.PrimitiveTypeTreeMatcher) {
            this.primitiveTypeMatchers.add((BugChecker.PrimitiveTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ReturnTreeMatcher) {
            this.returnMatchers.add((BugChecker.ReturnTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.SwitchTreeMatcher) {
            this.switchMatchers.add((BugChecker.SwitchTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.SynchronizedTreeMatcher) {
            this.synchronizedMatchers.add((BugChecker.SynchronizedTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ThrowTreeMatcher) {
            this.throwMatchers.add((BugChecker.ThrowTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.TryTreeMatcher) {
            this.tryMatchers.add((BugChecker.TryTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.TypeCastTreeMatcher) {
            this.typeCastMatchers.add((BugChecker.TypeCastTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.TypeParameterTreeMatcher) {
            this.typeParameterMatchers.add((BugChecker.TypeParameterTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.UnaryTreeMatcher) {
            this.unaryMatchers.add((BugChecker.UnaryTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.UnionTypeTreeMatcher) {
            this.unionTypeMatchers.add((BugChecker.UnionTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.VariableTreeMatcher) {
            this.variableMatchers.add((BugChecker.VariableTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.WhileLoopTreeMatcher) {
            this.whileLoopMatchers.add((BugChecker.WhileLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.WildcardTreeMatcher) {
            this.wildcardMatchers.add((BugChecker.WildcardTreeMatcher)((Object)checker));
        }
    }

    @Override
    public Void visitAnnotation(AnnotationTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.AnnotationTreeMatcher matcher : this.annotationMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchAnnotation(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitAnnotation(tree, state);
    }

    @Override
    public Void visitAnnotatedType(AnnotatedTypeTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.AnnotatedTypeTreeMatcher matcher : this.annotatedTypeMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchAnnotatedType(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitAnnotatedType(tree, state);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ArrayAccessTreeMatcher matcher : this.arrayAccessMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchArrayAccess(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitArrayAccess(tree, state);
    }

    @Override
    public Void visitArrayType(ArrayTypeTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ArrayTypeTreeMatcher matcher : this.arrayTypeMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchArrayType(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitArrayType(tree, state);
    }

    @Override
    public Void visitAssert(AssertTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.AssertTreeMatcher matcher : this.assertMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchAssert(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitAssert(tree, state);
    }

    @Override
    public Void visitAssignment(AssignmentTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.AssignmentTreeMatcher matcher : this.assignmentMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchAssignment(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitAssignment(tree, state);
    }

    @Override
    public Void visitBinary(BinaryTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.BinaryTreeMatcher matcher : this.binaryMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchBinary(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitBinary(tree, state);
    }

    @Override
    public Void visitBlock(BlockTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.BlockTreeMatcher matcher : this.blockMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchBlock(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitBlock(tree, state);
    }

    @Override
    public Void visitBreak(BreakTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.BreakTreeMatcher matcher : this.breakMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchBreak(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitBreak(tree, state);
    }

    @Override
    public Void visitCase(CaseTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.CaseTreeMatcher matcher : this.caseMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchCase(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitCase(tree, state);
    }

    @Override
    public Void visitCatch(CatchTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.CatchTreeMatcher matcher : this.catchMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchCatch(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitCatch(tree, state);
    }

    @Override
    public Void visitClass(ClassTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ClassTreeMatcher matcher : this.classMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchClass(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitClass(tree, state);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.CompilationUnitTreeMatcher matcher : this.compilationUnitMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchCompilationUnit(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitCompilationUnit(tree, state);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.CompoundAssignmentTreeMatcher matcher : this.compoundAssignmentMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchCompoundAssignment(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitCompoundAssignment(tree, state);
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ConditionalExpressionTreeMatcher matcher : this.conditionalExpressionMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchConditionalExpression(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitConditionalExpression(tree, state);
    }

    @Override
    public Void visitContinue(ContinueTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ContinueTreeMatcher matcher : this.continueMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchContinue(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitContinue(tree, state);
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.DoWhileLoopTreeMatcher matcher : this.doWhileLoopMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchDoWhileLoop(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitDoWhileLoop(tree, state);
    }

    @Override
    public Void visitEmptyStatement(EmptyStatementTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.EmptyStatementTreeMatcher matcher : this.emptyStatementMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchEmptyStatement(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitEmptyStatement(tree, state);
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.EnhancedForLoopTreeMatcher matcher : this.enhancedForLoopMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchEnhancedForLoop(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitEnhancedForLoop(tree, state);
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ExpressionStatementTreeMatcher matcher : this.expressionStatementMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchExpressionStatement(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitExpressionStatement(tree, state);
    }

    @Override
    public Void visitForLoop(ForLoopTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ForLoopTreeMatcher matcher : this.forLoopMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchForLoop(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitForLoop(tree, state);
    }

    @Override
    public Void visitIdentifier(IdentifierTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.IdentifierTreeMatcher matcher : this.identifierMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchIdentifier(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitIdentifier(tree, state);
    }

    @Override
    public Void visitIf(IfTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.IfTreeMatcher matcher : this.ifMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchIf(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitIf(tree, state);
    }

    @Override
    public Void visitImport(ImportTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ImportTreeMatcher matcher : this.importMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchImport(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitImport(tree, state);
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.InstanceOfTreeMatcher matcher : this.instanceOfMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchInstanceOf(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitInstanceOf(tree, state);
    }

    @Override
    public Void visitIntersectionType(IntersectionTypeTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.IntersectionTypeTreeMatcher matcher : this.intersectionTypeMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchIntersectionType(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitIntersectionType(tree, state);
    }

    @Override
    public Void visitLabeledStatement(LabeledStatementTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.LabeledStatementTreeMatcher matcher : this.labeledStatementMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchLabeledStatement(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitLabeledStatement(tree, state);
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.LambdaExpressionTreeMatcher matcher : this.lambdaExpressionMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchLambdaExpression(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitLambdaExpression(tree, state);
    }

    @Override
    public Void visitLiteral(LiteralTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.LiteralTreeMatcher matcher : this.literalMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchLiteral(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitLiteral(tree, state);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.MemberReferenceTreeMatcher matcher : this.memberReferenceMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchMemberReference(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitMemberReference(tree, state);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.MemberSelectTreeMatcher matcher : this.memberSelectMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchMemberSelect(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitMemberSelect(tree, state);
    }

    @Override
    public Void visitMethod(MethodTree tree, VisitorState visitorState) {
        if (ASTHelpers.isGeneratedConstructor(tree)) {
            return null;
        }
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.MethodTreeMatcher matcher : this.methodMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchMethod(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitMethod(tree, state);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.MethodInvocationTreeMatcher matcher : this.methodInvocationMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchMethodInvocation(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitMethodInvocation(tree, state);
    }

    @Override
    public Void visitModifiers(ModifiersTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ModifiersTreeMatcher matcher : this.modifiersMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchModifiers(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitModifiers(tree, state);
    }

    @Override
    public Void visitNewArray(NewArrayTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.NewArrayTreeMatcher matcher : this.newArrayMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchNewArray(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitNewArray(tree, state);
    }

    @Override
    public Void visitNewClass(NewClassTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.NewClassTreeMatcher matcher : this.newClassMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchNewClass(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitNewClass(tree, state);
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ParameterizedTypeTreeMatcher matcher : this.parameterizedTypeMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchParameterizedType(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitParameterizedType(tree, state);
    }

    @Override
    public Void visitParenthesized(ParenthesizedTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ParenthesizedTreeMatcher matcher : this.parenthesizedMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchParenthesized(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitParenthesized(tree, state);
    }

    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.PrimitiveTypeTreeMatcher matcher : this.primitiveTypeMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchPrimitiveType(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitPrimitiveType(tree, state);
    }

    @Override
    public Void visitReturn(ReturnTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ReturnTreeMatcher matcher : this.returnMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchReturn(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitReturn(tree, state);
    }

    @Override
    public Void visitSwitch(SwitchTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.SwitchTreeMatcher matcher : this.switchMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchSwitch(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitSwitch(tree, state);
    }

    @Override
    public Void visitSynchronized(SynchronizedTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.SynchronizedTreeMatcher matcher : this.synchronizedMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchSynchronized(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitSynchronized(tree, state);
    }

    @Override
    public Void visitThrow(ThrowTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.ThrowTreeMatcher matcher : this.throwMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchThrow(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitThrow(tree, state);
    }

    @Override
    public Void visitTry(TryTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.TryTreeMatcher matcher : this.tryMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchTry(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitTry(tree, state);
    }

    @Override
    public Void visitTypeCast(TypeCastTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.TypeCastTreeMatcher matcher : this.typeCastMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchTypeCast(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitTypeCast(tree, state);
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.TypeParameterTreeMatcher matcher : this.typeParameterMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchTypeParameter(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitTypeParameter(tree, state);
    }

    @Override
    public Void visitUnary(UnaryTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.UnaryTreeMatcher matcher : this.unaryMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchUnary(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitUnary(tree, state);
    }

    @Override
    public Void visitUnionType(UnionTypeTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.UnionTypeTreeMatcher matcher : this.unionTypeMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchUnionType(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitUnionType(tree, state);
    }

    @Override
    public Void visitVariable(VariableTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.VariableTreeMatcher matcher : this.variableMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchVariable(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitVariable(tree, state);
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.WhileLoopTreeMatcher matcher : this.whileLoopMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchWhileLoop(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitWhileLoop(tree, state);
    }

    @Override
    public Void visitWildcard(WildcardTree tree, VisitorState visitorState) {
        VisitorState state = visitorState.withPath(this.getCurrentPath());
        for (BugChecker.WildcardTreeMatcher matcher : this.wildcardMatchers) {
            if (this.isSuppressed(matcher, state.errorProneOptions())) continue;
            try {
                this.reportMatch(matcher.matchWildcard(tree, state), state);
            }
            catch (Throwable t) {
                this.handleError(matcher, t);
            }
        }
        return (Void)super.visitWildcard(tree, state);
    }

    @Override
    protected void handleError(Suppressible s2, Throwable t) {
        if (t instanceof ErrorProneError) {
            throw (ErrorProneError)t;
        }
        if (t instanceof Symbol.CompletionFailure) {
            throw (Symbol.CompletionFailure)t;
        }
        TreePath path = this.getCurrentPath();
        throw new ErrorProneError(s2.canonicalName(), t, (JCDiagnostic.DiagnosticPosition)((Object)path.getLeaf()), path.getCompilationUnit().getSourceFile());
    }

    @Override
    public Map<String, BugPattern.SeverityLevel> severityMap() {
        return this.severities;
    }

    public ImmutableSet<BugChecker> getBugCheckers() {
        return this.bugCheckers;
    }
}

