/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Position;

public class ErrorProneTokens {
    private final CommentSavingTokenizer commentSavingTokenizer;
    private final ScannerFactory scannerFactory;

    public ErrorProneTokens(String source, Context context) {
        this.scannerFactory = ScannerFactory.instance(context);
        char[] buffer = source == null ? new char[]{} : source.toCharArray();
        this.commentSavingTokenizer = new CommentSavingTokenizer(this.scannerFactory, buffer, buffer.length);
    }

    public Position.LineMap getLineMap() {
        return this.commentSavingTokenizer.getLineMap();
    }

    public ImmutableList<ErrorProneToken> getTokens() {
        AccessibleScanner scanner = new AccessibleScanner(this.scannerFactory, this.commentSavingTokenizer);
        ImmutableList.Builder tokens = ImmutableList.builder();
        do {
            scanner.nextToken();
            tokens.add(new ErrorProneToken(scanner.token()));
        } while (scanner.token().kind != Tokens.TokenKind.EOF);
        return tokens.build();
    }

    public static ImmutableList<ErrorProneToken> getTokens(String source, Context context) {
        return new ErrorProneTokens(source, context).getTokens();
    }

    static class AccessibleReader
    extends UnicodeReader {
        protected AccessibleReader(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }
    }

    static class AccessibleScanner
    extends Scanner {
        protected AccessibleScanner(ScannerFactory fac, JavaTokenizer tokenizer) {
            super(fac, tokenizer);
        }
    }

    static class CommentWithTextAndPosition
    implements Tokens.Comment {
        private final int pos;
        private final int endPos;
        private final AccessibleReader reader;
        private final Tokens.Comment.CommentStyle style;
        private String text = null;

        public CommentWithTextAndPosition(int pos, int endPos, AccessibleReader reader, Tokens.Comment.CommentStyle style) {
            this.pos = pos;
            this.endPos = endPos;
            this.reader = reader;
            this.style = style;
        }

        @Override
        public int getSourcePos(int index) {
            Preconditions.checkArgument(0 <= index && index < this.endPos - this.pos, "Expected %s in the range [0, %s)", index, this.endPos - this.pos);
            return this.pos + index;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.style;
        }

        @Override
        public String getText() {
            String text = this.text;
            if (text == null) {
                this.text = text = new String(this.reader.getRawCharacters());
            }
            return text;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        public String toString() {
            return String.format("Comment: '%s'", this.getText());
        }
    }

    static class CommentSavingTokenizer
    extends JavaTokenizer {
        CommentSavingTokenizer(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }

        @Override
        protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
            char[] buf = this.reader.getRawCharacters(pos, endPos);
            return new CommentWithTextAndPosition(pos, endPos, new AccessibleReader(this.fac, buf, buf.length), style);
        }
    }
}

