/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.Streams;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.util.List;
import java.util.stream.Stream;

public final class MoreAnnotations {
    public static Stream<Attribute.Compound> getDeclarationAndTypeAttributes(Symbol sym) {
        Symbol typeAnnotationOwner;
        switch (sym.getKind()) {
            case PARAMETER: {
                typeAnnotationOwner = sym.owner;
                break;
            }
            default: {
                typeAnnotationOwner = sym;
            }
        }
        return Streams.concat(sym.getRawAttributes().stream(), typeAnnotationOwner.getRawTypeAttributes().stream().filter(anno -> MoreAnnotations.isAnnotationOnType(sym, anno.position)));
    }

    private static boolean isAnnotationOnType(Symbol sym, TypeAnnotationPosition position) {
        if (!position.location.isEmpty()) {
            return false;
        }
        switch (sym.getKind()) {
            case LOCAL_VARIABLE: {
                return position.type == TargetType.LOCAL_VARIABLE;
            }
            case FIELD: {
                return position.type == TargetType.FIELD;
            }
            case METHOD: {
                return position.type == TargetType.METHOD_RETURN;
            }
            case PARAMETER: {
                switch (position.type) {
                    case METHOD_FORMAL_PARAMETER: {
                        return ((List)((Symbol.MethodSymbol)sym.owner).getParameters()).indexOf(sym) == position.parameter_index;
                    }
                }
                return false;
            }
        }
        throw new AssertionError((Object)sym.getKind());
    }

    private MoreAnnotations() {
    }
}

