/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Regexes {
    private static final ImmutableMap<Character, Character> REGEXCHAR_TO_LITERALCHAR = new ImmutableMap.Builder<Character, Character>().put(Character.valueOf('t'), Character.valueOf('\t')).put(Character.valueOf('n'), Character.valueOf('\n')).put(Character.valueOf('f'), Character.valueOf('\f')).put(Character.valueOf('r'), Character.valueOf('\r')).build();
    private static final CharMatcher UNESCAPED_CONSTRUCT = CharMatcher.anyOf("[].^$?*+{}()|");

    public static Optional<String> convertRegexToLiteral(String s2) {
        try {
            Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return Optional.empty();
        }
        boolean inQuote = false;
        StringBuilder result = new StringBuilder();
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            char current = s2.charAt(i);
            if (!inQuote && UNESCAPED_CONSTRUCT.matches(current)) {
                return Optional.empty();
            }
            if (current == '\\') {
                char escaped;
                if ((escaped = s2.charAt(++i)) == 'Q') {
                    inQuote = true;
                    continue;
                }
                if (escaped == 'E') {
                    inQuote = false;
                    continue;
                }
                Character controlChar = REGEXCHAR_TO_LITERALCHAR.get(Character.valueOf(escaped));
                if (controlChar != null) {
                    result.append(controlChar);
                    continue;
                }
                if (escaped == '\\') {
                    result.append('\\');
                    continue;
                }
                if (UNESCAPED_CONSTRUCT.matches(escaped)) {
                    result.append(escaped);
                    continue;
                }
                return Optional.empty();
            }
            result.append(current);
        }
        return Optional.of(result.toString());
    }
}

