/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;

public final class SideEffectAnalysis
extends TreeScanner<Void, Void> {
    private boolean hasSideEffect = false;
    private static final ImmutableList<String> SIDE_EFFECT_FREE_CLASSES = ImmutableList.of(Object.class.getName(), String.class.getName(), Integer.class.getName(), Double.class.getName(), Long.class.getName(), Float.class.getName(), Short.class.getName(), Byte.class.getName(), Character.class.getName(), Boolean.class.getName(), Math.class.getName());

    private SideEffectAnalysis() {
    }

    public static boolean hasSideEffect(ExpressionTree expression) {
        SideEffectAnalysis analyzer = new SideEffectAnalysis();
        if (expression == null) {
            return false;
        }
        expression.accept(analyzer, null);
        return analyzer.hasSideEffect;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
        this.hasSideEffect = true;
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(tree);
        if (methodSymbol == null || SIDE_EFFECT_FREE_CLASSES.contains(methodSymbol.owner.getQualifiedName().toString())) {
            return null;
        }
        this.hasSideEffect = true;
        return null;
    }

    @Override
    public Void visitNewArray(NewArrayTree tree, Void unused) {
        this.hasSideEffect = true;
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree tree, Void unused) {
        String classFullName = "";
        if (tree.getIdentifier().getKind() == Tree.Kind.MEMBER_SELECT) {
            classFullName = ((JCTree.JCFieldAccess)tree.getIdentifier()).sym.getQualifiedName().toString();
        } else if (tree.getIdentifier().getKind() == Tree.Kind.IDENTIFIER) {
            classFullName = ((JCTree.JCIdent)tree.getIdentifier()).sym.getQualifiedName().toString();
        }
        if (SIDE_EFFECT_FREE_CLASSES.contains(classFullName)) {
            return null;
        }
        this.hasSideEffect = true;
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree tree, Void unused) {
        JCTree.JCUnary unary = (JCTree.JCUnary)tree;
        switch (unary.getKind()) {
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: {
                this.hasSideEffect = true;
                break;
            }
        }
        return (Void)super.visitUnary(tree, unused);
    }
}

