/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Signatures {
    private static final Type.Visitor<String, Void> PRETTY_TYPE_VISITOR = new Types.DefaultTypeVisitor<String, Void>(){

        @Override
        public String visitWildcardType(Type.WildcardType t, Void aVoid) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)t.kind);
            if (t.kind != BoundKind.UNBOUND) {
                sb.append(t.type.accept(this, null));
            }
            return sb.toString();
        }

        @Override
        public String visitClassType(Type.ClassType t, Void s2) {
            StringBuilder sb = new StringBuilder();
            sb.append(t.tsym.getSimpleName());
            if (((List)t.getTypeArguments()).nonEmpty()) {
                sb.append('<');
                sb.append(t.getTypeArguments().stream().map(a -> a.accept(this, null)).collect(Collectors.joining(", ")));
                sb.append(">");
            }
            return sb.toString();
        }

        @Override
        public String visitCapturedType(Type.CapturedType t, Void s2) {
            return t.wildcard.accept(this, null);
        }

        @Override
        public String visitArrayType(Type.ArrayType t, Void aVoid) {
            return t.elemtype.accept(this, null) + "[]";
        }

        @Override
        public String visitType(Type t, Void s2) {
            return t.toString();
        }
    };

    public static String classDescriptor(Type type, Types types) {
        SigGen sig = new SigGen(types);
        sig.assembleClassSig(types.erasure(type));
        return sig.toString();
    }

    public static String descriptor(Type type, Types types) {
        SigGen sig = new SigGen(types);
        sig.assembleSig(types.erasure(type));
        return sig.toString();
    }

    public static String prettyMethodSignature(Symbol.ClassSymbol origin, Symbol.MethodSymbol m3) {
        StringBuilder sb = new StringBuilder();
        if (!m3.owner.equals(origin)) {
            sb.append(m3.owner.getSimpleName()).append('.');
        }
        sb.append(m3.isConstructor() ? origin.getSimpleName() : m3.getSimpleName()).append('(');
        sb.append(m3.getParameters().stream().map(v -> v.type.accept(PRETTY_TYPE_VISITOR, null)).collect(Collectors.joining(", ")));
        sb.append(')');
        return sb.toString();
    }

    public static String prettyType(Type type) {
        return type.accept(PRETTY_TYPE_VISITOR, null);
    }

    private static class SigGen
    extends Types.SignatureGenerator {
        private final ByteBuffer buffer = new ByteBuffer();

        protected SigGen(Types types) {
            super(types);
        }

        @Override
        protected void append(char ch) {
            this.buffer.appendByte(ch);
        }

        @Override
        protected void append(byte[] ba) {
            this.buffer.appendBytes(ba);
        }

        @Override
        protected void append(Name name) {
            this.buffer.appendName(name);
        }

        public String toString() {
            return new String(Arrays.copyOf(this.buffer.elems, this.buffer.length), StandardCharsets.UTF_8);
        }
    }
}

