/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import java.util.HashMap;
import java.util.Map;

public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final CharEscaper JAVA_CHAR_ESCAPER;

    private SourceCodeEscapers() {
    }

    public static CharEscaper javaCharEscaper() {
        return JAVA_CHAR_ESCAPER;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    static {
        HashMap<Character, String> javaMap = new HashMap<Character, String>();
        javaMap.put(Character.valueOf('\b'), "\\b");
        javaMap.put(Character.valueOf('\f'), "\\f");
        javaMap.put(Character.valueOf('\n'), "\\n");
        javaMap.put(Character.valueOf('\r'), "\\r");
        javaMap.put(Character.valueOf('\t'), "\\t");
        javaMap.put(Character.valueOf('\"'), "\\\"");
        javaMap.put(Character.valueOf('\\'), "\\\\");
        javaMap.put(Character.valueOf('\''), "\\'");
        JAVA_CHAR_ESCAPER = new JavaCharEscaper(javaMap);
    }

    private static class JavaCharEscaper
    extends ArrayBasedCharEscaper {
        JavaCharEscaper(Map<Character, String> replacements) {
            super(replacements, ' ', '~');
        }

        @Override
        protected char[] escapeUnsafe(char c) {
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }
    }
}

