/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.internal.tools;

import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;

public abstract class APTTypeVisitor<T, P> {
    public final T apply(TypeMirror type, P param) {
        if (type instanceof ArrayType) {
            return this.onArrayType((ArrayType)type, param);
        }
        if (type instanceof PrimitiveType) {
            return this.onPrimitiveType((PrimitiveType)type, param);
        }
        if (type instanceof ClassType) {
            return this.onClassType((ClassType)type, param);
        }
        if (type instanceof InterfaceType) {
            return this.onInterfaceType((InterfaceType)type, param);
        }
        if (type instanceof TypeVariable) {
            return this.onTypeVariable((TypeVariable)type, param);
        }
        if (type instanceof VoidType) {
            return this.onVoidType((VoidType)type, param);
        }
        if (type instanceof WildcardType) {
            return this.onWildcard((WildcardType)type, param);
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    protected abstract T onPrimitiveType(PrimitiveType var1, P var2);

    protected abstract T onArrayType(ArrayType var1, P var2);

    protected abstract T onClassType(ClassType var1, P var2);

    protected abstract T onInterfaceType(InterfaceType var1, P var2);

    protected abstract T onTypeVariable(TypeVariable var1, P var2);

    protected abstract T onVoidType(VoidType var1, P var2);

    protected abstract T onWildcard(WildcardType var1, P var2);
}

