/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.type;

import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.util.TypeVisitor;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.type.TypeMirrorImpl;
import com.sun.tools.javac.code.Type;

class PrimitiveTypeImpl
extends TypeMirrorImpl
implements PrimitiveType {
    private final PrimitiveType.Kind kind;

    PrimitiveTypeImpl(AptEnv aptEnv, PrimitiveType.Kind kind) {
        super(aptEnv, PrimitiveTypeImpl.getType(aptEnv, kind));
        this.kind = kind;
    }

    @Override
    public PrimitiveType.Kind getKind() {
        return this.kind;
    }

    @Override
    public void accept(TypeVisitor typeVisitor) {
        typeVisitor.visitPrimitiveType(this);
    }

    private static Type getType(AptEnv aptEnv, PrimitiveType.Kind kind) {
        switch (kind) {
            case BOOLEAN: {
                return aptEnv.symtab.booleanType;
            }
            case BYTE: {
                return aptEnv.symtab.byteType;
            }
            case SHORT: {
                return aptEnv.symtab.shortType;
            }
            case INT: {
                return aptEnv.symtab.intType;
            }
            case LONG: {
                return aptEnv.symtab.longType;
            }
            case CHAR: {
                return aptEnv.symtab.charType;
            }
            case FLOAT: {
                return aptEnv.symtab.floatType;
            }
            case DOUBLE: {
                return aptEnv.symtab.doubleType;
            }
        }
        throw new AssertionError();
    }
}

