/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html.markup;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.formats.html.markup.Comment;
import com.sun.tools.doclets.formats.html.markup.DocType;
import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlDocument;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.HtmlWriter;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class HtmlDocWriter
extends HtmlWriter {
    public static final String CONTENT_TYPE = "text/html";

    public HtmlDocWriter(Configuration configuration, String string) throws IOException {
        super(configuration, null, configuration.destDirName + string, configuration.docencoding);
        configuration.message.notice("doclet.Generating_0", new File(configuration.destDirName, string));
    }

    public HtmlDocWriter(Configuration configuration, String string, String string2) throws IOException {
        super(configuration, configuration.destDirName + string, string2, configuration.docencoding);
        configuration.message.notice("doclet.Generating_0", new File(configuration.destDirName, (string.length() > 0 ? string + File.separator : "") + string2));
    }

    public abstract Configuration configuration();

    public void printHyperLink(String string, String string2, String string3, boolean bl) {
        this.print(this.getHyperLinkString(string, string2, string3, bl, "", "", ""));
    }

    public void printHyperLink(String string, String string2, String string3) {
        this.printHyperLink(string, string2, string3, false);
    }

    public void printHyperLink(String string, String string2, String string3, boolean bl, String string4) {
        this.print(this.getHyperLinkString(string, string2, string3, bl, string4, "", ""));
    }

    public String getHyperLinkString(String string, String string2, String string3, boolean bl) {
        return this.getHyperLinkString(string, string2, string3, bl, "", "", "");
    }

    public String getHyperLinkString(String string, String string2, String string3, boolean bl, String string4) {
        return this.getHyperLinkString(string, string2, string3, bl, string4, "", "");
    }

    public Content getHyperLink(String string, String string2, Content content) {
        return this.getHyperLink(string, string2, content, "", "");
    }

    public String getHyperLinkString(String string, String string2, String string3, boolean bl, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuffer.append("<a href=\"");
        stringBuilder.append(string);
        if (string2 != null && string2.length() != 0) {
            stringBuilder.append("#");
            stringBuilder.append(string2);
        }
        stringBuffer.append(HtmlTree.encodeURL(stringBuilder.toString()));
        stringBuffer.append("\"");
        if (string5 != null && string5.length() != 0) {
            stringBuffer.append(" title=\"" + string5 + "\"");
        }
        if (string6 != null && string6.length() != 0) {
            stringBuffer.append(" target=\"" + string6 + "\"");
        }
        stringBuffer.append(">");
        if (string4 != null && string4.length() != 0) {
            stringBuffer.append("<FONT CLASS=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\">");
        }
        if (bl) {
            stringBuffer.append("<span class=\"strong\">");
        }
        stringBuffer.append(string3);
        if (bl) {
            stringBuffer.append("</span>");
        }
        if (string4 != null && string4.length() != 0) {
            stringBuffer.append("</FONT>");
        }
        stringBuffer.append("</a>");
        return stringBuffer.toString();
    }

    public Content getHyperLink(String string, String string2, Content content, String string3, String string4) {
        if (string2 != null && string2.length() != 0) {
            string = string + "#" + string2;
        }
        HtmlTree htmlTree = HtmlTree.A(string, content);
        if (string3 != null && string3.length() != 0) {
            htmlTree.addAttr(HtmlAttr.TITLE, string3);
        }
        if (string4 != null && string4.length() != 0) {
            htmlTree.addAttr(HtmlAttr.TARGET, string4);
        }
        return htmlTree;
    }

    public Content getHyperLink(String string, Content content) {
        return this.getHyperLink(string, "", content);
    }

    public String getHyperLinkString(String string, String string2) {
        return this.getHyperLinkString(string, "", string2, false);
    }

    public void printPkgName(ClassDoc classDoc) {
        this.print(this.getPkgName(classDoc));
    }

    public String getPkgName(ClassDoc classDoc) {
        String string = classDoc.containingPackage().name();
        if (string.length() > 0) {
            string = string + ".";
            return string;
        }
        return "";
    }

    public void printMemberDetailsListStartTag() {
        if (!this.getMemberDetailsListPrinted()) {
            this.dl();
            this.memberDetailsListPrinted = true;
        }
    }

    public void printMemberDetailsListEndTag() {
        if (this.getMemberDetailsListPrinted()) {
            this.dlEnd();
            this.memberDetailsListPrinted = false;
        }
    }

    public boolean getMemberDetailsListPrinted() {
        return this.memberDetailsListPrinted;
    }

    public void printFramesetDocument(String string, boolean bl, Content content) {
        Content content2;
        DocType docType = DocType.Frameset();
        Comment comment = new Comment(this.configuration.getText("doclet.New_Page"));
        HtmlTree htmlTree = new HtmlTree(HtmlTag.HEAD);
        if (!bl) {
            content2 = new Comment("Generated by javadoc on " + this.today());
            ((Content)htmlTree).addContent(content2);
        }
        if (this.configuration.charset.length() > 0) {
            content2 = HtmlTree.META("Content-Type", CONTENT_TYPE, this.configuration.charset);
            ((Content)htmlTree).addContent(content2);
        }
        content2 = HtmlTree.TITLE(new StringContent(string));
        ((Content)htmlTree).addContent(content2);
        ((Content)htmlTree).addContent(this.getFramesetJavaScript());
        HtmlTree htmlTree2 = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), htmlTree, content);
        HtmlDocument htmlDocument = new HtmlDocument(docType, comment, htmlTree2);
        this.print(htmlDocument.toString());
    }

    public String spaces(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        return string;
    }

    public void printBodyHtmlEnd() {
        this.println();
        this.bodyEnd();
        this.htmlEnd();
    }

    public void printFooter() {
        this.printBodyHtmlEnd();
    }

    public void printFrameFooter() {
        this.htmlEnd();
    }

    public void printNbsps() {
        this.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public String today() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        return gregorianCalendar.getTime().toString();
    }
}

