/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.EnumConstantWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnumConstantBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private EnumConstantWriter writer;
    private List<ProgramElementDoc> enumConstants;
    private int currentEnumConstantsIndex;

    private EnumConstantBuilder(Configuration configuration) {
        super(configuration);
    }

    public static EnumConstantBuilder getInstance(Configuration configuration, ClassDoc classDoc, EnumConstantWriter enumConstantWriter) {
        EnumConstantBuilder enumConstantBuilder = new EnumConstantBuilder(configuration);
        enumConstantBuilder.classDoc = classDoc;
        enumConstantBuilder.writer = enumConstantWriter;
        enumConstantBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 1, configuration.nodeprecated);
        enumConstantBuilder.enumConstants = new ArrayList<ProgramElementDoc>(enumConstantBuilder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(enumConstantBuilder.enumConstants, configuration.getMemberComparator());
        }
        return enumConstantBuilder;
    }

    @Override
    public String getName() {
        return "EnumConstantDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.enumConstants.size() > 0;
    }

    public void buildEnumConstant(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.enumConstants.size();
        if (n > 0) {
            Content content2 = this.writer.getEnumConstantsDetailsTreeHeader(this.classDoc, content);
            this.currentEnumConstantsIndex = 0;
            while (this.currentEnumConstantsIndex < n) {
                Content content3 = this.writer.getEnumConstantsTreeHeader((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), content2);
                this.buildChildren(xMLNode, content3);
                content2.addContent(this.writer.getEnumConstants(content3, this.currentEnumConstantsIndex == n - 1));
                ++this.currentEnumConstantsIndex;
            }
            content.addContent(this.writer.getEnumConstantsDetails(content2));
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), content);
    }

    public void buildEnumConstantComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), content);
    }

    public EnumConstantWriter getWriter() {
        return this.writer;
    }
}

