/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.PropertyWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PropertyBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private PropertyWriter writer;
    private List<ProgramElementDoc> fields;
    private int currentFieldIndex;

    private PropertyBuilder(Configuration configuration) {
        super(configuration);
    }

    public static PropertyBuilder getInstance(Configuration configuration, ClassDoc classDoc, PropertyWriter propertyWriter) {
        PropertyBuilder propertyBuilder = new PropertyBuilder(configuration);
        propertyBuilder.classDoc = classDoc;
        propertyBuilder.writer = propertyWriter;
        propertyBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 7, configuration.nodeprecated);
        propertyBuilder.fields = new ArrayList<ProgramElementDoc>(propertyBuilder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(propertyBuilder.fields, configuration.getMemberComparator());
        }
        return propertyBuilder;
    }

    @Override
    public String getName() {
        return "PropertyDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.fields.size() > 0;
    }

    public void buildPropertyDoc(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.fields.size();
        if (n > 0) {
            Content content2 = this.writer.getFieldDetailsTreeHeader(this.classDoc, content);
            this.currentFieldIndex = 0;
            while (this.currentFieldIndex < n) {
                Content content3 = this.writer.getFieldDocTreeHeader((MethodDoc)this.fields.get(this.currentFieldIndex), content2);
                this.buildChildren(xMLNode, content3);
                content2.addContent(this.writer.getFieldDoc(content3, this.currentFieldIndex == n - 1));
                ++this.currentFieldIndex;
            }
            content.addContent(this.writer.getFieldDetails(content2));
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((MethodDoc)this.fields.get(this.currentFieldIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((MethodDoc)this.fields.get(this.currentFieldIndex), content);
    }

    public void buildPropertyComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((MethodDoc)this.fields.get(this.currentFieldIndex), content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((MethodDoc)this.fields.get(this.currentFieldIndex), content);
    }

    public PropertyWriter getWriter() {
        return this.writer;
    }
}

