/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.server.PlatformClasses;
import com.sun.tools.hat.internal.server.QueryHandler;
import java.util.Iterator;

class AllClassesQuery
extends QueryHandler {
    boolean excludePlatform;
    boolean oqlSupported;

    public AllClassesQuery(boolean bl, boolean bl2) {
        this.excludePlatform = bl;
        this.oqlSupported = bl2;
    }

    @Override
    public void run() {
        if (this.excludePlatform) {
            this.startHtml("All Classes (excluding platform)");
        } else {
            this.startHtml("All Classes (including platform)");
        }
        Iterator iterator = this.snapshot.getClasses();
        String string = null;
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (this.excludePlatform && PlatformClasses.isPlatformClass(javaClass)) continue;
            String string2 = javaClass.getName();
            int n = string2.lastIndexOf(".");
            String string3 = string2.startsWith("[") ? "<Arrays>" : (n == -1 ? "<Default Package>" : string2.substring(0, n));
            if (!string3.equals(string)) {
                this.out.print("<h2>Package ");
                this.print(string3);
                this.out.println("</h2>");
            }
            string = string3;
            this.printClass(javaClass);
            if (javaClass.getId() != -1L) {
                this.print(" [" + javaClass.getIdString() + "]");
            }
            this.out.println("<br>");
        }
        this.out.println("<h2>Other Queries</h2>");
        this.out.println("<ul>");
        this.out.println("<li>");
        this.printAnchorStart();
        if (this.excludePlatform) {
            this.out.print("allClassesWithPlatform/\">");
            this.print("All classes including platform");
        } else {
            this.out.print("\">");
            this.print("All classes excluding platform");
        }
        this.out.println("</a>");
        this.out.println("<li>");
        this.printAnchorStart();
        this.out.print("showRoots/\">");
        this.print("Show all members of the rootset");
        this.out.println("</a>");
        this.out.println("<li>");
        this.printAnchorStart();
        this.out.print("showInstanceCounts/includePlatform/\">");
        this.print("Show instance counts for all classes (including platform)");
        this.out.println("</a>");
        this.out.println("<li>");
        this.printAnchorStart();
        this.out.print("showInstanceCounts/\">");
        this.print("Show instance counts for all classes (excluding platform)");
        this.out.println("</a>");
        this.out.println("<li>");
        this.printAnchorStart();
        this.out.print("histo/\">");
        this.print("Show heap histogram");
        this.out.println("</a>");
        this.out.println("<li>");
        this.printAnchorStart();
        this.out.print("finalizerSummary/\">");
        this.print("Show finalizer summary");
        this.out.println("</a>");
        if (this.oqlSupported) {
            this.out.println("<li>");
            this.printAnchorStart();
            this.out.print("oql/\">");
            this.print("Execute Object Query Language (OQL) query");
            this.out.println("</a>");
        }
        this.out.println("</ul>");
        this.endHtml();
    }
}

