/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.server.QueryHandler;
import java.util.Enumeration;

class InstancesQuery
extends QueryHandler {
    private boolean includeSubclasses;
    private boolean newObjects;

    public InstancesQuery(boolean bl) {
        this.includeSubclasses = bl;
    }

    public InstancesQuery(boolean bl, boolean bl2) {
        this.includeSubclasses = bl;
        this.newObjects = bl2;
    }

    @Override
    public void run() {
        JavaClass javaClass = this.snapshot.findClass(this.query);
        String string = this.newObjects ? "New instances of " : "Instances of ";
        if (this.includeSubclasses) {
            this.startHtml(string + this.query + " (including subclasses)");
        } else {
            this.startHtml(string + this.query);
        }
        if (javaClass == null) {
            this.error("Class not found");
        } else {
            this.out.print("<strong>");
            this.printClass(javaClass);
            this.out.print("</strong><br><br>");
            Enumeration enumeration = javaClass.getInstances(this.includeSubclasses);
            long l = 0L;
            long l2 = 0L;
            while (enumeration.hasMoreElements()) {
                JavaHeapObject javaHeapObject = (JavaHeapObject)enumeration.nextElement();
                if (this.newObjects && !javaHeapObject.isNew()) continue;
                this.printThing(javaHeapObject);
                this.out.println("<br>");
                l += (long)javaHeapObject.getSize();
                ++l2;
            }
            this.out.println("<h2>Total of " + l2 + " instances occupying " + l + " bytes.</h2>");
        }
        this.endHtml();
    }
}

