/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.tools.internal.xjc.ErrorReceiver;
import org.xml.sax.SAXParseException;

final class ErrorReceiverImpl
extends ErrorReceiver {
    private final Messager messager;
    private final boolean debug;

    public ErrorReceiverImpl(Messager messager, boolean debug) {
        this.messager = messager;
        this.debug = debug;
    }

    public ErrorReceiverImpl(Messager messager) {
        this(messager, false);
    }

    public ErrorReceiverImpl(AnnotationProcessorEnvironment env) {
        this(env.getMessager());
    }

    @Override
    public void error(SAXParseException exception) {
        this.messager.printError(exception.getMessage());
        this.messager.printError(this.getLocation(exception));
        this.printDetail(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.messager.printError(exception.getMessage());
        this.messager.printError(this.getLocation(exception));
        this.printDetail(exception);
    }

    @Override
    public void warning(SAXParseException exception) {
        this.messager.printWarning(exception.getMessage());
        this.messager.printWarning(this.getLocation(exception));
        this.printDetail(exception);
    }

    @Override
    public void info(SAXParseException exception) {
        this.printDetail(exception);
    }

    private String getLocation(SAXParseException e) {
        return "";
    }

    private void printDetail(SAXParseException e) {
        if (this.debug) {
            e.printStackTrace(System.out);
        }
    }
}

