/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class Analyzer {
    protected static final Context.Key<Analyzer> analyzerKey = new Context.Key();
    final Types types;
    final Log log;
    final Attr attr;
    final DeferredAttr deferredAttr;
    final ArgumentAttr argumentAttr;
    final TreeMaker make;
    final Names names;
    private final boolean allowDiamondWithAnonymousClassCreation;
    final EnumSet<AnalyzerMode> analyzerModes;
    StatementAnalyzer<JCTree, JCTree>[] analyzers = new StatementAnalyzer[]{new DiamondInitializer(), new LambdaAnalyzer(), new RedundantTypeArgAnalyzer()};

    public static Analyzer instance(Context context) {
        Analyzer analyzer = context.get(analyzerKey);
        if (analyzer == null) {
            analyzer = new Analyzer(context);
        }
        return analyzer;
    }

    protected Analyzer(Context context) {
        context.put(analyzerKey, this);
        this.types = Types.instance(context);
        this.log = Log.instance(context);
        this.attr = Attr.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.argumentAttr = ArgumentAttr.instance(context);
        this.make = TreeMaker.instance(context);
        this.names = Names.instance(context);
        Options options = Options.instance(context);
        String string = options.get("find");
        Source source = Source.instance(context);
        this.allowDiamondWithAnonymousClassCreation = source.allowDiamondWithAnonymousClassCreation();
        this.analyzerModes = AnalyzerMode.getAnalyzerModes(string, source);
    }

    void analyzeIfNeeded(JCTree jCTree, Env<AttrContext> env) {
        if (!this.analyzerModes.isEmpty() && !((AttrContext)env.info).isSpeculative && TreeInfo.isStatement((JCTree)jCTree)) {
            JCTree.JCStatement jCStatement = (JCTree.JCStatement)jCTree;
            this.analyze(jCStatement, env);
        }
    }

    void analyze(JCTree.JCStatement jCStatement, Env<AttrContext> env) {
        AnalysisContext analysisContext = new AnalysisContext();
        StatementScanner statementScanner = new StatementScanner(analysisContext);
        statementScanner.scan(jCStatement);
        if (!analysisContext.treesToAnalyzer.isEmpty()) {
            JCTree.JCBlock jCBlock = this.make.Block(4096L, List.of(jCStatement));
            TreeMapper treeMapper = new TreeMapper(analysisContext);
            this.deferredAttr.attribSpeculative(jCBlock, env, this.attr.statInfo, treeMapper, jCTree -> new AnalyzeDeferredDiagHandler(analysisContext), this.argumentAttr.withLocalCacheContext());
            analysisContext.treeMap.entrySet().forEach(entry -> analysisContext.treesToAnalyzer.get(entry.getKey()).process((JCTree)entry.getKey(), (JCTree)entry.getValue(), analysisContext.errors.nonEmpty()));
        }
    }

    class TreeMapper
    extends TreeCopier<Void> {
        AnalysisContext context;

        TreeMapper(AnalysisContext analysisContext) {
            super(Analyzer.this.make);
            this.context = analysisContext;
        }

        @Override
        public <Z extends JCTree> Z copy(Z z, Void void_) {
            Object object = super.copy(z, void_);
            StatementAnalyzer<JCTree, JCTree> statementAnalyzer = this.context.treesToAnalyzer.get(z);
            if (statementAnalyzer != null) {
                object = statementAnalyzer.map(z, (JCTree)object);
                this.context.treeMap.put(z, (JCTree)object);
            }
            return object;
        }

        @Override
        public JCTree visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void void_) {
            JCTree.JCLambda jCLambda = (JCTree.JCLambda)lambdaExpressionTree;
            JCTree.JCLambda jCLambda2 = (JCTree.JCLambda)super.visitLambdaExpression(lambdaExpressionTree, void_);
            if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                jCLambda2.paramKind = JCTree.JCLambda.ParameterKind.IMPLICIT;
                jCLambda2.params.forEach(jCVariableDecl -> {
                    jCVariableDecl.vartype = null;
                });
            }
            return jCLambda2;
        }
    }

    class StatementScanner
    extends TreeScanner {
        AnalysisContext context;

        StatementScanner(AnalysisContext analysisContext) {
            this.context = analysisContext;
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null) {
                for (StatementAnalyzer<JCTree, JCTree> statementAnalyzer : Analyzer.this.analyzers) {
                    if (!statementAnalyzer.isEnabled() || !jCTree.hasTag(statementAnalyzer.tag) || !statementAnalyzer.match(jCTree)) continue;
                    this.context.treesToAnalyzer.put(jCTree, statementAnalyzer);
                    break;
                }
            }
            super.scan(jCTree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            this.scan(jCSwitch.getExpression());
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            this.scan((List<? extends JCTree>)jCForLoop.getInitializer());
            this.scan(jCForLoop.getCondition());
            this.scan((List<? extends JCTree>)jCForLoop.getUpdate());
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.scan(jCEnhancedForLoop.getExpression());
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            this.scan(jCWhileLoop.getCondition());
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            this.scan(jCDoWhileLoop.getCondition());
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.getCondition());
        }
    }

    class AnalysisContext {
        Map<JCTree, StatementAnalyzer<JCTree, JCTree>> treesToAnalyzer = new HashMap<JCTree, StatementAnalyzer<JCTree, JCTree>>();
        Map<JCTree, JCTree> treeMap = new HashMap<JCTree, JCTree>();
        ListBuffer<JCDiagnostic> errors = new ListBuffer();

        AnalysisContext() {
        }
    }

    class AnalyzeDeferredDiagHandler
    extends Log.DeferredDiagnosticHandler {
        AnalysisContext context;

        public AnalyzeDeferredDiagHandler(AnalysisContext analysisContext) {
            super(Analyzer.this.log, (JCDiagnostic jCDiagnostic) -> {
                if (jCDiagnostic.getType() == JCDiagnostic.DiagnosticType.ERROR) {
                    analysisContext.errors.add((JCDiagnostic)jCDiagnostic);
                }
                return true;
            });
            this.context = analysisContext;
        }
    }

    class RedundantTypeArgAnalyzer
    extends StatementAnalyzer<JCTree.JCMethodInvocation, JCTree.JCMethodInvocation> {
        RedundantTypeArgAnalyzer() {
            super(AnalyzerMode.METHOD, JCTree.Tag.APPLY);
        }

        @Override
        boolean match(JCTree.JCMethodInvocation jCMethodInvocation) {
            return jCMethodInvocation.typeargs != null && jCMethodInvocation.typeargs.nonEmpty();
        }

        @Override
        JCTree.JCMethodInvocation map(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2) {
            jCMethodInvocation2.typeargs = List.nil();
            return jCMethodInvocation2;
        }

        @Override
        void process(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2, boolean bl) {
            if (!bl) {
                Analyzer.this.log.warning(jCMethodInvocation, "method.redundant.typeargs", new Object[0]);
            }
        }
    }

    class LambdaAnalyzer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCLambda> {
        LambdaAnalyzer() {
            super(AnalyzerMode.LAMBDA, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass jCNewClass) {
            Type type = jCNewClass.clazz.type;
            return jCNewClass.def != null && type.hasTag(TypeTag.CLASS) && Analyzer.this.types.isFunctionalInterface(type.tsym) && this.decls(jCNewClass.def).length() == 1;
        }

        private List<JCTree> decls(JCTree.JCClassDecl jCClassDecl) {
            ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
            for (JCTree jCTree : jCClassDecl.defs) {
                if (jCTree.hasTag(JCTree.Tag.METHODDEF)) {
                    JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                    if ((jCMethodDecl.getModifiers().flags & 0x1000000000L) != 0L) continue;
                    listBuffer.add(jCMethodDecl);
                    continue;
                }
                listBuffer.add(jCTree);
            }
            return listBuffer.toList();
        }

        @Override
        JCTree.JCLambda map(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2) {
            JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)this.decls((JCTree.JCClassDecl)jCNewClass2.def).head;
            List<JCTree.JCVariableDecl> list = jCMethodDecl.params;
            JCTree.JCBlock jCBlock = jCMethodDecl.body;
            return Analyzer.this.make.Lambda(list, jCBlock);
        }

        @Override
        void process(JCTree.JCNewClass jCNewClass, JCTree.JCLambda jCLambda, boolean bl) {
            if (!bl) {
                Analyzer.this.log.warning(jCNewClass.def, "potential.lambda.found", new Object[0]);
            }
        }
    }

    class DiamondInitializer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCNewClass> {
        DiamondInitializer() {
            super(AnalyzerMode.DIAMOND, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass jCNewClass) {
            return jCNewClass.clazz.hasTag(JCTree.Tag.TYPEAPPLY) && !TreeInfo.isDiamond(jCNewClass) && (jCNewClass.def == null || Analyzer.this.allowDiamondWithAnonymousClassCreation);
        }

        @Override
        JCTree.JCNewClass map(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2) {
            if (jCNewClass2.clazz.hasTag(JCTree.Tag.TYPEAPPLY)) {
                ((JCTree.JCTypeApply)jCNewClass2.clazz).arguments = List.nil();
            }
            return jCNewClass2;
        }

        @Override
        void process(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2, boolean bl) {
            if (!bl) {
                List<Type> list;
                List<Type> list2;
                if (jCNewClass.def != null) {
                    list2 = jCNewClass2.def.implementing.nonEmpty() ? jCNewClass2.def.implementing.get((int)0).type.getTypeArguments() : jCNewClass2.def.extending.type.getTypeArguments();
                    list = jCNewClass.def.implementing.nonEmpty() ? jCNewClass.def.implementing.get((int)0).type.getTypeArguments() : jCNewClass.def.extending.type.getTypeArguments();
                } else {
                    list2 = jCNewClass2.type.getTypeArguments();
                    list = jCNewClass.type.getTypeArguments();
                }
                for (Type type : list2) {
                    if (!Analyzer.this.types.isSameType(type, (Type)list.head)) {
                        return;
                    }
                    list = list.tail;
                }
                Analyzer.this.log.warning(jCNewClass.clazz, "diamond.redundant.args", new Object[0]);
            }
        }
    }

    abstract class StatementAnalyzer<S extends JCTree, T extends JCTree> {
        AnalyzerMode mode;
        JCTree.Tag tag;

        StatementAnalyzer(AnalyzerMode analyzerMode, JCTree.Tag tag) {
            this.mode = analyzerMode;
            this.tag = tag;
        }

        boolean isEnabled() {
            return Analyzer.this.analyzerModes.contains((Object)this.mode);
        }

        abstract boolean match(S var1);

        abstract T map(S var1, S var2);

        abstract void process(S var1, T var2, boolean var3);
    }

    static enum AnalyzerMode {
        DIAMOND("diamond", Source::allowDiamond),
        LAMBDA("lambda", Source::allowLambda),
        METHOD("method", Source::allowGraphInference);

        final String opt;
        final Predicate<Source> sourceFilter;

        private AnalyzerMode(String string2, Predicate<Source> predicate) {
            this.opt = string2;
            this.sourceFilter = predicate;
        }

        static EnumSet<AnalyzerMode> getAnalyzerModes(String string, Source source) {
            if (string == null) {
                return EnumSet.noneOf(AnalyzerMode.class);
            }
            List<String> list = List.from(string.split(","));
            EnumSet<AnalyzerMode> enumSet = EnumSet.noneOf(AnalyzerMode.class);
            if (list.contains("all")) {
                enumSet = EnumSet.allOf(AnalyzerMode.class);
            }
            for (AnalyzerMode analyzerMode : AnalyzerMode.values()) {
                if (list.contains(analyzerMode.opt)) {
                    enumSet.add(analyzerMode);
                    continue;
                }
                if (!list.contains("-" + analyzerMode.opt) && analyzerMode.sourceFilter.test(source)) continue;
                enumSet.remove((Object)analyzerMode);
            }
            return enumSet;
        }
    }
}

