/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.ModuleTree;
import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.ModuleFinder;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.JNIWriter;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class Modules
extends JCTree.Visitor {
    private static final String ALL_SYSTEM = "ALL-SYSTEM";
    private static final String ALL_MODULE_PATH = "ALL-MODULE-PATH";
    private final Log log;
    private final Names names;
    private final Symtab syms;
    private final Attr attr;
    private final Check chk;
    private final DeferredLintHandler deferredLintHandler;
    private final TypeEnvs typeEnvs;
    private final Types types;
    private final JavaFileManager fileManager;
    private final ModuleFinder moduleFinder;
    private final Source source;
    private final boolean allowModules;
    private final boolean allowAccessIntoSystem;
    public final boolean multiModuleMode;
    private final Name java_se;
    private final Name java_;
    Symbol.ModuleSymbol defaultModule;
    private final String addExportsOpt;
    private Map<Symbol.ModuleSymbol, Set<Directive.ExportsDirective>> addExports;
    private final String addReadsOpt;
    private Map<Symbol.ModuleSymbol, Set<Directive.RequiresDirective>> addReads;
    private final String addModsOpt;
    private final Set<String> extraAddMods = new HashSet<String>();
    private final String limitModsOpt;
    private final Set<String> extraLimitMods = new HashSet<String>();
    private final String moduleVersionOpt;
    private final boolean lintOptions;
    private Set<Symbol.ModuleSymbol> rootModules = null;
    private final Set<Symbol.ModuleSymbol> warnedMissing = new HashSet<Symbol.ModuleSymbol>();
    public PackageNameFinder findPackageInFile;
    private static final String XMODULES_PREFIX = "-Xmodule:";
    int depth = -1;
    boolean inInitModules;
    private final Symbol.Completer mainCompleter = new Symbol.Completer(){

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            Symbol.ModuleSymbol moduleSymbol = Modules.this.moduleFinder.findModule((Symbol.ModuleSymbol)symbol);
            if (moduleSymbol.kind == Kinds.Kind.ERR) {
                moduleSymbol.directives = List.nil();
                moduleSymbol.exports = List.nil();
                moduleSymbol.provides = List.nil();
                moduleSymbol.requires = List.nil();
                moduleSymbol.uses = List.nil();
            } else if ((moduleSymbol.flags_field & 0x10000000000000L) != 0L) {
                Modules.this.setupAutomaticModule(moduleSymbol);
            } else {
                moduleSymbol.module_info.complete();
            }
            if (moduleSymbol.module_info.classfile == null || moduleSymbol.module_info.classfile.getKind() == JavaFileObject.Kind.CLASS) {
                Modules.this.completeModule(moduleSymbol);
            }
        }

        public String toString() {
            return "mainCompleter";
        }
    };
    private Set<Symbol.ModuleSymbol> allModules;
    private static final Predicate<Symbol.ModuleSymbol> IS_AUTOMATIC = moduleSymbol -> (moduleSymbol.flags_field & 0x10000000000000L) != 0L;
    private final Map<Symbol.ModuleSymbol, Set<Symbol.ModuleSymbol>> requiresTransitiveCache = new HashMap<Symbol.ModuleSymbol, Set<Symbol.ModuleSymbol>>();

    public static Modules instance(Context context) {
        Modules modules = context.get(Modules.class);
        if (modules == null) {
            modules = new Modules(context);
        }
        return modules;
    }

    protected Modules(Context context) {
        context.put(Modules.class, this);
        this.log = Log.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.moduleFinder = ModuleFinder.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.source = Source.instance(context);
        this.allowModules = this.source.allowModules();
        Options options = Options.instance(context);
        this.allowAccessIntoSystem = options.isUnset(Option.RELEASE);
        this.lintOptions = options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.OPTIONS.option);
        this.multiModuleMode = this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH);
        ClassWriter classWriter = ClassWriter.instance(context);
        classWriter.multiModuleMode = this.multiModuleMode;
        JNIWriter jNIWriter = JNIWriter.instance(context);
        jNIWriter.multiModuleMode = this.multiModuleMode;
        this.java_se = this.names.fromString("java.se");
        this.java_ = this.names.fromString("java.");
        this.addExportsOpt = options.get(Option.ADD_EXPORTS);
        this.addReadsOpt = options.get(Option.ADD_READS);
        this.addModsOpt = options.get(Option.ADD_MODULES);
        this.limitModsOpt = options.get(Option.LIMIT_MODULES);
        this.moduleVersionOpt = options.get(Option.MODULE_VERSION);
    }

    private void dprintln(String string) {
        for (int i = 0; i < this.depth; ++i) {
            System.err.print("  ");
        }
        System.err.println(string);
    }

    public void addExtraAddModules(String ... stringArray) {
        this.extraAddMods.addAll(Arrays.asList(stringArray));
    }

    public void addExtraLimitModules(String ... stringArray) {
        this.extraLimitMods.addAll(Arrays.asList(stringArray));
    }

    public void initModules(List<JCTree.JCCompilationUnit> list) {
        Assert.check(!this.inInitModules);
        try {
            this.inInitModules = true;
            Assert.checkNull(this.rootModules);
            this.enter(list, set -> {
                Assert.checkNull(this.rootModules);
                Assert.checkNull(this.allModules);
                this.rootModules = set;
                this.setupAllModules();
                Assert.checkNonNull(this.allModules);
                this.inInitModules = false;
            }, null);
        }
        finally {
            this.inInitModules = false;
        }
    }

    public boolean enter(List<JCTree.JCCompilationUnit> list, Symbol.ClassSymbol classSymbol) {
        Assert.check(this.rootModules != null || this.inInitModules || !this.allowModules);
        return this.enter(list, set -> {}, classSymbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enter(List<JCTree.JCCompilationUnit> list, Consumer<Set<Symbol.ModuleSymbol>> consumer, Symbol.ClassSymbol classSymbol) {
        if (!this.allowModules) {
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                jCCompilationUnit.modle = this.syms.noModule;
            }
            this.defaultModule = this.syms.noModule;
            return true;
        }
        int n = this.log.nerrors;
        ++this.depth;
        try {
            Set<Symbol.ModuleSymbol> set = this.enterModules(list, classSymbol);
            this.setCompilationUnitModules(list, set, classSymbol);
            consumer.accept(set);
            for (Symbol.ModuleSymbol moduleSymbol : set) {
                moduleSymbol.complete();
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE, -1, "cant.access", completionFailure.sym, completionFailure.getDetailValue());
            if (completionFailure instanceof ClassFinder.BadClassFile) {
                throw new Abort();
            }
        }
        finally {
            --this.depth;
        }
        return this.log.nerrors == n;
    }

    public Symbol.Completer getCompleter() {
        return this.mainCompleter;
    }

    public Symbol.ModuleSymbol getDefaultModule() {
        return this.defaultModule;
    }

    public boolean modulesInitialized() {
        return this.allModules != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Symbol.ModuleSymbol> enterModules(List<JCTree.JCCompilationUnit> list, Symbol.ClassSymbol classSymbol) {
        LinkedHashSet<Symbol.ModuleSymbol> linkedHashSet = new LinkedHashSet<Symbol.ModuleSymbol>();
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            JavaFileObject javaFileObject = this.log.useSource(jCCompilationUnit.sourcefile);
            try {
                this.enterModule(jCCompilationUnit, classSymbol, linkedHashSet);
            }
            finally {
                this.log.useSource(javaFileObject);
            }
        }
        return linkedHashSet;
    }

    private void enterModule(JCTree.JCCompilationUnit jCCompilationUnit, Symbol.ClassSymbol classSymbol, Set<Symbol.ModuleSymbol> set) {
        boolean bl;
        boolean bl2 = jCCompilationUnit.sourcefile.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE);
        boolean bl3 = bl = jCCompilationUnit.getModuleDecl() != null;
        if (bl) {
            Object object;
            Symbol.ModuleSymbol moduleSymbol;
            JCTree.JCModuleDecl jCModuleDecl = jCCompilationUnit.getModuleDecl();
            if (!bl2) {
                this.log.error(jCModuleDecl.pos(), CompilerProperties.Errors.ModuleDeclSbInModuleInfoJava);
            }
            Name name = TreeInfo.fullName(jCModuleDecl.qualId);
            if (classSymbol != null) {
                moduleSymbol = (Symbol.ModuleSymbol)classSymbol.owner;
                Assert.checkNonNull(moduleSymbol.name);
                object = TreeInfo.fullName(jCModuleDecl.qualId);
                if (moduleSymbol.name != object) {
                    this.log.error(jCModuleDecl.pos(), CompilerProperties.Errors.ModuleNameMismatch(name, moduleSymbol.name));
                }
            } else {
                moduleSymbol = this.syms.enterModule(name);
                if (moduleSymbol.module_info.sourcefile != null && moduleSymbol.module_info.sourcefile != jCCompilationUnit.sourcefile) {
                    this.log.error(jCModuleDecl.pos(), CompilerProperties.Errors.DuplicateModule(moduleSymbol));
                    return;
                }
            }
            moduleSymbol.completer = this.getSourceCompleter(jCCompilationUnit);
            moduleSymbol.module_info.sourcefile = jCCompilationUnit.sourcefile;
            jCModuleDecl.sym = moduleSymbol;
            if (this.multiModuleMode || set.isEmpty()) {
                set.add(moduleSymbol);
            } else {
                this.log.error(jCCompilationUnit.pos(), CompilerProperties.Errors.TooManyModules);
            }
            object = new Env<Object>(jCModuleDecl, null);
            ((Env)object).toplevel = jCCompilationUnit;
            this.typeEnvs.put(moduleSymbol, (Env<AttrContext>)object);
        } else if (bl2 && this.multiModuleMode) {
            JCTree.JCCompilationUnit jCCompilationUnit2 = jCCompilationUnit.defs.isEmpty() ? jCCompilationUnit : (JCTree)jCCompilationUnit.defs.head;
            this.log.error(jCCompilationUnit2.pos(), CompilerProperties.Errors.ExpectedModule);
        }
    }

    private void setCompilationUnitModules(List<JCTree.JCCompilationUnit> list, Set<Symbol.ModuleSymbol> set, Symbol.ClassSymbol classSymbol) {
        if (this.multiModuleMode) {
            this.checkNoAllModulePath();
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                if (jCCompilationUnit.defs.isEmpty()) {
                    jCCompilationUnit.modle = this.syms.unnamedModule;
                    continue;
                }
                JavaFileObject javaFileObject = this.log.useSource(jCCompilationUnit.sourcefile);
                try {
                    Object object;
                    Symbol.ModuleSymbol moduleSymbol;
                    Object object2;
                    JavaFileManager.Location location;
                    JavaFileManager.Location location2 = this.getModuleLocation(jCCompilationUnit);
                    JavaFileManager.Location location3 = location = this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH) ? this.fileManager.getLocationForModule(StandardLocation.PATCH_MODULE_PATH, jCCompilationUnit.sourcefile) : null;
                    if (location != null) {
                        object2 = this.names.fromString(this.fileManager.inferModuleName(location));
                        jCCompilationUnit.modle = moduleSymbol = this.moduleFinder.findModule((Name)object2);
                        set.add(moduleSymbol);
                        if (location2 == null || object2 == (object = this.names.fromString(this.fileManager.inferModuleName(location2)))) continue;
                        this.log.error(jCCompilationUnit.pos(), CompilerProperties.Errors.FilePatchedAndMsp((Name)object2, (Name)object));
                        continue;
                    }
                    if (location2 != null) {
                        if (!(jCCompilationUnit.getModuleDecl() == null || (object2 = this.fileManager.getJavaFileForInput(location2, "module-info", JavaFileObject.Kind.SOURCE)) != null && this.fileManager.isSameFile((FileObject)object2, jCCompilationUnit.sourcefile))) {
                            this.log.error(jCCompilationUnit.pos(), CompilerProperties.Errors.ModuleNotFoundOnModuleSourcePath);
                        }
                        object2 = this.names.fromString(this.fileManager.inferModuleName(location2));
                        object = jCCompilationUnit.getModuleDecl();
                        if (object != null) {
                            moduleSymbol = ((JCTree.JCModuleDecl)object).sym;
                            if (moduleSymbol.name != object2) {
                                this.log.error(((JCTree.JCModuleDecl)object).qualId, CompilerProperties.Errors.ModuleNameMismatch(moduleSymbol.name, (Name)object2));
                            }
                        } else {
                            if (jCCompilationUnit.getPackage() == null) {
                                this.log.error(jCCompilationUnit.pos(), CompilerProperties.Errors.UnnamedPkgNotAllowedNamedModules);
                            }
                            moduleSymbol = this.syms.enterModule((Name)object2);
                        }
                        if (moduleSymbol.sourceLocation == null) {
                            moduleSymbol.sourceLocation = location2;
                            if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
                                moduleSymbol.patchLocation = this.fileManager.getLocationForModule(StandardLocation.PATCH_MODULE_PATH, moduleSymbol.name.toString());
                            }
                            if (this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                JavaFileManager.Location location4 = this.fileManager.getLocationForModule(StandardLocation.CLASS_OUTPUT, moduleSymbol.name.toString());
                                if (moduleSymbol.patchLocation == null) {
                                    moduleSymbol.classLocation = location4;
                                } else {
                                    moduleSymbol.patchOutputLocation = location4;
                                }
                            }
                        }
                        jCCompilationUnit.modle = moduleSymbol;
                        set.add(moduleSymbol);
                        continue;
                    }
                    if (classSymbol != null && classSymbol.packge().modle == this.syms.unnamedModule) {
                        jCCompilationUnit.modle = this.syms.unnamedModule;
                        continue;
                    }
                    if (jCCompilationUnit.getModuleDecl() != null) {
                        this.log.error(jCCompilationUnit.pos(), CompilerProperties.Errors.ModuleNotFoundOnModuleSourcePath);
                    } else {
                        this.log.error(jCCompilationUnit.pos(), CompilerProperties.Errors.NotInModuleOnModuleSourcePath);
                    }
                    jCCompilationUnit.modle = this.syms.errModule;
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
                finally {
                    this.log.useSource(javaFileObject);
                }
            }
            if (this.syms.unnamedModule.sourceLocation == null) {
                this.syms.unnamedModule.completer = this.getUnnamedModuleCompleter();
                this.syms.unnamedModule.sourceLocation = StandardLocation.SOURCE_PATH;
                this.syms.unnamedModule.classLocation = StandardLocation.CLASS_PATH;
            }
            this.defaultModule = this.syms.unnamedModule;
        } else {
            Object object;
            Symbol.ModuleSymbol moduleSymbol = null;
            if (this.defaultModule == null) {
                object = this.singleModuleOverride(list);
                switch (set.size()) {
                    case 0: {
                        this.defaultModule = this.moduleFinder.findSingleModule();
                        if (this.defaultModule == this.syms.unnamedModule) {
                            if (object != null) {
                                this.checkNoAllModulePath();
                                this.defaultModule = this.moduleFinder.findModule(this.names.fromString((String)object));
                                this.defaultModule.patchOutputLocation = StandardLocation.CLASS_OUTPUT;
                            } else {
                                this.defaultModule.completer = this.getUnnamedModuleCompleter();
                                this.defaultModule.sourceLocation = StandardLocation.SOURCE_PATH;
                                this.defaultModule.classLocation = StandardLocation.CLASS_PATH;
                            }
                        } else {
                            this.checkNoAllModulePath();
                            this.defaultModule.complete();
                            this.defaultModule.completer = symbol -> this.completeModule((Symbol.ModuleSymbol)symbol);
                            this.defaultModule.sourceLocation = StandardLocation.SOURCE_PATH;
                        }
                        set.add(this.defaultModule);
                        break;
                    }
                    case 1: {
                        this.checkNoAllModulePath();
                        this.defaultModule = set.iterator().next();
                        this.defaultModule.sourceLocation = StandardLocation.SOURCE_PATH;
                        if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
                            try {
                                this.defaultModule.patchLocation = this.fileManager.getLocationForModule(StandardLocation.PATCH_MODULE_PATH, this.defaultModule.name.toString());
                            }
                            catch (IOException iOException) {
                                throw new Error(iOException);
                            }
                        }
                        if (this.defaultModule.patchLocation == null) {
                            this.defaultModule.classLocation = StandardLocation.CLASS_OUTPUT;
                            break;
                        }
                        this.defaultModule.patchOutputLocation = StandardLocation.CLASS_OUTPUT;
                        break;
                    }
                    default: {
                        Assert.error("too many modules");
                        break;
                    }
                }
            } else if (set.size() == 1) {
                moduleSymbol = set.iterator().next();
                moduleSymbol.complete();
                moduleSymbol.completer = symbol -> this.completeModule((Symbol.ModuleSymbol)symbol);
            } else {
                Assert.check(set.isEmpty());
                object = this.singleModuleOverride(list);
                moduleSymbol = object != null ? this.moduleFinder.findModule(this.names.fromString((String)object)) : this.defaultModule;
                set.add(moduleSymbol);
            }
            if (this.defaultModule != this.syms.unnamedModule) {
                this.syms.unnamedModule.completer = this.getUnnamedModuleCompleter();
                this.syms.unnamedModule.classLocation = StandardLocation.CLASS_PATH;
            }
            if (moduleSymbol == null) {
                moduleSymbol = this.defaultModule;
            }
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                if (this.defaultModule != this.syms.unnamedModule && this.defaultModule.sourceLocation == StandardLocation.SOURCE_PATH && this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                    this.checkSourceLocation(jCCompilationUnit, moduleSymbol);
                }
                jCCompilationUnit.modle = moduleSymbol;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSourceLocation(JCTree.JCCompilationUnit jCCompilationUnit, Symbol.ModuleSymbol moduleSymbol) {
        JavaFileObject javaFileObject;
        try {
            javaFileObject = jCCompilationUnit.sourcefile;
            if (this.fileManager.contains(moduleSymbol.sourceLocation, javaFileObject)) {
                return;
            }
            if (moduleSymbol.patchLocation != null && this.fileManager.contains(moduleSymbol.patchLocation, javaFileObject)) {
                return;
            }
            if (this.fileManager.hasLocation(StandardLocation.SOURCE_OUTPUT) ? this.fileManager.contains(StandardLocation.SOURCE_OUTPUT, javaFileObject) : this.fileManager.contains(StandardLocation.CLASS_OUTPUT, javaFileObject)) {
                return;
            }
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        javaFileObject = this.log.useSource(jCCompilationUnit.sourcefile);
        try {
            this.log.error(jCCompilationUnit.pos(), "file.sb.on.source.or.patch.path.for.module", new Object[0]);
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    private String singleModuleOverride(List<JCTree.JCCompilationUnit> list) {
        if (!this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
            return null;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            JavaFileObject javaFileObject = jCCompilationUnit.sourcefile;
            try {
                JavaFileManager.Location location = this.fileManager.getLocationForModule(StandardLocation.PATCH_MODULE_PATH, javaFileObject);
                if (location == null) continue;
                linkedHashSet.add(this.fileManager.inferModuleName(location));
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }
        switch (linkedHashSet.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (String)linkedHashSet.iterator().next();
            }
        }
        this.log.error(CompilerProperties.Errors.TooManyPatchedModules(linkedHashSet));
        return null;
    }

    private JavaFileManager.Location getModuleLocation(JCTree.JCCompilationUnit jCCompilationUnit) throws IOException {
        JavaFileObject javaFileObject = jCCompilationUnit.sourcefile;
        JavaFileManager.Location location = this.fileManager.getLocationForModule(StandardLocation.MODULE_SOURCE_PATH, javaFileObject);
        if (location == null) {
            StandardLocation standardLocation = this.fileManager.hasLocation(StandardLocation.SOURCE_OUTPUT) ? StandardLocation.SOURCE_OUTPUT : StandardLocation.CLASS_OUTPUT;
            location = this.fileManager.getLocationForModule(standardLocation, javaFileObject);
        }
        return location;
    }

    private void checkNoAllModulePath() {
        if (this.addModsOpt != null && Arrays.asList(this.addModsOpt.split(",")).contains(ALL_MODULE_PATH)) {
            this.log.error(CompilerProperties.Errors.AddmodsAllModulePathInvalid);
        }
    }

    private void setupAutomaticModule(Symbol.ModuleSymbol moduleSymbol) throws Symbol.CompletionFailure {
        try {
            ListBuffer<Directive.ExportsDirective> listBuffer = new ListBuffer<Directive.ExportsDirective>();
            ListBuffer<Directive.ExportsDirective> listBuffer2 = new ListBuffer<Directive.ExportsDirective>();
            HashSet<String> hashSet = new HashSet<String>();
            for (JavaFileObject javaFileObject : this.fileManager.list(moduleSymbol.classLocation, "", EnumSet.of(JavaFileObject.Kind.CLASS), true)) {
                String string = this.fileManager.inferBinaryName(moduleSymbol.classLocation, javaFileObject);
                String string2 = string.lastIndexOf(46) != -1 ? string.substring(0, string.lastIndexOf(46)) : "";
                if (!hashSet.add(string2)) continue;
                Directive.ExportsDirective exportsDirective = new Directive.ExportsDirective(this.syms.enterPackage(moduleSymbol, this.names.fromString(string2)), null);
                listBuffer.add(exportsDirective);
                listBuffer2.add(exportsDirective);
            }
            moduleSymbol.exports = listBuffer2.toList();
            moduleSymbol.provides = List.nil();
            moduleSymbol.requires = List.nil();
            moduleSymbol.uses = List.nil();
            moduleSymbol.directives = listBuffer.toList();
            moduleSymbol.flags_field |= 0x40000000L;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private void completeAutomaticModule(Symbol.ModuleSymbol moduleSymbol) throws Symbol.CompletionFailure {
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        listBuffer.addAll((Collection<Object>)moduleSymbol.directives);
        ListBuffer<Object> listBuffer2 = new ListBuffer<Object>();
        for (Symbol.ModuleSymbol moduleSymbol2 : this.allModules()) {
            if (moduleSymbol2 == this.syms.unnamedModule || moduleSymbol2 == moduleSymbol) continue;
            EnumSet<Directive.RequiresFlag> enumSet = (moduleSymbol2.flags_field & 0x10000000000000L) != 0L ? EnumSet.of(Directive.RequiresFlag.TRANSITIVE) : EnumSet.noneOf(Directive.RequiresFlag.class);
            Directive.RequiresDirective requiresDirective = new Directive.RequiresDirective(moduleSymbol2, enumSet);
            listBuffer.add(requiresDirective);
            listBuffer2.add(requiresDirective);
        }
        Directive.RequiresDirective requiresDirective = new Directive.RequiresDirective(this.syms.unnamedModule);
        listBuffer.add(requiresDirective);
        listBuffer2.add(requiresDirective);
        moduleSymbol.requires = listBuffer2.toList();
        moduleSymbol.directives = listBuffer.toList();
    }

    private Symbol.Completer getSourceCompleter(final JCTree.JCCompilationUnit jCCompilationUnit) {
        return new Symbol.Completer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(Symbol symbol) throws Symbol.CompletionFailure {
                Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)symbol;
                moduleSymbol.flags_field |= 0x10000000L;
                ModuleVisitor moduleVisitor = new ModuleVisitor();
                JavaFileObject javaFileObject = Modules.this.log.useSource(jCCompilationUnit.sourcefile);
                JCTree.JCModuleDecl jCModuleDecl = jCCompilationUnit.getModuleDecl();
                JCDiagnostic.DiagnosticPosition diagnosticPosition = Modules.this.deferredLintHandler.setPos(jCModuleDecl.pos());
                try {
                    jCModuleDecl.accept(moduleVisitor);
                    Modules.this.completeModule(moduleSymbol);
                    Modules.this.checkCyclicDependencies(jCModuleDecl);
                }
                finally {
                    Modules.this.log.useSource(javaFileObject);
                    Modules.this.deferredLintHandler.setPos(diagnosticPosition);
                    moduleSymbol.flags_field &= 0xFFFFFFFFEFFFFFFFL;
                }
            }

            public String toString() {
                return "SourceCompleter: " + jCCompilationUnit.sourcefile.getName();
            }
        };
    }

    public boolean isRootModule(Symbol.ModuleSymbol moduleSymbol) {
        Assert.checkNonNull(this.rootModules);
        return this.rootModules.contains(moduleSymbol);
    }

    public Set<Symbol.ModuleSymbol> getRootModules() {
        Assert.checkNonNull(this.rootModules);
        return this.rootModules;
    }

    public Symbol.Completer getUsesProvidesCompleter() {
        return symbol -> {
            Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)symbol;
            moduleSymbol.complete();
            Env<AttrContext> env = this.typeEnvs.get(moduleSymbol);
            UsesProvidesVisitor usesProvidesVisitor = new UsesProvidesVisitor(moduleSymbol, env);
            JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
            JCTree.JCModuleDecl jCModuleDecl = env.toplevel.getModuleDecl();
            JCDiagnostic.DiagnosticPosition diagnosticPosition = this.deferredLintHandler.setPos(jCModuleDecl.pos());
            try {
                jCModuleDecl.accept(usesProvidesVisitor);
            }
            finally {
                this.log.useSource(javaFileObject);
                this.deferredLintHandler.setPos(diagnosticPosition);
            }
        };
    }

    public Set<Symbol.ModuleSymbol> allModules() {
        Assert.checkNonNull(this.allModules);
        return this.allModules;
    }

    private void setupAllModules() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object6;
        Set<Symbol.ModuleSymbol> set;
        Assert.checkNonNull(this.rootModules);
        Assert.checkNull(this.allModules);
        if (this.limitModsOpt == null && this.extraLimitMods.isEmpty()) {
            set = null;
        } else {
            object6 = new HashSet();
            if (this.limitModsOpt != null) {
                for (String object52 : this.limitModsOpt.split(",")) {
                    if (!this.isValidName(object52)) continue;
                    object6.add(this.syms.enterModule(this.names.fromString(object52)));
                }
            }
            for (String string : this.extraLimitMods) {
                object6.add(this.syms.enterModule(this.names.fromString(string)));
            }
            set = this.computeTransitiveClosure((Set<? extends Symbol.ModuleSymbol>)object6, this.rootModules, null);
            set.addAll(this.rootModules);
            if (this.lintOptions) {
                object4 = object6.iterator();
                while (object4.hasNext()) {
                    Symbol.ModuleSymbol moduleSymbol2 = (Symbol.ModuleSymbol)object4.next();
                    if (set.contains(moduleSymbol2)) continue;
                    this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.ModuleForOptionNotFound(Option.LIMIT_MODULES, moduleSymbol2));
                }
            }
        }
        object6 = moduleSymbol -> set == null ? this.moduleFinder.findModule((Symbol.ModuleSymbol)moduleSymbol).kind != Kinds.Kind.ERR : set.contains(moduleSymbol);
        object4 = moduleSymbol -> (moduleSymbol.flags() & 0x20000000000000L) != 0L;
        Predicate<Symbol.ModuleSymbol> predicate = moduleSymbol -> {
            moduleSymbol.complete();
            return !moduleSymbol.resolutionFlags.contains((Object)Symbol.ModuleResolutionFlags.DO_NOT_RESOLVE_BY_DEFAULT);
        };
        LinkedHashSet<Symbol.ModuleSymbol> linkedHashSet = new LinkedHashSet<Symbol.ModuleSymbol>();
        if (this.rootModules.contains(this.syms.unnamedModule)) {
            Symbol.ModuleSymbol moduleSymbol2 = this.syms.getModule(this.java_se);
            if (moduleSymbol2 != null && (set == null || set.contains(moduleSymbol2))) {
                object3 = moduleSymbol -> {
                    moduleSymbol.complete();
                    return !moduleSymbol.name.startsWith(this.java_) && moduleSymbol.exports.stream().anyMatch(exportsDirective -> exportsDirective.modules == null);
                };
                linkedHashSet.add(moduleSymbol2);
            } else {
                object3 = moduleSymbol -> true;
            }
            object2 = new HashSet(this.syms.getAllModules()).iterator();
            while (object2.hasNext()) {
                object = (Symbol.ModuleSymbol)object2.next();
                if (!object4.test(object) || !object6.test(object) || !object3.test(object) || !predicate.test((Symbol.ModuleSymbol)object)) continue;
                linkedHashSet.add((Symbol.ModuleSymbol)object);
            }
        }
        linkedHashSet.addAll(this.rootModules);
        if (this.addModsOpt != null || !this.extraAddMods.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.extraAddMods);
            if (this.addModsOpt != null) {
                hashSet.addAll(Arrays.asList(this.addModsOpt.split(",")));
            }
            object3 = hashSet.iterator();
            block12: while (object3.hasNext()) {
                switch (object2 = (String)object3.next()) {
                    case "ALL-SYSTEM": {
                        object = new HashSet(this.syms.getAllModules()).stream().filter(object4.and(object6));
                        break;
                    }
                    case "ALL-MODULE-PATH": {
                        object = new HashSet(this.syms.getAllModules()).stream().filter(object4.negate().and(object6));
                        break;
                    }
                    default: {
                        if (!this.isValidName((CharSequence)object2)) continue block12;
                        object = Stream.of(this.syms.enterModule(this.names.fromString((String)object2)));
                    }
                }
                object.forEach(moduleSymbol -> {
                    linkedHashSet.add(moduleSymbol);
                    if (set != null) {
                        set.add((Symbol.ModuleSymbol)moduleSymbol);
                    }
                });
            }
        }
        Set<Symbol.ModuleSymbol> set2 = this.computeTransitiveClosure(linkedHashSet, this.rootModules, set);
        set2.add(this.syms.unnamedModule);
        boolean bl = set2.stream().anyMatch(IS_AUTOMATIC);
        if (bl) {
            this.syms.getAllModules().stream().filter(IS_AUTOMATIC).forEach(set2::add);
        }
        if (!((String)(object2 = set2.stream().filter(moduleSymbol -> moduleSymbol.resolutionFlags.contains((Object)Symbol.ModuleResolutionFlags.WARN_INCUBATING)).map(moduleSymbol -> moduleSymbol.name.toString()).collect(Collectors.joining(",")))).isEmpty()) {
            this.log.warning(CompilerProperties.Warnings.IncubatingModules((String)object2));
        }
        this.allModules = set2;
        if (this.moduleVersionOpt != null) {
            object = this.names.fromString(this.moduleVersionOpt);
            this.rootModules.forEach(arg_0 -> Modules.lambda$setupAllModules$14((Name)object, arg_0));
        }
    }

    public boolean isInModuleGraph(Symbol.ModuleSymbol moduleSymbol) {
        return this.allModules == null || this.allModules.contains(moduleSymbol);
    }

    /*
     * WARNING - void declaration
     */
    private Set<Symbol.ModuleSymbol> computeTransitiveClosure(Set<? extends Symbol.ModuleSymbol> set, Set<? extends Symbol.ModuleSymbol> set2, Set<Symbol.ModuleSymbol> set3) {
        List<Object> list = List.nil();
        List<Object> list2 = List.nil();
        for (Symbol.ModuleSymbol moduleSymbol : set) {
            if (set2.contains(moduleSymbol)) {
                list = list.prepend(moduleSymbol);
                continue;
            }
            list2 = list2.prepend(moduleSymbol);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(this.syms.java_base);
        while (list.nonEmpty() || list2.nonEmpty()) {
            void var7_11;
            boolean bl;
            if (list.nonEmpty()) {
                Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)list.head;
                list = list.tail;
                bl = true;
            } else {
                Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)list2.head;
                list2 = list2.tail;
                bl = false;
            }
            if (set3 != null && !set3.contains(var7_11) || !linkedHashSet.add(var7_11) || var7_11 == this.syms.unnamedModule || (var7_11.flags_field & 0x10000000000000L) != 0L) continue;
            var7_11.complete();
            if (var7_11.kind == Kinds.Kind.ERR && (bl || set.contains(var7_11)) && this.warnedMissing.add((Symbol.ModuleSymbol)var7_11)) {
                this.log.error(CompilerProperties.Errors.ModuleNotFound((Symbol)var7_11));
            }
            for (Directive.RequiresDirective requiresDirective : var7_11.requires) {
                if (requiresDirective.module == this.syms.java_base) continue;
                if (requiresDirective.isTransitive() && bl || set2.contains(var7_11)) {
                    list = list.prepend(requiresDirective.module);
                    continue;
                }
                list2 = list2.prepend(requiresDirective.module);
            }
        }
        return linkedHashSet;
    }

    public Symbol.ModuleSymbol getObservableModule(Name name) {
        Symbol.ModuleSymbol moduleSymbol = this.syms.getModule(name);
        if (this.allModules().contains(moduleSymbol)) {
            return moduleSymbol;
        }
        return null;
    }

    private Symbol.Completer getUnnamedModuleCompleter() {
        this.moduleFinder.findAllModules();
        return new Symbol.Completer(){

            @Override
            public void complete(Symbol symbol) throws Symbol.CompletionFailure {
                if (Modules.this.inInitModules) {
                    symbol.completer = this;
                    return;
                }
                Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)symbol;
                HashSet<Symbol.ModuleSymbol> hashSet = new HashSet<Symbol.ModuleSymbol>(Modules.this.allModules());
                hashSet.remove(((Modules)Modules.this).syms.unnamedModule);
                for (Symbol.ModuleSymbol moduleSymbol2 : hashSet) {
                    moduleSymbol2.complete();
                }
                Modules.this.initVisiblePackages(moduleSymbol, hashSet);
            }

            public String toString() {
                return "unnamedModule Completer";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeModule(Symbol.ModuleSymbol moduleSymbol) {
        Object object;
        Iterable<Object> iterable;
        if (this.inInitModules) {
            moduleSymbol.completer = symbol -> this.completeModule(moduleSymbol);
            return;
        }
        if ((moduleSymbol.flags_field & 0x10000000000000L) != 0L) {
            this.completeAutomaticModule(moduleSymbol);
        }
        Assert.checkNonNull(moduleSymbol.requires);
        this.initAddReads();
        List<Directive.RequiresDirective> list = moduleSymbol.requires = moduleSymbol.requires.appendList(List.from(this.addReads.getOrDefault(moduleSymbol, Collections.emptySet())));
        while (list.nonEmpty()) {
            if (!this.allModules().contains(((Directive.RequiresDirective)list.head).module)) {
                iterable = this.typeEnvs.get(moduleSymbol);
                if (iterable != null) {
                    object = this.log.useSource(((Env)iterable).toplevel.sourcefile);
                    try {
                        this.log.error(((Env)iterable).tree, CompilerProperties.Errors.ModuleNotFound(((Directive.RequiresDirective)list.head).module));
                    }
                    finally {
                        this.log.useSource((JavaFileObject)object);
                    }
                } else {
                    Assert.check((moduleSymbol.flags() & 0x10000000000000L) == 0L);
                }
                moduleSymbol.requires = List.filter(moduleSymbol.requires, list.head);
            }
            list = list.tail;
        }
        iterable = new LinkedHashSet();
        object = new HashSet();
        for (Directive.RequiresDirective directive : moduleSymbol.requires) {
            directive.module.complete();
            iterable.add((Symbol.ModuleSymbol)directive.module);
            Set<Symbol.ModuleSymbol> set = this.retrieveRequiresTransitive(directive.module);
            Assert.checkNonNull(set, () -> "no entry in cache for " + requiresDirective.module);
            iterable.addAll(set);
            if (!directive.flags.contains((Object)Directive.RequiresFlag.TRANSITIVE)) continue;
            object.add(directive.module);
            object.addAll(set);
        }
        this.requiresTransitiveCache.put(moduleSymbol, (Set<Symbol.ModuleSymbol>)object);
        this.initVisiblePackages(moduleSymbol, (Collection<Symbol.ModuleSymbol>)iterable);
        for (Directive.ExportsDirective exportsDirective : moduleSymbol.exports) {
            if (exportsDirective.packge == null) continue;
            exportsDirective.packge.modle = moduleSymbol;
        }
        if (!this.allowAccessIntoSystem && (moduleSymbol.flags() & 0x20000000000000L) != 0L && moduleSymbol.patchLocation != null) {
            this.log.error(CompilerProperties.Errors.PatchModuleWithRelease(moduleSymbol));
        }
    }

    private Set<Symbol.ModuleSymbol> retrieveRequiresTransitive(Symbol.ModuleSymbol moduleSymbol) {
        Set<Symbol.ModuleSymbol> set = this.requiresTransitiveCache.get(moduleSymbol);
        if (set == null) {
            set = new HashSet<Symbol.ModuleSymbol>();
            HashSet<Symbol.ModuleSymbol> hashSet = new HashSet<Symbol.ModuleSymbol>();
            List<Symbol.ModuleSymbol> list = List.of(moduleSymbol);
            while (list.nonEmpty()) {
                Symbol.ModuleSymbol moduleSymbol2 = (Symbol.ModuleSymbol)list.head;
                list = list.tail;
                if (!hashSet.add(moduleSymbol2)) continue;
                set.add(moduleSymbol2);
                moduleSymbol2.complete();
                if (moduleSymbol2 != this.syms.unnamedModule) {
                    Assert.checkNonNull(moduleSymbol2.requires, () -> moduleSymbol2 + ".requires == null; " + moduleSymbol);
                    List<Directive.RequiresDirective> list2 = moduleSymbol2.requires;
                    for (Directive.RequiresDirective requiresDirective : list2) {
                        if (!requiresDirective.isTransitive()) continue;
                        list = list.prepend(requiresDirective.module);
                    }
                    continue;
                }
                for (Symbol.ModuleSymbol moduleSymbol3 : this.allModules()) {
                    list = list.prepend(moduleSymbol3);
                }
            }
            set.remove(moduleSymbol);
        }
        return set;
    }

    private void initVisiblePackages(Symbol.ModuleSymbol moduleSymbol, Collection<Symbol.ModuleSymbol> collection) {
        this.initAddExports();
        moduleSymbol.visiblePackages = new LinkedHashMap<Name, Symbol.PackageSymbol>();
        moduleSymbol.readModules = new HashSet<Symbol.ModuleSymbol>(collection);
        HashMap<Name, Symbol.ModuleSymbol> hashMap = new HashMap<Name, Symbol.ModuleSymbol>();
        for (Symbol.ModuleSymbol moduleSymbol3 : collection) {
            if (moduleSymbol3 == this.syms.unnamedModule) continue;
            this.addVisiblePackages(moduleSymbol, hashMap, moduleSymbol3, moduleSymbol3.exports);
        }
        this.addExports.forEach((moduleSymbol2, set) -> this.addVisiblePackages(moduleSymbol, (Map<Name, Symbol.ModuleSymbol>)hashMap, (Symbol.ModuleSymbol)moduleSymbol2, (Collection<Directive.ExportsDirective>)set));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVisiblePackages(Symbol.ModuleSymbol moduleSymbol, Map<Name, Symbol.ModuleSymbol> map, Symbol.ModuleSymbol moduleSymbol2, Collection<Directive.ExportsDirective> collection) {
        for (Directive.ExportsDirective exportsDirective : collection) {
            if (exportsDirective.modules != null && !exportsDirective.modules.contains(moduleSymbol)) continue;
            Name name = exportsDirective.packge.fullname;
            Symbol.ModuleSymbol moduleSymbol3 = map.get(name);
            if (moduleSymbol3 != null && moduleSymbol3 != moduleSymbol2) {
                Env<AttrContext> env = this.typeEnvs.get(moduleSymbol);
                JavaFileObject javaFileObject = env != null ? this.log.useSource(env.toplevel.sourcefile) : null;
                JCDiagnostic.DiagnosticPosition diagnosticPosition = env != null ? env.tree.pos() : null;
                try {
                    if (moduleSymbol.isUnnamed()) {
                        this.log.error(diagnosticPosition, CompilerProperties.Errors.PackageClashFromRequiresInUnnamed(name, moduleSymbol3, moduleSymbol2));
                        continue;
                    }
                    this.log.error(diagnosticPosition, CompilerProperties.Errors.PackageClashFromRequires(moduleSymbol, name, moduleSymbol3, moduleSymbol2));
                    continue;
                }
                finally {
                    if (env != null) {
                        this.log.useSource(javaFileObject);
                    }
                    continue;
                }
            }
            map.put(name, moduleSymbol2);
            moduleSymbol.visiblePackages.put(exportsDirective.packge.fullname, exportsDirective.packge);
        }
    }

    private void initAddExports() {
        if (this.addExports != null) {
            return;
        }
        this.addExports = new LinkedHashMap<Symbol.ModuleSymbol, Set<Directive.ExportsDirective>>();
        HashSet<Symbol.ModuleSymbol> hashSet = new HashSet<Symbol.ModuleSymbol>();
        if (this.addExportsOpt == null) {
            return;
        }
        Pattern pattern = Pattern.compile("([^/]+)/([^=]+)=(.*)");
        for (String string : this.addExportsOpt.split("\u0000+")) {
            Symbol.ModuleSymbol moduleSymbol2;
            Matcher matcher;
            if (string.isEmpty() || !(matcher = pattern.matcher(string)).matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (!this.isValidName(string2) || !this.isKnownModule(moduleSymbol2 = this.syms.enterModule(this.names.fromString(string2)), hashSet) || !this.isValidName(string3)) continue;
            if (!this.allowAccessIntoSystem && (moduleSymbol2.flags() & 0x20000000000000L) != 0L) {
                this.log.error(CompilerProperties.Errors.AddExportsWithRelease(moduleSymbol2));
                continue;
            }
            Symbol.PackageSymbol packageSymbol = this.syms.enterPackage(moduleSymbol2, this.names.fromString(string3));
            packageSymbol.modle = moduleSymbol2;
            List<Symbol.ModuleSymbol> list = List.nil();
            for (String string5 : string4.split("[ ,]+")) {
                Symbol.ModuleSymbol moduleSymbol3;
                if (string5.equals("ALL-UNNAMED")) {
                    moduleSymbol3 = this.syms.unnamedModule;
                } else if (!this.isValidName(string5) || !this.isKnownModule(moduleSymbol3 = this.syms.enterModule(this.names.fromString(string5)), hashSet)) continue;
                list = list.prepend(moduleSymbol3);
            }
            Set set = this.addExports.computeIfAbsent(moduleSymbol2, moduleSymbol -> new LinkedHashSet());
            Directive.ExportsDirective exportsDirective = new Directive.ExportsDirective(packageSymbol, list);
            set.add(exportsDirective);
        }
    }

    private boolean isKnownModule(Symbol.ModuleSymbol moduleSymbol, Set<Symbol.ModuleSymbol> set) {
        if (this.allModules.contains(moduleSymbol)) {
            return true;
        }
        if (!set.contains(moduleSymbol)) {
            if (this.lintOptions) {
                this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.ModuleForOptionNotFound(Option.ADD_EXPORTS, moduleSymbol));
            }
            set.add(moduleSymbol);
        }
        return false;
    }

    private void initAddReads() {
        if (this.addReads != null) {
            return;
        }
        this.addReads = new LinkedHashMap<Symbol.ModuleSymbol, Set<Directive.RequiresDirective>>();
        if (this.addReadsOpt == null) {
            return;
        }
        Pattern pattern = Pattern.compile("([^=]+)=(.*)");
        for (String string : this.addReadsOpt.split("\u0000+")) {
            Matcher matcher;
            if (string.isEmpty() || !(matcher = pattern.matcher(string)).matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (!this.isValidName(string2)) continue;
            Symbol.ModuleSymbol moduleSymbol2 = this.syms.enterModule(this.names.fromString(string2));
            if (!this.allModules.contains(moduleSymbol2)) {
                if (!this.lintOptions) continue;
                this.log.warning(CompilerProperties.Warnings.ModuleForOptionNotFound(Option.ADD_READS, moduleSymbol2));
                continue;
            }
            if (!this.allowAccessIntoSystem && (moduleSymbol2.flags() & 0x20000000000000L) != 0L) {
                this.log.error(CompilerProperties.Errors.AddReadsWithRelease(moduleSymbol2));
                continue;
            }
            for (String string4 : string3.split("[ ,]+", -1)) {
                Symbol.ModuleSymbol moduleSymbol3;
                if (string4.equals("ALL-UNNAMED")) {
                    moduleSymbol3 = this.syms.unnamedModule;
                } else {
                    if (!this.isValidName(string4)) continue;
                    moduleSymbol3 = this.syms.enterModule(this.names.fromString(string4));
                    if (!this.allModules.contains(moduleSymbol3)) {
                        if (!this.lintOptions) continue;
                        this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.ModuleForOptionNotFound(Option.ADD_READS, moduleSymbol3));
                        continue;
                    }
                }
                this.addReads.computeIfAbsent(moduleSymbol2, moduleSymbol -> new HashSet()).add(new Directive.RequiresDirective(moduleSymbol3, EnumSet.of(Directive.RequiresFlag.EXTRA)));
            }
        }
    }

    private void checkCyclicDependencies(JCTree.JCModuleDecl jCModuleDecl) {
        for (JCTree.JCDirective jCDirective : jCModuleDecl.directives) {
            if (!jCDirective.hasTag(JCTree.Tag.REQUIRES)) continue;
            JCTree.JCRequires jCRequires = (JCTree.JCRequires)jCDirective;
            if (jCRequires.directive == null) continue;
            HashSet<Symbol.ModuleSymbol> hashSet = new HashSet<Symbol.ModuleSymbol>();
            List<Symbol.ModuleSymbol> list = List.of(jCRequires.directive.module);
            while (list.nonEmpty()) {
                Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)list.head;
                list = list.tail;
                if (!hashSet.add(moduleSymbol)) continue;
                moduleSymbol.complete();
                if ((moduleSymbol.flags() & 0x40000000L) != 0L) continue;
                Assert.checkNonNull(moduleSymbol.requires, moduleSymbol::toString);
                for (Directive.RequiresDirective requiresDirective : moduleSymbol.requires) {
                    if (requiresDirective.flags.contains((Object)Directive.RequiresFlag.EXTRA)) continue;
                    list = list.prepend(requiresDirective.module);
                }
            }
            if (hashSet.contains(jCModuleDecl.sym)) {
                this.log.error(jCRequires.moduleName.pos(), CompilerProperties.Errors.CyclicRequires(jCRequires.directive.module));
            }
            jCModuleDecl.sym.flags_field |= 0x40000000L;
        }
    }

    private boolean isValidName(CharSequence charSequence) {
        return SourceVersion.isName((CharSequence)charSequence, (SourceVersion)Source.toSourceVersion(this.source));
    }

    private String toString(Symbol.ModuleSymbol moduleSymbol) {
        return moduleSymbol.name + "[kind:" + (Object)((Object)moduleSymbol.kind) + ";locn:" + this.toString(moduleSymbol.sourceLocation) + "," + this.toString(moduleSymbol.classLocation) + ";info:" + this.toString(moduleSymbol.module_info.sourcefile) + "," + this.toString(moduleSymbol.module_info.classfile) + "," + moduleSymbol.module_info.completer + "]";
    }

    String toString(JavaFileManager.Location location) {
        return location == null ? "--" : location.getName();
    }

    String toString(JavaFileObject javaFileObject) {
        return javaFileObject == null ? "--" : javaFileObject.getName();
    }

    public void newRound() {
        this.allModules = null;
        this.rootModules = null;
        this.warnedMissing.clear();
    }

    private static /* synthetic */ void lambda$setupAllModules$14(Name name, Symbol.ModuleSymbol moduleSymbol) {
        moduleSymbol.version = name;
    }

    public static interface PackageNameFinder {
        public Name findPackageNameOf(JavaFileObject var1);
    }

    class UsesProvidesVisitor
    extends JCTree.Visitor {
        private final Symbol.ModuleSymbol msym;
        private final Env<AttrContext> env;
        private final Set<Symbol.ClassSymbol> allUses = new HashSet<Symbol.ClassSymbol>();
        private final Map<Symbol.ClassSymbol, Set<Symbol.ClassSymbol>> allProvides = new HashMap<Symbol.ClassSymbol, Set<Symbol.ClassSymbol>>();
        Map<Directive.ProvidesDirective, JCTree.JCProvides> directiveToTreeMap = new HashMap<Directive.ProvidesDirective, JCTree.JCProvides>();

        public UsesProvidesVisitor(Symbol.ModuleSymbol moduleSymbol, Env<AttrContext> env) {
            this.msym = moduleSymbol;
            this.env = env;
        }

        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
            this.msym.directives = List.nil();
            this.msym.provides = List.nil();
            this.msym.uses = List.nil();
            jCModuleDecl.directives.forEach(jCDirective -> jCDirective.accept(this));
            this.msym.directives = this.msym.directives.reverse();
            this.msym.provides = this.msym.provides.reverse();
            this.msym.uses = this.msym.uses.reverse();
            if (this.msym.requires.nonEmpty() && ((Directive.RequiresDirective)this.msym.requires.head).flags.contains((Object)Directive.RequiresFlag.MANDATED)) {
                this.msym.directives = this.msym.directives.prepend((Directive)this.msym.requires.head);
            }
            this.msym.directives = this.msym.directives.appendList(List.from(Modules.this.addReads.getOrDefault(this.msym, Collections.emptySet())));
            this.checkForCorrectness();
        }

        public void visitExports(JCTree.JCExports jCExports) {
            Iterable iterable = jCExports.directive.packge.members().getSymbols();
            List<JavaFileObject> list = List.nil();
            boolean bl = false;
            for (Symbol object : iterable) {
                if (object.kind != Kinds.Kind.TYP) continue;
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)object;
                if (object.completer.isTerminal() || classSymbol.classfile.getKind() == JavaFileObject.Kind.CLASS) {
                    bl = true;
                    list = List.nil();
                    break;
                }
                if (classSymbol.classfile.getKind() != JavaFileObject.Kind.SOURCE) continue;
                list = list.prepend(classSymbol.classfile);
            }
            for (JavaFileObject javaFileObject : list) {
                if (Modules.this.findPackageInFile.findPackageNameOf(javaFileObject) != jCExports.directive.packge.fullname) continue;
                bl = true;
                break;
            }
            if (!bl) {
                Modules.this.log.error(jCExports.qualid.pos(), CompilerProperties.Errors.PackageEmptyOrNotFound(jCExports.directive.packge));
            }
            this.msym.directives = this.msym.directives.prepend(jCExports.directive);
        }

        public void visitOpens(JCTree.JCOpens jCOpens) {
            Modules.this.chk.checkPackageExistsForOpens(jCOpens.qualid, jCOpens.directive.packge);
            this.msym.directives = this.msym.directives.prepend(jCOpens.directive);
        }

        Symbol.MethodSymbol noArgsConstructor(Symbol.ClassSymbol classSymbol) {
            for (Symbol symbol : classSymbol.members().getSymbolsByName(((Modules)Modules.this).names.init)) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                if (!methodSymbol.params().isEmpty()) continue;
                return methodSymbol;
            }
            return null;
        }

        Symbol.MethodSymbol factoryMethod(Symbol.ClassSymbol classSymbol) {
            for (Symbol symbol2 : classSymbol.members().getSymbolsByName(((Modules)Modules.this).names.provider, symbol -> symbol.kind == Kinds.Kind.MTH)) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol2;
                if (!methodSymbol.isStatic() || (methodSymbol.flags() & 1L) == 0L || !methodSymbol.params().isEmpty()) continue;
                return methodSymbol;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitProvides(JCTree.JCProvides jCProvides) {
            Type type = Modules.this.attr.attribType(jCProvides.serviceName, this.env, ((Modules)Modules.this).syms.objectType);
            Symbol.ClassSymbol classSymbol2 = (Symbol.ClassSymbol)type.tsym;
            if (this.allProvides.containsKey(classSymbol2)) {
                Modules.this.log.error(jCProvides.serviceName.pos(), CompilerProperties.Errors.RepeatedProvidesForService(classSymbol2));
            }
            ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
            for (JCTree.JCExpression jCExpression : jCProvides.implNames) {
                AnnoConstruct annoConstruct;
                Symbol.MethodSymbol methodSymbol;
                Type type2;
                boolean bl = ((AttrContext)this.env.info).visitingServiceImplementation;
                try {
                    ((AttrContext)this.env.info).visitingServiceImplementation = true;
                    type2 = Modules.this.attr.attribType(jCExpression, this.env, ((Modules)Modules.this).syms.objectType);
                }
                finally {
                    ((AttrContext)this.env.info).visitingServiceImplementation = bl;
                }
                Symbol.ClassSymbol classSymbol3 = (Symbol.ClassSymbol)type2.tsym;
                if ((classSymbol3.flags_field & 1L) == 0L) {
                    Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.NotDefPublic(classSymbol3, classSymbol3.location()));
                }
                if ((methodSymbol = this.factoryMethod(classSymbol3)) != null) {
                    annoConstruct = methodSymbol.type.getReturnType();
                    if (!Modules.this.types.isSubtype((Type)annoConstruct, type)) {
                        Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ServiceImplementationProviderReturnMustBeSubtypeOfServiceInterface);
                    }
                } else if (!Modules.this.types.isSubtype(type2, type)) {
                    Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ServiceImplementationMustBeSubtypeOfServiceInterface);
                } else if ((classSymbol3.flags() & 0x400L) != 0L) {
                    Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ServiceImplementationIsAbstract(classSymbol3));
                } else if (classSymbol3.isInner()) {
                    Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ServiceImplementationIsInner(classSymbol3));
                } else {
                    annoConstruct = this.noArgsConstructor(classSymbol3);
                    if (annoConstruct == null) {
                        Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ServiceImplementationDoesntHaveANoArgsConstructor(classSymbol3));
                    } else if ((((Symbol)annoConstruct).flags() & 1L) == 0L) {
                        Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ServiceImplementationNoArgsConstructorNotPublic(classSymbol3));
                    }
                }
                if (!type2.hasTag(TypeTag.CLASS)) continue;
                if (this.allProvides.computeIfAbsent(classSymbol2, classSymbol -> new HashSet()).add(classSymbol3)) {
                    listBuffer.append(classSymbol3);
                    continue;
                }
                Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.DuplicateProvides(classSymbol2, classSymbol3));
            }
            if (type.hasTag(TypeTag.CLASS) && !listBuffer.isEmpty()) {
                Directive.ProvidesDirective providesDirective = new Directive.ProvidesDirective(classSymbol2, listBuffer.toList());
                this.msym.provides = this.msym.provides.prepend(providesDirective);
                this.msym.directives = this.msym.directives.prepend(providesDirective);
                this.directiveToTreeMap.put(providesDirective, jCProvides);
            }
        }

        public void visitRequires(JCTree.JCRequires jCRequires) {
            if (jCRequires.directive != null && Modules.this.allModules().contains(jCRequires.directive.module)) {
                Modules.this.chk.checkDeprecated(jCRequires.moduleName.pos(), this.msym, jCRequires.directive.module);
                Modules.this.chk.checkModuleRequires(jCRequires.moduleName.pos(), jCRequires.directive);
                this.msym.directives = this.msym.directives.prepend(jCRequires.directive);
            }
        }

        public void visitUses(JCTree.JCUses jCUses) {
            Type type = Modules.this.attr.attribType(jCUses.qualid, this.env, ((Modules)Modules.this).syms.objectType);
            Symbol symbol = TreeInfo.symbol(jCUses.qualid);
            if ((symbol.flags() & 0x4000L) != 0L) {
                Modules.this.log.error(jCUses.qualid.pos(), CompilerProperties.Errors.ServiceDefinitionIsEnum(type.tsym));
            } else if (type.hasTag(TypeTag.CLASS)) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)type.tsym;
                if (this.allUses.add(classSymbol)) {
                    Directive.UsesDirective usesDirective = new Directive.UsesDirective(classSymbol);
                    this.msym.uses = this.msym.uses.prepend(usesDirective);
                    this.msym.directives = this.msym.directives.prepend(usesDirective);
                } else {
                    Modules.this.log.error(jCUses.pos(), CompilerProperties.Errors.DuplicateUses(classSymbol));
                }
            }
        }

        private void checkForCorrectness() {
            for (Directive.ProvidesDirective providesDirective : this.msym.provides) {
                JCTree.JCProvides jCProvides = this.directiveToTreeMap.get(providesDirective);
                for (Symbol.ClassSymbol classSymbol : providesDirective.impls) {
                    boolean bl;
                    Symbol.PackageSymbol packageSymbol = classSymbol.packge();
                    if (packageSymbol.modle != this.msym) {
                        Modules.this.log.error(jCProvides.pos(), CompilerProperties.Errors.ServiceImplementationNotInRightModule(packageSymbol.modle));
                    }
                    Symbol.PackageSymbol packageSymbol2 = providesDirective.service.packge();
                    boolean bl2 = packageSymbol2.modle == this.msym;
                    boolean bl3 = bl = this.msym.visiblePackages.get(packageSymbol2.fullname) == packageSymbol2;
                    if (!bl2 || bl) continue;
                    boolean bl4 = true;
                    for (Directive.ExportsDirective exportsDirective : this.msym.exports) {
                        if (packageSymbol2 != exportsDirective.packge) continue;
                        bl4 = false;
                        break;
                    }
                    if (bl4) {
                        for (Directive.UsesDirective usesDirective : this.msym.uses) {
                            if (providesDirective.service != usesDirective.service) continue;
                            bl4 = false;
                            break;
                        }
                    }
                    if (!bl4) continue;
                    Modules.this.log.warning(jCProvides.pos(), CompilerProperties.Warnings.ServiceProvidedButNotExportedOrUsed(providesDirective.service));
                }
            }
        }
    }

    class ModuleVisitor
    extends JCTree.Visitor {
        private Symbol.ModuleSymbol sym;
        private final Set<Symbol.ModuleSymbol> allRequires = new HashSet<Symbol.ModuleSymbol>();
        private final Map<Symbol.PackageSymbol, List<Directive.ExportsDirective>> allExports = new HashMap<Symbol.PackageSymbol, List<Directive.ExportsDirective>>();
        private final Map<Symbol.PackageSymbol, List<Directive.OpensDirective>> allOpens = new HashMap<Symbol.PackageSymbol, List<Directive.OpensDirective>>();

        ModuleVisitor() {
        }

        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
            this.sym = Assert.checkNonNull(jCModuleDecl.sym);
            if (jCModuleDecl.getModuleType() == ModuleTree.ModuleKind.OPEN) {
                this.sym.flags.add(Symbol.ModuleFlags.OPEN);
            }
            this.sym.flags_field |= jCModuleDecl.mods.flags & 0x20000L;
            this.sym.requires = List.nil();
            this.sym.exports = List.nil();
            this.sym.opens = List.nil();
            jCModuleDecl.directives.forEach(jCDirective -> jCDirective.accept(this));
            this.sym.requires = this.sym.requires.reverse();
            this.sym.exports = this.sym.exports.reverse();
            this.sym.opens = this.sym.opens.reverse();
            this.ensureJavaBase();
        }

        public void visitRequires(JCTree.JCRequires jCRequires) {
            Symbol.ModuleSymbol moduleSymbol = this.lookupModule(jCRequires.moduleName);
            if (moduleSymbol.kind != Kinds.Kind.MDL) {
                Modules.this.log.error(jCRequires.moduleName.pos(), CompilerProperties.Errors.ModuleNotFound(moduleSymbol));
                Modules.this.warnedMissing.add(moduleSymbol);
            } else if (this.allRequires.contains(moduleSymbol)) {
                Modules.this.log.error(jCRequires.moduleName.pos(), CompilerProperties.Errors.DuplicateRequires(moduleSymbol));
            } else {
                Directive.RequiresDirective requiresDirective;
                this.allRequires.add(moduleSymbol);
                EnumSet<Directive.RequiresFlag> enumSet = EnumSet.noneOf(Directive.RequiresFlag.class);
                if (jCRequires.isTransitive) {
                    enumSet.add(Directive.RequiresFlag.TRANSITIVE);
                }
                if (jCRequires.isStaticPhase) {
                    enumSet.add(Directive.RequiresFlag.STATIC_PHASE);
                }
                jCRequires.directive = requiresDirective = new Directive.RequiresDirective(moduleSymbol, enumSet);
                this.sym.requires = this.sym.requires.prepend(requiresDirective);
            }
        }

        public void visitExports(JCTree.JCExports jCExports) {
            EnumSet<Directive.ExportsFlag> enumSet2;
            Name name = TreeInfo.fullName(jCExports.qualid);
            Symbol.PackageSymbol packageSymbol2 = Modules.this.syms.enterPackage(this.sym, name);
            Modules.this.attr.setPackageSymbols(jCExports.qualid, packageSymbol2);
            List list = this.allExports.computeIfAbsent(packageSymbol2, packageSymbol -> List.nil());
            for (EnumSet<Directive.ExportsFlag> enumSet2 : list) {
                this.reportExportsConflict(jCExports, packageSymbol2);
            }
            Object object = null;
            if (jCExports.moduleNames != null) {
                enumSet2 = new LinkedHashSet();
                for (JCTree.JCExpression jCExpression : jCExports.moduleNames) {
                    Symbol.ModuleSymbol moduleSymbol = this.lookupModule(jCExpression);
                    Modules.this.chk.checkModuleExists(jCExpression.pos(), moduleSymbol);
                    for (Directive.ExportsDirective exportsDirective : list) {
                        this.checkDuplicateExportsToModule(jCExpression, moduleSymbol, exportsDirective);
                    }
                    if (enumSet2.add((Directive.ExportsFlag)((Object)moduleSymbol))) continue;
                    this.reportExportsConflictToModule(jCExpression, moduleSymbol);
                }
                object = List.from(enumSet2);
            }
            if (object == null || !((List)object).isEmpty()) {
                enumSet2 = EnumSet.noneOf(Directive.ExportsFlag.class);
                Directive.ExportsDirective exportsDirective = new Directive.ExportsDirective(packageSymbol2, (List<Symbol.ModuleSymbol>)object, (Set<Directive.ExportsFlag>)enumSet2);
                this.sym.exports = this.sym.exports.prepend(exportsDirective);
                jCExports.directive = exportsDirective;
                this.allExports.put(packageSymbol2, list.prepend(exportsDirective));
            }
        }

        private void reportExportsConflict(JCTree.JCExports jCExports, Symbol.PackageSymbol packageSymbol) {
            Modules.this.log.error(jCExports.qualid.pos(), CompilerProperties.Errors.ConflictingExports(packageSymbol));
        }

        private void checkDuplicateExportsToModule(JCTree.JCExpression jCExpression, Symbol.ModuleSymbol moduleSymbol, Directive.ExportsDirective exportsDirective) {
            if (exportsDirective.modules != null) {
                for (Symbol.ModuleSymbol moduleSymbol2 : exportsDirective.modules) {
                    if (moduleSymbol != moduleSymbol2) continue;
                    this.reportExportsConflictToModule(jCExpression, moduleSymbol);
                }
            }
        }

        private void reportExportsConflictToModule(JCTree.JCExpression jCExpression, Symbol.ModuleSymbol moduleSymbol) {
            Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ConflictingExportsToModule(moduleSymbol));
        }

        public void visitOpens(JCTree.JCOpens jCOpens) {
            EnumSet<Directive.OpensFlag> enumSet2;
            Name name = TreeInfo.fullName(jCOpens.qualid);
            Symbol.PackageSymbol packageSymbol2 = Modules.this.syms.enterPackage(this.sym, name);
            Modules.this.attr.setPackageSymbols(jCOpens.qualid, packageSymbol2);
            if (this.sym.flags.contains((Object)Symbol.ModuleFlags.OPEN)) {
                Modules.this.log.error(jCOpens.pos(), CompilerProperties.Errors.NoOpensUnlessStrong);
            }
            List list = this.allOpens.computeIfAbsent(packageSymbol2, packageSymbol -> List.nil());
            for (EnumSet<Directive.OpensFlag> enumSet2 : list) {
                this.reportOpensConflict(jCOpens, packageSymbol2);
            }
            Object object = null;
            if (jCOpens.moduleNames != null) {
                enumSet2 = new LinkedHashSet();
                for (JCTree.JCExpression jCExpression : jCOpens.moduleNames) {
                    Symbol.ModuleSymbol moduleSymbol = this.lookupModule(jCExpression);
                    Modules.this.chk.checkModuleExists(jCExpression.pos(), moduleSymbol);
                    for (Directive.OpensDirective opensDirective : list) {
                        this.checkDuplicateOpensToModule(jCExpression, moduleSymbol, opensDirective);
                    }
                    if (enumSet2.add((Directive.OpensFlag)((Object)moduleSymbol))) continue;
                    this.reportOpensConflictToModule(jCExpression, moduleSymbol);
                }
                object = List.from(enumSet2);
            }
            if (object == null || !((List)object).isEmpty()) {
                enumSet2 = EnumSet.noneOf(Directive.OpensFlag.class);
                Directive.OpensDirective opensDirective = new Directive.OpensDirective(packageSymbol2, (List<Symbol.ModuleSymbol>)object, (Set<Directive.OpensFlag>)enumSet2);
                this.sym.opens = this.sym.opens.prepend(opensDirective);
                jCOpens.directive = opensDirective;
                this.allOpens.put(packageSymbol2, list.prepend(opensDirective));
            }
        }

        private void reportOpensConflict(JCTree.JCOpens jCOpens, Symbol.PackageSymbol packageSymbol) {
            Modules.this.log.error(jCOpens.qualid.pos(), CompilerProperties.Errors.ConflictingOpens(packageSymbol));
        }

        private void checkDuplicateOpensToModule(JCTree.JCExpression jCExpression, Symbol.ModuleSymbol moduleSymbol, Directive.OpensDirective opensDirective) {
            if (opensDirective.modules != null) {
                for (Symbol.ModuleSymbol moduleSymbol2 : opensDirective.modules) {
                    if (moduleSymbol != moduleSymbol2) continue;
                    this.reportOpensConflictToModule(jCExpression, moduleSymbol);
                }
            }
        }

        private void reportOpensConflictToModule(JCTree.JCExpression jCExpression, Symbol.ModuleSymbol moduleSymbol) {
            Modules.this.log.error(jCExpression.pos(), CompilerProperties.Errors.ConflictingOpensToModule(moduleSymbol));
        }

        public void visitProvides(JCTree.JCProvides jCProvides) {
        }

        public void visitUses(JCTree.JCUses jCUses) {
        }

        private void ensureJavaBase() {
            Directive.RequiresDirective requiresDirective2;
            if (this.sym.name == ((Modules)Modules.this).names.java_base) {
                return;
            }
            for (Directive.RequiresDirective requiresDirective2 : this.sym.requires) {
                if (requiresDirective2.module.name != ((Modules)Modules.this).names.java_base) continue;
                return;
            }
            Symbol.ModuleSymbol moduleSymbol = Modules.this.syms.enterModule(((Modules)Modules.this).names.java_base);
            requiresDirective2 = new Directive.RequiresDirective(moduleSymbol, EnumSet.of(Directive.RequiresFlag.MANDATED));
            this.sym.requires = this.sym.requires.prepend(requiresDirective2);
        }

        private Symbol.ModuleSymbol lookupModule(JCTree.JCExpression jCExpression) {
            Name name = TreeInfo.fullName(jCExpression);
            Symbol.ModuleSymbol moduleSymbol = Modules.this.moduleFinder.findModule(name);
            TreeInfo.setSymbol(jCExpression, moduleSymbol);
            return moduleSymbol;
        }
    }
}

