/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformUtils;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class Arguments {
    public static final Context.Key<Arguments> argsKey = new Context.Key();
    private String ownName;
    private Set<String> classNames;
    private Set<Path> files;
    private Map<Option, String> deferredFileManagerOptions;
    private Set<JavaFileObject> fileObjects;
    private boolean emptyAllowed;
    private final Options options;
    private JavaFileManager fileManager;
    private final Log log;
    private final Context context;
    private ErrorMode errorMode;
    private boolean errors;
    private final OptionHelper cmdLineHelper = new OptionHelper(){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String string, String string2) {
            Arguments.this.options.put(string, string2);
        }

        @Override
        public void remove(String string) {
            Arguments.this.options.remove(string);
        }

        public boolean handleFileManagerOption(Option option, String string) {
            Arguments.this.options.put(option, string);
            Arguments.this.deferredFileManagerOptions.put(option, string);
            return true;
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }

        @Override
        public String getOwnName() {
            return Arguments.this.ownName;
        }

        public void addFile(Path path) {
            Arguments.this.files.add(path);
        }

        @Override
        public void addClassName(String string) {
            Arguments.this.classNames.add(string);
        }
    };
    private final OptionHelper apiHelper = new OptionHelper.GrumpyHelper(null){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String string, String string2) {
            Arguments.this.options.put(string, string2);
        }

        @Override
        public void remove(String string) {
            Arguments.this.options.remove(string);
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }
    };

    public static Arguments instance(Context context) {
        Arguments arguments = context.get(argsKey);
        if (arguments == null) {
            arguments = new Arguments(context);
        }
        return arguments;
    }

    protected Arguments(Context context) {
        context.put(argsKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
        this.context = context;
    }

    public void init(String string, String ... stringArray) {
        this.ownName = string;
        this.errorMode = ErrorMode.LOG;
        this.files = new LinkedHashSet<Path>();
        this.deferredFileManagerOptions = new LinkedHashMap<Option, String>();
        this.fileObjects = null;
        this.classNames = new LinkedHashSet<String>();
        this.processArgs(List.from(stringArray), Option.getJavaCompilerOptions(), this.cmdLineHelper, true, false);
        if (this.errors) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", string);
        }
    }

    public void init(String string, Iterable<String> iterable, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3) {
        this.ownName = string;
        this.classNames = this.toSet(iterable2);
        this.fileObjects = this.toSet(iterable3);
        this.files = null;
        this.errorMode = ErrorMode.ILLEGAL_ARGUMENT;
        if (iterable != null) {
            this.processArgs(this.toList(iterable), Option.getJavacToolOptions(), this.apiHelper, false, true);
        }
        this.errorMode = ErrorMode.ILLEGAL_STATE;
    }

    public void init(String string) {
        this.ownName = string;
        this.errorMode = ErrorMode.LOG;
    }

    public Set<JavaFileObject> getFileObjects() {
        if (this.fileObjects == null) {
            this.fileObjects = new LinkedHashSet<JavaFileObject>();
        }
        if (this.files != null) {
            JavacFileManager javacFileManager = (JavacFileManager)this.getFileManager();
            for (JavaFileObject javaFileObject : javacFileManager.getJavaFileObjectsFromPaths(this.files)) {
                this.fileObjects.add(javaFileObject);
            }
        }
        return this.fileObjects;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public boolean handleReleaseOptions(Predicate<Iterable<String>> predicate) {
        String string = this.options.get(Option.RELEASE);
        this.checkOptionAllowed(string == null, option -> this.error("err.release.bootclasspath.conflict", option.getPrimaryName()), Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.XBOOTCLASSPATH_PREPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS, Option.SOURCE, Option.TARGET, Option.SYSTEM, Option.UPGRADE_MODULE_PATH);
        if (string != null) {
            PlatformDescription platformDescription = PlatformUtils.lookupPlatformDescription(string);
            if (platformDescription == null) {
                this.error("err.unsupported.release.version", string);
                return false;
            }
            this.options.put(Option.SOURCE, platformDescription.getSourceVersion());
            this.options.put(Option.TARGET, platformDescription.getTargetVersion());
            this.context.put(PlatformDescription.class, platformDescription);
            if (!predicate.test(platformDescription.getAdditionalOptions())) {
                return false;
            }
            Collection<Path> collection = platformDescription.getPlatformPath();
            if (collection != null) {
                JavaFileManager javaFileManager = this.getFileManager();
                if (!(javaFileManager instanceof StandardJavaFileManager)) {
                    this.error("err.release.not.standard.file.manager", new Object[0]);
                    return false;
                }
                try {
                    StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)javaFileManager;
                    if (Source.instance(this.context).allowModules()) {
                        standardJavaFileManager.handleOption("--system", Arrays.asList("none").iterator());
                        standardJavaFileManager.setLocationFromPaths(StandardLocation.UPGRADE_MODULE_PATH, collection);
                    } else {
                        standardJavaFileManager.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, collection);
                    }
                }
                catch (IOException iOException) {
                    this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
                    iOException.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
                    return false;
                }
            }
        }
        return true;
    }

    private boolean processArgs(Iterable<String> iterable2, Set<Option> set, OptionHelper optionHelper, boolean bl, boolean bl2) {
        if (!this.doProcessArgs(iterable2, set, optionHelper, bl, bl2)) {
            return false;
        }
        if (!this.handleReleaseOptions(iterable -> this.doProcessArgs((Iterable<String>)iterable, set, optionHelper, bl, bl2))) {
            return false;
        }
        this.options.notifyListeners();
        return true;
    }

    private boolean doProcessArgs(Iterable<String> iterable, Set<Option> set, OptionHelper optionHelper, boolean bl, boolean bl2) {
        JavaFileManager javaFileManager = bl2 ? this.getFileManager() : null;
        Iterator<String> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.isEmpty()) {
                this.error("err.invalid.flag", string);
                return false;
            }
            Option option = null;
            if (string.startsWith("-")) {
                option = Option.lookup((String)string, set);
            } else if (bl && Option.SOURCEFILE.matches(string)) {
                option = Option.SOURCEFILE;
            }
            if (option != null) {
                try {
                    option.handleOption(optionHelper, string, iterator);
                    continue;
                }
                catch (Option.InvalidValueException invalidValueException) {
                    this.error(invalidValueException);
                    return false;
                }
            }
            if (javaFileManager != null && javaFileManager.handleOption(string, iterator)) continue;
            this.error("err.invalid.flag", string);
            return false;
        }
        return true;
    }

    public boolean validate() {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        JavaFileManager javaFileManager = this.getFileManager();
        if (this.options.isSet(Option.MODULE)) {
            if (!javaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                this.log.error(CompilerProperties.Errors.OutputDirMustBeSpecifiedWithDashMOption);
            } else if (!javaFileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                this.log.error(CompilerProperties.Errors.ModulesourcepathMustBeSpecifiedWithDashMOption);
            } else {
                object6 = Arrays.asList(this.options.get(Option.MODULE).split(","));
                try {
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        String string = object5.next();
                        object4 = javaFileManager.getLocationForModule(StandardLocation.MODULE_SOURCE_PATH, string);
                        if (object4 == null) {
                            this.log.error(CompilerProperties.Errors.ModuleNotFoundInModuleSourcePath(string));
                            continue;
                        }
                        object3 = javaFileManager.getLocationForModule(StandardLocation.CLASS_OUTPUT, string);
                        for (JavaFileObject javaFileObject : javaFileManager.list((JavaFileManager.Location)object4, "", EnumSet.of(JavaFileObject.Kind.SOURCE), true)) {
                            object2 = javaFileManager.inferBinaryName((JavaFileManager.Location)object4, javaFileObject);
                            object = javaFileManager.getJavaFileForInput((JavaFileManager.Location)object3, (String)object2, JavaFileObject.Kind.CLASS);
                            if (object != null && object.getLastModified() >= javaFileObject.getLastModified()) continue;
                            if (this.fileObjects == null) {
                                this.fileObjects = new HashSet<JavaFileObject>();
                            }
                            this.fileObjects.add(javaFileObject);
                        }
                    }
                }
                catch (IOException iOException) {
                    this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
                    iOException.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
                    return false;
                }
            }
        }
        if (this.isEmpty()) {
            if (this.options.isSet(Option.HELP) || this.options.isSet(Option.X) || this.options.isSet(Option.VERSION) || this.options.isSet(Option.FULLVERSION) || this.options.isSet(Option.MODULE)) {
                return true;
            }
            if (!this.emptyAllowed) {
                if (!this.errors) {
                    if (JavaCompiler.explicitAnnotationProcessingRequested(this.options)) {
                        this.error("err.no.source.files.classes", new Object[0]);
                    } else {
                        this.error("err.no.source.files", new Object[0]);
                    }
                }
                return false;
            }
        }
        if (!this.checkDirectory(Option.D)) {
            return false;
        }
        if (!this.checkDirectory(Option.S)) {
            return false;
        }
        if (!this.checkDirectory(Option.H)) {
            return false;
        }
        if (javaFileManager instanceof StandardJavaFileManager && (object6 = (StandardJavaFileManager)this.fileManager).hasLocation(StandardLocation.CLASS_OUTPUT)) {
            object5 = (Path)object6.getLocationAsPaths((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT).iterator().next();
            if (object6.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                if (Files.exists(object5.resolve("module-info.class"), new LinkOption[0])) {
                    this.log.error(CompilerProperties.Errors.MultiModuleOutdirCannotBeExplodedModule((Path)object5));
                }
            } else {
                boolean bl2 = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.PATH.option);
                if (bl2 && (object4 = object5.getParent()) != null && Files.exists(object4.resolve("module-info.class"), new LinkOption[0])) {
                    this.log.warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.OutdirIsInExplodedModule((Path)object5));
                }
            }
        }
        object5 = (object6 = this.options.get(Option.SOURCE)) != null ? Source.lookup((String)object6) : Source.DEFAULT;
        String string = this.options.get(Option.TARGET);
        Object object7 = object4 = string != null ? Target.lookup(string) : Target.DEFAULT;
        if (Character.isDigit(((Target)((Object)object4)).name.charAt(0)) && ((Enum)object4).compareTo(((Source)((Object)object5)).requiredTarget()) < 0) {
            if (string != null) {
                if (object6 == null) {
                    this.error("warn.target.default.source.conflict", string, ((Source)((Object)object5)).requiredTarget().name);
                } else {
                    this.error("warn.source.target.conflict", object6, ((Source)((Object)object5)).requiredTarget().name);
                }
                return false;
            }
            object4 = ((Source)((Object)object5)).requiredTarget();
            this.options.put("-target", ((Target)((Object)object4)).name);
        }
        if ((object3 = this.options.get(Option.PROFILE)) != null) {
            Object object8 = Profile.lookup((String)object3);
            if (!((Profile)((Object)object8)).isValid((Target)((Object)object4))) {
                this.error("warn.profile.target.conflict", object3, ((Target)((Object)object4)).name);
            }
            if (this.options.get(Option.BOOT_CLASS_PATH) != null) {
                this.error("err.profile.bootclasspath.conflict", new Object[0]);
            }
        }
        if (this.options.isSet(Option.SOURCE_PATH) && this.options.isSet(Option.MODULE_SOURCE_PATH)) {
            this.error("err.sourcepath.modulesourcepath.conflict", new Object[0]);
        }
        if ((bl = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.OPTIONS.option)) && ((Enum)object5).compareTo(Source.DEFAULT) < 0 && !this.options.isSet(Option.RELEASE) && javaFileManager instanceof BaseFileManager && ((BaseFileManager)javaFileManager).isDefaultBootClassPath()) {
            this.log.warning(Lint.LintCategory.OPTIONS, "source.no.bootclasspath", ((Source)((Object)object5)).name);
        }
        boolean bl3 = false;
        if (((Enum)object5).compareTo(Source.MIN) < 0) {
            this.log.error(CompilerProperties.Errors.OptionRemovedSource(((Source)((Object)object5)).name, Source.MIN.name));
        } else if (object5 == Source.MIN && bl) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteSource(((Source)((Object)object5)).name));
            bl3 = true;
        }
        if (((Enum)object4).compareTo(Target.MIN) < 0) {
            this.log.error(CompilerProperties.Errors.OptionRemovedTarget(((Target)((Object)object4)).name, Target.MIN.name));
        } else if (object4 == Target.MIN && bl) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteTarget(((Target)((Object)object4)).name));
            bl3 = true;
        }
        object2 = object4;
        this.checkOptionAllowed(((Enum)object2).compareTo(Target.JDK1_8) <= 0, arg_0 -> this.lambda$validate$2((Target)((Object)object2), arg_0), Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS, Option.PROFILE);
        this.checkOptionAllowed(((Enum)object2).compareTo(Target.JDK1_9) >= 0, arg_0 -> this.lambda$validate$3((Target)((Object)object2), arg_0), Option.MODULE_SOURCE_PATH, Option.UPGRADE_MODULE_PATH, Option.SYSTEM, Option.MODULE_PATH, Option.ADD_MODULES, Option.ADD_EXPORTS, Option.ADD_OPENS, Option.ADD_READS, Option.LIMIT_MODULES, Option.PATCH_MODULE);
        if (javaFileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH) && !this.options.isSet(Option.PROC, "only") && !javaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
            this.log.error(CompilerProperties.Errors.NoOutputDir);
        }
        if (javaFileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH) && javaFileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH)) {
            this.log.error(CompilerProperties.Errors.ProcessorpathNoProcessormodulepath);
        }
        if (bl3 && bl) {
            this.log.warning(Lint.LintCategory.OPTIONS, "option.obsolete.suppression", new Object[0]);
        }
        object = Source.toSourceVersion((Source)((Object)object5));
        this.validateAddExports((SourceVersion)((Object)object));
        this.validateAddModules((SourceVersion)((Object)object));
        this.validateAddReads((SourceVersion)((Object)object));
        this.validateLimitModules((SourceVersion)((Object)object));
        this.validateDefaultModuleForCreatedFiles((SourceVersion)((Object)object));
        if (bl && this.options.isSet(Option.ADD_OPENS)) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.AddopensIgnored);
        }
        return !this.errors && this.log.nerrors == 0;
    }

    private void validateAddExports(SourceVersion sourceVersion) {
        String string = this.options.get(Option.ADD_EXPORTS);
        if (string != null) {
            Pattern pattern = Option.ADD_EXPORTS.getPattern();
            for (String string2 : string.split("\u0000")) {
                String string3;
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                String string4 = matcher.group(1);
                if (!SourceVersion.isName((CharSequence)string4, (SourceVersion)sourceVersion)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, string4));
                }
                if (!SourceVersion.isName((CharSequence)(string3 = matcher.group(2)), (SourceVersion)sourceVersion)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, string3));
                }
                String string5 = matcher.group(3);
                String[] stringArray = string5.split(",");
                int n = stringArray.length;
                block8: for (int i = 0; i < n; ++i) {
                    String string6;
                    switch (string6 = stringArray[i]) {
                        case "": 
                        case "ALL-UNNAMED": {
                            continue block8;
                        }
                        default: {
                            if (SourceVersion.isName((CharSequence)string6, (SourceVersion)sourceVersion)) continue block8;
                            this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, string6));
                        }
                    }
                }
            }
        }
    }

    private void validateAddReads(SourceVersion sourceVersion) {
        String string = this.options.get(Option.ADD_READS);
        if (string != null) {
            Pattern pattern = Option.ADD_READS.getPattern();
            for (String string2 : string.split("\u0000")) {
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                String string3 = matcher.group(1);
                if (!SourceVersion.isName((CharSequence)string3, (SourceVersion)sourceVersion)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_READS, string3));
                }
                String string4 = matcher.group(2);
                String[] stringArray = string4.split(",", -1);
                int n = stringArray.length;
                block8: for (int i = 0; i < n; ++i) {
                    String string5;
                    switch (string5 = stringArray[i]) {
                        case "": 
                        case "ALL-UNNAMED": {
                            continue block8;
                        }
                        default: {
                            if (SourceVersion.isName((CharSequence)string5, (SourceVersion)sourceVersion)) continue block8;
                            this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_READS, string5));
                        }
                    }
                }
            }
        }
    }

    private void validateAddModules(SourceVersion sourceVersion) {
        String string = this.options.get(Option.ADD_MODULES);
        if (string != null) {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String string2;
                switch (string2 = stringArray[i]) {
                    case "": 
                    case "ALL-SYSTEM": 
                    case "ALL-MODULE-PATH": {
                        continue block8;
                    }
                    default: {
                        if (SourceVersion.isName((CharSequence)string2, (SourceVersion)sourceVersion)) continue block8;
                        this.log.error(CompilerProperties.Errors.BadNameForOption(Option.ADD_MODULES, string2));
                    }
                }
            }
        }
    }

    private void validateLimitModules(SourceVersion sourceVersion) {
        String string = this.options.get(Option.LIMIT_MODULES);
        if (string != null) {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            block6: for (int i = 0; i < n; ++i) {
                String string2;
                switch (string2 = stringArray[i]) {
                    case "": {
                        continue block6;
                    }
                    default: {
                        if (SourceVersion.isName((CharSequence)string2, (SourceVersion)sourceVersion)) continue block6;
                        this.log.error(CompilerProperties.Errors.BadNameForOption(Option.LIMIT_MODULES, string2));
                    }
                }
            }
        }
    }

    private void validateDefaultModuleForCreatedFiles(SourceVersion sourceVersion) {
        String string = this.options.get(Option.DEFAULT_MODULE_FOR_CREATED_FILES);
        if (string != null && !SourceVersion.isName((CharSequence)string, (SourceVersion)sourceVersion)) {
            this.log.error(CompilerProperties.Errors.BadNameForOption(Option.DEFAULT_MODULE_FOR_CREATED_FILES, string));
        }
    }

    public boolean isEmpty() {
        return !(this.files != null && !this.files.isEmpty() || this.fileObjects != null && !this.fileObjects.isEmpty() || this.classNames != null && !this.classNames.isEmpty());
    }

    public void allowEmpty() {
        this.emptyAllowed = true;
    }

    public Map<Option, String> getDeferredFileManagerOptions() {
        return this.deferredFileManagerOptions;
    }

    public Set<List<String>> getPluginOpts() {
        String string = this.options.get(Option.PLUGIN);
        if (string == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<List<String>> linkedHashSet = new LinkedHashSet<List<String>>();
        for (String string2 : string.split("\\x00")) {
            linkedHashSet.add(List.from(string2.split("\\s+")));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public List<String> getDocLintOpts() {
        String string;
        String string2 = this.options.get(Option.XDOCLINT);
        String string3 = this.options.get(Option.XDOCLINT_CUSTOM);
        if (string2 == null && string3 == null) {
            return List.nil();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (string2 != null) {
            linkedHashSet.add("-Xmsgs");
        }
        if (string3 != null) {
            for (String string4 : string3.split("\\s+")) {
                if (string4.isEmpty()) continue;
                linkedHashSet.add("-Xmsgs:" + string4);
            }
        }
        if (linkedHashSet.equals(Collections.singleton("-Xmsgs:none"))) {
            return List.nil();
        }
        String string5 = this.options.get(Option.XDOCLINT_PACKAGE);
        if (string5 != null) {
            for (String string6 : string5.split("\\s+")) {
                linkedHashSet.add("-XcheckPackage:" + string6);
            }
        }
        if ((string = this.options.get(Option.DOCLINT_FORMAT)) != null) {
            linkedHashSet.add("-XhtmlVersion:" + string);
        }
        linkedHashSet.add("-XimplicitHeaders:2");
        return List.from(linkedHashSet.toArray(new String[linkedHashSet.size()]));
    }

    private boolean checkDirectory(Option option) {
        String string = this.options.get(option);
        if (string == null) {
            return true;
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            this.error("err.file.not.directory", string);
            return false;
        }
        return true;
    }

    void checkOptionAllowed(boolean bl, ErrorReporter errorReporter, Option ... optionArray) {
        if (!bl) {
            Stream.of(optionArray).filter(this.options::isSet).forEach(errorReporter::report);
        }
    }

    void error(JCDiagnostic.Error error) {
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                String string = this.log.localize(error);
                throw new PropagatedException(new IllegalArgumentException(string));
            }
            case ILLEGAL_STATE: {
                String string = this.log.localize(error);
                throw new PropagatedException(new IllegalStateException(string));
            }
            case LOG: {
                this.report(error);
            }
        }
    }

    void error(String string, Object ... objectArray) {
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                String string2 = this.log.localize(Log.PrefixKind.JAVAC, string, objectArray);
                throw new PropagatedException(new IllegalArgumentException(string2));
            }
            case ILLEGAL_STATE: {
                String string3 = this.log.localize(Log.PrefixKind.JAVAC, string, objectArray);
                throw new PropagatedException(new IllegalStateException(string3));
            }
            case LOG: {
                this.report(string, objectArray);
            }
        }
    }

    void error(Option.InvalidValueException invalidValueException) {
        String string = invalidValueException.getMessage();
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                throw new PropagatedException(new IllegalArgumentException(string, invalidValueException.getCause()));
            }
            case ILLEGAL_STATE: {
                throw new PropagatedException(new IllegalStateException(string, invalidValueException.getCause()));
            }
            case LOG: {
                this.log.printRawLines(this.ownName + ": " + string);
            }
        }
    }

    void warning(String string, Object ... objectArray) {
        this.report(string, objectArray);
    }

    private void report(String string, Object ... objectArray) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, string, objectArray));
    }

    private void report(JCDiagnostic.Error error) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(error));
    }

    private JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = this.context.get(JavaFileManager.class);
        }
        return this.fileManager;
    }

    <T> ListBuffer<T> toList(Iterable<? extends T> iterable) {
        ListBuffer<T> listBuffer = new ListBuffer<T>();
        if (iterable != null) {
            for (T t : iterable) {
                listBuffer.add(t);
            }
        }
        return listBuffer;
    }

    <T> Set<T> toSet(Iterable<? extends T> iterable) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        if (iterable != null) {
            for (T t : iterable) {
                linkedHashSet.add(t);
            }
        }
        return linkedHashSet;
    }

    private /* synthetic */ void lambda$validate$3(Target target, Option option) {
        this.error("err.option.not.allowed.with.target", option.getPrimaryName(), target.name);
    }

    private /* synthetic */ void lambda$validate$2(Target target, Option option) {
        this.error("err.option.not.allowed.with.target", option.getPrimaryName(), target.name);
    }

    private static interface ErrorReporter {
        public void report(Option var1);
    }

    private static enum ErrorMode {
        ILLEGAL_ARGUMENT,
        ILLEGAL_STATE,
        LOG;

    }
}

