/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.AnnotationDefault_attribute;
import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.BootstrapMethods_attribute;
import com.sun.tools.classfile.CharacterRangeTable_attribute;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.CompilationID_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.ConstantValue_attribute;
import com.sun.tools.classfile.DefaultAttribute;
import com.sun.tools.classfile.Deprecated_attribute;
import com.sun.tools.classfile.EnclosingMethod_attribute;
import com.sun.tools.classfile.Exceptions_attribute;
import com.sun.tools.classfile.InnerClasses_attribute;
import com.sun.tools.classfile.LineNumberTable_attribute;
import com.sun.tools.classfile.LocalVariableTable_attribute;
import com.sun.tools.classfile.LocalVariableTypeTable_attribute;
import com.sun.tools.classfile.RuntimeInvisibleAnnotations_attribute;
import com.sun.tools.classfile.RuntimeInvisibleParameterAnnotations_attribute;
import com.sun.tools.classfile.RuntimeVisibleAnnotations_attribute;
import com.sun.tools.classfile.RuntimeVisibleParameterAnnotations_attribute;
import com.sun.tools.classfile.Signature_attribute;
import com.sun.tools.classfile.SourceDebugExtension_attribute;
import com.sun.tools.classfile.SourceFile_attribute;
import com.sun.tools.classfile.SourceID_attribute;
import com.sun.tools.classfile.StackMapTable_attribute;
import com.sun.tools.classfile.StackMap_attribute;
import com.sun.tools.classfile.Synthetic_attribute;
import com.sun.tools.javap.AnnotationWriter;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.CodeWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Options;
import java.util.Formatter;

public class AttributeWriter
extends BasicWriter
implements Attribute.Visitor<Void, Void> {
    private AnnotationWriter annotationWriter;
    private CodeWriter codeWriter;
    private ConstantWriter constantWriter;
    private Options options;
    private ConstantPool constant_pool;
    private Object owner;

    public static AttributeWriter instance(Context context) {
        AttributeWriter attributeWriter = context.get(AttributeWriter.class);
        if (attributeWriter == null) {
            attributeWriter = new AttributeWriter(context);
        }
        return attributeWriter;
    }

    protected AttributeWriter(Context context) {
        super(context);
        context.put(AttributeWriter.class, this);
        this.annotationWriter = AnnotationWriter.instance(context);
        this.codeWriter = CodeWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
        this.options = Options.instance(context);
    }

    public void write(Object object, Attribute attribute, ConstantPool constantPool) {
        if (attribute != null) {
            object.getClass();
            constantPool.getClass();
            this.constant_pool = constantPool;
            this.owner = object;
            attribute.accept(this, null);
        }
    }

    public void write(Object object, Attributes attributes, ConstantPool constantPool) {
        if (attributes != null) {
            object.getClass();
            constantPool.getClass();
            this.constant_pool = constantPool;
            this.owner = object;
            for (Attribute attribute : attributes) {
                attribute.accept(this, null);
            }
        }
    }

    @Override
    public Void visitDefault(DefaultAttribute defaultAttribute, Void void_) {
        byte[] byArray = defaultAttribute.info;
        int n = 0;
        int n2 = 0;
        this.print("  ");
        try {
            this.print(defaultAttribute.getName(this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            this.report(constantPoolException);
            this.print("attribute name = #" + defaultAttribute.attribute_name_index);
        }
        this.print(": ");
        this.println("length = 0x" + AttributeWriter.toHex(defaultAttribute.info.length));
        this.print("   ");
        while (n < byArray.length) {
            this.print(this.toHex(byArray[n], 2));
            if (++n2 == 16) {
                this.println();
                this.print("   ");
                n2 = 0;
            } else {
                this.print(" ");
            }
            ++n;
        }
        this.println();
        return null;
    }

    @Override
    public Void visitAnnotationDefault(AnnotationDefault_attribute annotationDefault_attribute, Void void_) {
        this.println("AnnotationDefault:");
        this.indent(1);
        this.print("default_value: ");
        this.annotationWriter.write(annotationDefault_attribute.default_value);
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitBootstrapMethods(BootstrapMethods_attribute bootstrapMethods_attribute, Void void_) {
        this.println("BootstrapMethods:");
        for (int i = 0; i < bootstrapMethods_attribute.bootstrap_method_specifiers.length; ++i) {
            BootstrapMethods_attribute.BootstrapMethodSpecifier bootstrapMethodSpecifier = bootstrapMethods_attribute.bootstrap_method_specifiers[i];
            this.indent(1);
            this.print(i + ": #" + bootstrapMethodSpecifier.bootstrap_method_ref + " ");
            this.println(this.constantWriter.stringValue(bootstrapMethodSpecifier.bootstrap_method_ref));
            this.indent(1);
            this.println("Method arguments:");
            this.indent(1);
            for (int j = 0; j < bootstrapMethodSpecifier.bootstrap_arguments.length; ++j) {
                this.print("#" + bootstrapMethodSpecifier.bootstrap_arguments[j] + " ");
                this.println(this.constantWriter.stringValue(bootstrapMethodSpecifier.bootstrap_arguments[j]));
            }
            this.indent(-3);
        }
        return null;
    }

    @Override
    public Void visitCharacterRangeTable(CharacterRangeTable_attribute characterRangeTable_attribute, Void void_) {
        this.println("CharacterRangeTable:");
        this.indent(1);
        for (int i = 0; i < characterRangeTable_attribute.character_range_table.length; ++i) {
            CharacterRangeTable_attribute.Entry entry = characterRangeTable_attribute.character_range_table[i];
            this.print(String.format("    %2d, %2d, %6x, %6x, %4x", entry.start_pc, entry.end_pc, entry.character_range_start, entry.character_range_end, entry.flags));
            this.tab();
            this.print(String.format("// %2d, %2d, %4d:%02d, %4d:%02d", entry.start_pc, entry.end_pc, entry.character_range_start >> 10, entry.character_range_start & 0x3FF, entry.character_range_end >> 10, entry.character_range_end & 0x3FF));
            if ((entry.flags & 1) != 0) {
                this.print(", statement");
            }
            if ((entry.flags & 2) != 0) {
                this.print(", block");
            }
            if ((entry.flags & 4) != 0) {
                this.print(", assignment");
            }
            if ((entry.flags & 8) != 0) {
                this.print(", flow-controller");
            }
            if ((entry.flags & 0x10) != 0) {
                this.print(", flow-target");
            }
            if ((entry.flags & 0x20) != 0) {
                this.print(", invoke");
            }
            if ((entry.flags & 0x40) != 0) {
                this.print(", create");
            }
            if ((entry.flags & 0x80) != 0) {
                this.print(", branch-true");
            }
            if ((entry.flags & 0x100) != 0) {
                this.print(", branch-false");
            }
            this.println();
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitCode(Code_attribute code_attribute, Void void_) {
        this.codeWriter.write(code_attribute, this.constant_pool);
        return null;
    }

    @Override
    public Void visitCompilationID(CompilationID_attribute compilationID_attribute, Void void_) {
        this.constantWriter.write(compilationID_attribute.compilationID_index);
        return null;
    }

    @Override
    public Void visitConstantValue(ConstantValue_attribute constantValue_attribute, Void void_) {
        if (this.options.compat) {
            this.print("Constant value: ");
        } else {
            this.print("ConstantValue: ");
        }
        this.constantWriter.write(constantValue_attribute.constantvalue_index);
        this.println();
        return null;
    }

    @Override
    public Void visitDeprecated(Deprecated_attribute deprecated_attribute, Void void_) {
        this.println("Deprecated: true");
        return null;
    }

    @Override
    public Void visitEnclosingMethod(EnclosingMethod_attribute enclosingMethod_attribute, Void void_) {
        this.print("EnclosingMethod: #" + enclosingMethod_attribute.class_index + ".#" + enclosingMethod_attribute.method_index);
        this.tab();
        this.print("// " + this.getJavaClassName(enclosingMethod_attribute));
        if (enclosingMethod_attribute.method_index != 0) {
            this.print("." + this.getMethodName(enclosingMethod_attribute));
        }
        this.println();
        return null;
    }

    private String getJavaClassName(EnclosingMethod_attribute enclosingMethod_attribute) {
        try {
            return AttributeWriter.getJavaName(enclosingMethod_attribute.getClassName(this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    private String getMethodName(EnclosingMethod_attribute enclosingMethod_attribute) {
        try {
            return enclosingMethod_attribute.getMethodName(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    @Override
    public Void visitExceptions(Exceptions_attribute exceptions_attribute, Void void_) {
        this.println("Exceptions:");
        this.indent(1);
        this.print("throws ");
        for (int i = 0; i < exceptions_attribute.number_of_exceptions; ++i) {
            if (i > 0) {
                this.print(", ");
            }
            this.print(this.getJavaException(exceptions_attribute, i));
        }
        this.println();
        this.indent(-1);
        return null;
    }

    private String getJavaException(Exceptions_attribute exceptions_attribute, int n) {
        try {
            return AttributeWriter.getJavaName(exceptions_attribute.getException(n, this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    @Override
    public Void visitInnerClasses(InnerClasses_attribute innerClasses_attribute, Void void_) {
        boolean bl = true;
        if (this.options.compat) {
            this.writeInnerClassHeader();
            bl = false;
        }
        for (int i = 0; i < innerClasses_attribute.classes.length; ++i) {
            InnerClasses_attribute.Info info = innerClasses_attribute.classes[i];
            AccessFlags accessFlags = info.inner_class_access_flags;
            if (this.options.compat) {
                accessFlags = accessFlags.ignore(21006);
                this.print("   ");
            }
            if (!this.options.checkAccess(accessFlags)) continue;
            if (bl) {
                this.writeInnerClassHeader();
                bl = false;
            }
            this.print("   ");
            for (String string : accessFlags.getInnerClassModifiers()) {
                this.print(string + " ");
            }
            if (info.inner_name_index != 0) {
                this.print("#" + info.inner_name_index + "= ");
            }
            this.print("#" + info.inner_class_info_index);
            if (info.outer_class_info_index != 0) {
                this.print(" of #" + info.outer_class_info_index);
            }
            this.print("; //");
            if (info.inner_name_index != 0) {
                this.print(this.getInnerName(this.constant_pool, info) + "=");
            }
            this.constantWriter.write(info.inner_class_info_index);
            if (info.outer_class_info_index != 0) {
                this.print(" of ");
                this.constantWriter.write(info.outer_class_info_index);
            }
            this.println();
        }
        if (!bl) {
            this.indent(-1);
        }
        return null;
    }

    String getInnerName(ConstantPool constantPool, InnerClasses_attribute.Info info) {
        try {
            return info.getInnerName(constantPool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    private void writeInnerClassHeader() {
        if (this.options.compat) {
            this.print("InnerClass");
        } else {
            this.print("InnerClasses");
        }
        this.println(":");
        this.indent(1);
    }

    @Override
    public Void visitLineNumberTable(LineNumberTable_attribute lineNumberTable_attribute, Void void_) {
        this.println("LineNumberTable:");
        this.indent(1);
        for (LineNumberTable_attribute.Entry entry : lineNumberTable_attribute.line_number_table) {
            this.println("line " + entry.line_number + ": " + entry.start_pc);
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitLocalVariableTable(LocalVariableTable_attribute localVariableTable_attribute, Void void_) {
        this.println("LocalVariableTable:");
        this.indent(1);
        this.println("Start  Length  Slot  Name   Signature");
        for (LocalVariableTable_attribute.Entry entry : localVariableTable_attribute.local_variable_table) {
            Formatter formatter = new Formatter();
            this.println(formatter.format("%8d %7d %5d %5s   %s", entry.start_pc, entry.length, entry.index, this.constantWriter.stringValue(entry.name_index), this.constantWriter.stringValue(entry.descriptor_index)));
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitLocalVariableTypeTable(LocalVariableTypeTable_attribute localVariableTypeTable_attribute, Void void_) {
        this.println("LocalVariableTypeTable:");
        this.indent(1);
        this.println("Start  Length  Slot  Name   Signature");
        for (LocalVariableTypeTable_attribute.Entry entry : localVariableTypeTable_attribute.local_variable_table) {
            this.println(String.format("%5d %7d %5d %5s   %s", entry.start_pc, entry.length, entry.index, this.constantWriter.stringValue(entry.name_index), this.constantWriter.stringValue(entry.signature_index)));
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitRuntimeVisibleAnnotations(RuntimeVisibleAnnotations_attribute runtimeVisibleAnnotations_attribute, Void void_) {
        this.println("RuntimeVisibleAnnotations:");
        this.indent(1);
        for (int i = 0; i < runtimeVisibleAnnotations_attribute.annotations.length; ++i) {
            this.print(i + ": ");
            this.annotationWriter.write(runtimeVisibleAnnotations_attribute.annotations[i]);
            this.println();
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitRuntimeInvisibleAnnotations(RuntimeInvisibleAnnotations_attribute runtimeInvisibleAnnotations_attribute, Void void_) {
        this.println("RuntimeInvisibleAnnotations:");
        this.indent(1);
        for (int i = 0; i < runtimeInvisibleAnnotations_attribute.annotations.length; ++i) {
            this.print(i + ": ");
            this.annotationWriter.write(runtimeInvisibleAnnotations_attribute.annotations[i]);
            this.println();
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitRuntimeVisibleParameterAnnotations(RuntimeVisibleParameterAnnotations_attribute runtimeVisibleParameterAnnotations_attribute, Void void_) {
        this.println("RuntimeVisibleParameterAnnotations:");
        this.indent(1);
        for (int i = 0; i < runtimeVisibleParameterAnnotations_attribute.parameter_annotations.length; ++i) {
            this.println("parameter " + i + ": ");
            this.indent(1);
            for (int j = 0; j < runtimeVisibleParameterAnnotations_attribute.parameter_annotations[i].length; ++j) {
                this.print(j + ": ");
                this.annotationWriter.write(runtimeVisibleParameterAnnotations_attribute.parameter_annotations[i][j]);
                this.println();
            }
            this.indent(-1);
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisibleParameterAnnotations_attribute runtimeInvisibleParameterAnnotations_attribute, Void void_) {
        this.println("RuntimeInvisibleParameterAnnotations:");
        this.indent(1);
        for (int i = 0; i < runtimeInvisibleParameterAnnotations_attribute.parameter_annotations.length; ++i) {
            this.println(i + ": ");
            this.indent(1);
            for (int j = 0; j < runtimeInvisibleParameterAnnotations_attribute.parameter_annotations[i].length; ++j) {
                this.print(j + ": ");
                this.annotationWriter.write(runtimeInvisibleParameterAnnotations_attribute.parameter_annotations[i][j]);
                this.println();
            }
            this.indent(-1);
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitSignature(Signature_attribute signature_attribute, Void void_) {
        this.print("Signature: #" + signature_attribute.signature_index);
        this.tab();
        this.println("// " + this.getSignature(signature_attribute));
        return null;
    }

    String getSignature(Signature_attribute signature_attribute) {
        try {
            return signature_attribute.getSignature(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    @Override
    public Void visitSourceDebugExtension(SourceDebugExtension_attribute sourceDebugExtension_attribute, Void void_) {
        this.println("SourceDebugExtension: " + sourceDebugExtension_attribute.getValue());
        return null;
    }

    @Override
    public Void visitSourceFile(SourceFile_attribute sourceFile_attribute, Void void_) {
        this.println("SourceFile: \"" + this.getSourceFile(sourceFile_attribute) + "\"");
        return null;
    }

    private String getSourceFile(SourceFile_attribute sourceFile_attribute) {
        try {
            return sourceFile_attribute.getSourceFile(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    @Override
    public Void visitSourceID(SourceID_attribute sourceID_attribute, Void void_) {
        this.constantWriter.write(sourceID_attribute.sourceID_index);
        return null;
    }

    @Override
    public Void visitStackMap(StackMap_attribute stackMap_attribute, Void void_) {
        this.println("StackMap: number_of_entries = " + stackMap_attribute.number_of_entries);
        this.indent(1);
        StackMapTableWriter stackMapTableWriter = new StackMapTableWriter();
        for (StackMap_attribute.stack_map_frame stack_map_frame2 : stackMap_attribute.entries) {
            stackMapTableWriter.write(stack_map_frame2);
        }
        this.println();
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitStackMapTable(StackMapTable_attribute stackMapTable_attribute, Void void_) {
        this.println("StackMapTable: number_of_entries = " + stackMapTable_attribute.number_of_entries);
        this.indent(1);
        StackMapTableWriter stackMapTableWriter = new StackMapTableWriter();
        for (StackMapTable_attribute.stack_map_frame stack_map_frame2 : stackMapTable_attribute.entries) {
            stackMapTableWriter.write(stack_map_frame2);
        }
        this.println();
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitSynthetic(Synthetic_attribute synthetic_attribute, Void void_) {
        this.println("Synthetic: true");
        return null;
    }

    static String getJavaName(String string) {
        return string.replace('/', '.');
    }

    String toHex(byte by, int n) {
        if (this.options.compat) {
            return AttributeWriter.toHex(by, n);
        }
        return AttributeWriter.toHex(by & 0xFF, n);
    }

    static String toHex(int n) {
        return Integer.toString(n, 16).toUpperCase();
    }

    static String toHex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string.toUpperCase();
    }

    class StackMapTableWriter
    implements StackMapTable_attribute.stack_map_frame.Visitor<Void, Void> {
        StackMapTableWriter() {
        }

        public void write(StackMapTable_attribute.stack_map_frame stack_map_frame2) {
            stack_map_frame2.accept(this, null);
        }

        @Override
        public Void visit_same_frame(StackMapTable_attribute.same_frame same_frame2, Void void_) {
            this.printHeader(same_frame2);
            AttributeWriter.this.println(" /* same */");
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame(StackMapTable_attribute.same_locals_1_stack_item_frame same_locals_1_stack_item_frame2, Void void_) {
            this.printHeader(same_locals_1_stack_item_frame2);
            AttributeWriter.this.println(" /* same_locals_1_stack_item */");
            AttributeWriter.this.indent(1);
            this.printMap("stack", same_locals_1_stack_item_frame2.stack);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame_extended(StackMapTable_attribute.same_locals_1_stack_item_frame_extended same_locals_1_stack_item_frame_extended2, Void void_) {
            this.printHeader(same_locals_1_stack_item_frame_extended2);
            AttributeWriter.this.println(" /* same_locals_1_stack_item_frame_extended */");
            AttributeWriter.this.indent(1);
            AttributeWriter.this.println("offset_delta = " + same_locals_1_stack_item_frame_extended2.offset_delta);
            this.printMap("stack", same_locals_1_stack_item_frame_extended2.stack);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_chop_frame(StackMapTable_attribute.chop_frame chop_frame2, Void void_) {
            this.printHeader(chop_frame2);
            AttributeWriter.this.println(" /* chop */");
            AttributeWriter.this.indent(1);
            AttributeWriter.this.println("offset_delta = " + chop_frame2.offset_delta);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_same_frame_extended(StackMapTable_attribute.same_frame_extended same_frame_extended2, Void void_) {
            this.printHeader(same_frame_extended2);
            AttributeWriter.this.println(" /* same_frame_extended */");
            AttributeWriter.this.indent(1);
            AttributeWriter.this.println("offset_delta = " + same_frame_extended2.offset_delta);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_append_frame(StackMapTable_attribute.append_frame append_frame2, Void void_) {
            this.printHeader(append_frame2);
            AttributeWriter.this.println(" /* append */");
            AttributeWriter.this.println("     offset_delta = " + append_frame2.offset_delta);
            this.printMap("locals", append_frame2.locals);
            return null;
        }

        @Override
        public Void visit_full_frame(StackMapTable_attribute.full_frame full_frame2, Void void_) {
            this.printHeader(full_frame2);
            if (full_frame2 instanceof StackMap_attribute.stack_map_frame) {
                AttributeWriter.this.indent(1);
                AttributeWriter.this.println(" offset = " + full_frame2.offset_delta);
            } else {
                AttributeWriter.this.println(" /* full_frame */");
                AttributeWriter.this.indent(1);
                AttributeWriter.this.println("offset_delta = " + full_frame2.offset_delta);
            }
            this.printMap("locals", full_frame2.locals);
            this.printMap("stack", full_frame2.stack);
            AttributeWriter.this.indent(-1);
            return null;
        }

        void printHeader(StackMapTable_attribute.stack_map_frame stack_map_frame2) {
            AttributeWriter.this.print("   frame_type = " + stack_map_frame2.frame_type);
        }

        void printMap(String string, StackMapTable_attribute.verification_type_info[] verification_type_infoArray) {
            AttributeWriter.this.print(string + " = [");
            for (int i = 0; i < verification_type_infoArray.length; ++i) {
                StackMapTable_attribute.verification_type_info verification_type_info2 = verification_type_infoArray[i];
                int n = verification_type_info2.tag;
                switch (n) {
                    case 7: {
                        AttributeWriter.this.print(" ");
                        AttributeWriter.this.constantWriter.write(((StackMapTable_attribute.Object_variable_info)verification_type_info2).cpool_index);
                        break;
                    }
                    case 8: {
                        AttributeWriter.this.print(" " + this.mapTypeName(n));
                        AttributeWriter.this.print(" " + ((StackMapTable_attribute.Uninitialized_variable_info)verification_type_info2).offset);
                        break;
                    }
                    default: {
                        AttributeWriter.this.print(" " + this.mapTypeName(n));
                    }
                }
                AttributeWriter.this.print(i == verification_type_infoArray.length - 1 ? " " : ",");
            }
            AttributeWriter.this.println("]");
        }

        String mapTypeName(int n) {
            switch (n) {
                case 0: {
                    return "top";
                }
                case 1: {
                    return "int";
                }
                case 2: {
                    return "float";
                }
                case 4: {
                    return "long";
                }
                case 3: {
                    return "double";
                }
                case 5: {
                    return "null";
                }
                case 6: {
                    return "this";
                }
                case 7: {
                    return "CP";
                }
                case 8: {
                    return "uninitialized";
                }
            }
            AttributeWriter.this.report("unrecognized verification_type_info tag: " + n);
            return "[tag:" + n + "]";
        }
    }
}

