/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.FloatValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class FloatValueImpl
extends PrimitiveValueImpl
implements FloatValue {
    private float value;

    FloatValueImpl(VirtualMachine virtualMachine, float f) {
        super(virtualMachine);
        this.value = f;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof FloatValue) {
            return this.value == ((FloatValue)object).value() && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(FloatValue floatValue) {
        float f = floatValue.value();
        if (this.value() < f) {
            return -1;
        }
        if (this.value() == f) {
            return 0;
        }
        return 1;
    }

    @Override
    public Type type() {
        return this.vm.theFloatType();
    }

    @Override
    public float value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return (double)this.value != 0.0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127.0f || this.value < -128.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535.0f || this.value < 0.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    short checkedShortValue() throws InvalidTypeException {
        if (this.value > 32767.0f || this.value < -32768.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    @Override
    int checkedIntValue() throws InvalidTypeException {
        int n = (int)this.value;
        if ((float)n != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to int");
        }
        return super.checkedIntValue();
    }

    @Override
    long checkedLongValue() throws InvalidTypeException {
        long l = (long)this.value;
        if ((float)l != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to long");
        }
        return super.checkedLongValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 70;
    }
}

