/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MonitorInfoImpl;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.StackFrameImpl;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.VMAction;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VMState;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements ThreadReference,
VMListener {
    static final int SUSPEND_STATUS_SUSPENDED = 1;
    static final int SUSPEND_STATUS_BREAK = 2;
    private int suspendedZombieCount = 0;
    private ThreadGroupReference threadGroup;
    private LocalCache localCache;
    private List<WeakReference<ThreadListener>> listeners = new ArrayList<WeakReference<ThreadListener>>();

    private void resetLocalCache() {
        this.localCache = new LocalCache();
    }

    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ThreadReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.resetLocalCache();
        this.vm.state().addListener(this);
    }

    @Override
    protected String description() {
        return "ThreadReference " + this.uniqueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean vmNotSuspended(VMAction vMAction) {
        if (vMAction.resumingThread() == null) {
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                this.processThreadAction(new ThreadAction(this, 2));
            }
        }
        return super.vmNotSuspended(vMAction);
    }

    @Override
    public String name() {
        String string = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                string = cache.name;
            }
            if (string == null) {
                string = JDWP.ThreadReference.Name.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).threadName;
                if (cache != null) {
                    cache.name = string;
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketStream sendResumingCommand(CommandSender commandSender) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            return commandSender.send();
        }
    }

    @Override
    public void suspend() {
        try {
            JDWP.ThreadReference.Suspend.process(this.vm, this);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        PacketStream packetStream;
        if (this.suspendedZombieCount > 0) {
            --this.suspendedZombieCount;
            return;
        }
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            packetStream = JDWP.ThreadReference.Resume.enqueueCommand(this.vm, this);
        }
        try {
            JDWP.ThreadReference.Resume.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    @Override
    public int suspendCount() {
        if (this.suspendedZombieCount > 0) {
            return this.suspendedZombieCount;
        }
        try {
            return JDWP.ThreadReference.SuspendCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).suspendCount;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    @Override
    public void stop(ObjectReference objectReference) throws InvalidTypeException {
        this.validateMirror(objectReference);
        List<ReferenceType> list = this.vm.classesByName("java.lang.Throwable");
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)list.get(0);
        if (objectReference == null || !classTypeImpl.isAssignableFrom(objectReference)) {
            throw new InvalidTypeException("Not an instance of Throwable");
        }
        try {
            JDWP.ThreadReference.Stop.process(this.vm, this, (ObjectReferenceImpl)objectReference);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    @Override
    public void interrupt() {
        try {
            JDWP.ThreadReference.Interrupt.process(this.vm, this);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    private JDWP.ThreadReference.Status jdwpStatus() {
        LocalCache localCache = this.localCache;
        JDWP.ThreadReference.Status status = localCache.status;
        try {
            if (status == null) {
                status = JDWP.ThreadReference.Status.process(this.vm, this);
                if ((status.suspendStatus & 1) != 0) {
                    localCache.status = status;
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return status;
    }

    @Override
    public int status() {
        return this.jdwpStatus().threadStatus;
    }

    @Override
    public boolean isSuspended() {
        return this.suspendedZombieCount > 0 || (this.jdwpStatus().suspendStatus & 1) != 0;
    }

    @Override
    public boolean isAtBreakpoint() {
        try {
            StackFrame stackFrame = this.frame(0);
            Location location = stackFrame.location();
            List<BreakpointRequest> list = this.vm.eventRequestManager().breakpointRequests();
            for (BreakpointRequest breakpointRequest : list) {
                if (!location.equals(breakpointRequest.location())) continue;
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
    }

    @Override
    public ThreadGroupReference threadGroup() {
        if (this.threadGroup == null) {
            try {
                this.threadGroup = JDWP.ThreadReference.ThreadGroup.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).group;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.threadGroup;
    }

    @Override
    public int frameCount() throws IncompatibleThreadStateException {
        LocalCache localCache = this.localCache;
        try {
            if (localCache.frameCount == -1) {
                localCache.frameCount = JDWP.ThreadReference.FrameCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).frameCount;
            }
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
        return localCache.frameCount;
    }

    @Override
    public List<StackFrame> frames() throws IncompatibleThreadStateException {
        return this.privateFrames(0, -1);
    }

    @Override
    public StackFrame frame(int n) throws IncompatibleThreadStateException {
        List<StackFrame> list = this.privateFrames(n, 1);
        return list.get(0);
    }

    private boolean isSubrange(LocalCache localCache, int n, int n2) {
        if (n < localCache.framesStart) {
            return false;
        }
        if (n2 == -1) {
            return localCache.framesLength == -1;
        }
        if (localCache.framesLength == -1) {
            if (n + n2 > localCache.framesStart + localCache.frames.size()) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }
        return n + n2 <= localCache.framesStart + localCache.framesLength;
    }

    @Override
    public List<StackFrame> frames(int n, int n2) throws IncompatibleThreadStateException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to zero");
        }
        return this.privateFrames(n, n2);
    }

    private synchronized List<StackFrame> privateFrames(int n, int n2) throws IncompatibleThreadStateException {
        LocalCache localCache = this.localCache;
        try {
            if (localCache.frames == null || !this.isSubrange(localCache, n, n2)) {
                JDWP.ThreadReference.Frames.Frame[] frameArray = JDWP.ThreadReference.Frames.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this, (int)n, (int)n2).frames;
                int n3 = frameArray.length;
                localCache.frames = new ArrayList<StackFrame>(n3);
                for (int i = 0; i < n3; ++i) {
                    if (frameArray[i].location == null) {
                        throw new InternalException("Invalid frame location");
                    }
                    StackFrameImpl stackFrameImpl = new StackFrameImpl(this.vm, this, frameArray[i].frameID, frameArray[i].location);
                    localCache.frames.add(stackFrameImpl);
                }
                localCache.framesStart = n;
                localCache.framesLength = n2;
                return Collections.unmodifiableList(localCache.frames);
            }
            int n4 = n - localCache.framesStart;
            int n5 = n2 == -1 ? localCache.frames.size() - n4 : n4 + n2;
            return Collections.unmodifiableList(localCache.frames.subList(n4, n5));
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
    }

    @Override
    public List<ObjectReference> ownedMonitors() throws IncompatibleThreadStateException {
        LocalCache localCache = this.localCache;
        try {
            if (localCache.ownedMonitors == null) {
                localCache.ownedMonitors = Arrays.asList((ObjectReference[])JDWP.ThreadReference.OwnedMonitors.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned);
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching owned monitors" + " (count = " + localCache.ownedMonitors.size() + ")");
                }
            }
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
        return localCache.ownedMonitors;
    }

    @Override
    public ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        LocalCache localCache = this.localCache;
        try {
            if (localCache.contendedMonitor == null && !localCache.triedCurrentContended) {
                localCache.contendedMonitor = JDWP.ThreadReference.CurrentContendedMonitor.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).monitor;
                localCache.triedCurrentContended = true;
                if (localCache.contendedMonitor != null) {
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching contended monitor" + " (id = " + localCache.contendedMonitor.uniqueID() + ")");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
        return localCache.contendedMonitor;
    }

    @Override
    public List<MonitorInfo> ownedMonitorsAndFrames() throws IncompatibleThreadStateException {
        LocalCache localCache = this.localCache;
        try {
            if (localCache.ownedMonitorsInfo == null) {
                JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.monitor[] monitorArray = JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned;
                localCache.ownedMonitorsInfo = new ArrayList<MonitorInfo>(monitorArray.length);
                for (int i = 0; i < monitorArray.length; ++i) {
                    JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.monitor monitor2 = monitorArray[i];
                    MonitorInfoImpl monitorInfoImpl = new MonitorInfoImpl(this.vm, monitorArray[i].monitor, this, monitorArray[i].stack_depth);
                    localCache.ownedMonitorsInfo.add(monitorInfoImpl);
                }
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching owned monitors" + " (count = " + localCache.ownedMonitorsInfo.size() + ")");
                }
            }
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
        return localCache.ownedMonitorsInfo;
    }

    @Override
    public void popFrames(StackFrame stackFrame) throws IncompatibleThreadStateException {
        if (!stackFrame.thread().equals(this)) {
            throw new IllegalArgumentException("frame does not belong to this thread");
        }
        if (!this.vm.canPopFrames()) {
            throw new UnsupportedOperationException("target does not support popping frames");
        }
        ((StackFrameImpl)stackFrame).pop();
    }

    @Override
    public void forceEarlyReturn(Value value) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        StackFrameImpl stackFrameImpl;
        if (!this.vm.canForceEarlyReturn()) {
            throw new UnsupportedOperationException("target does not support the forcing of a method to return early");
        }
        this.validateMirrorOrNull(value);
        try {
            stackFrameImpl = (StackFrameImpl)this.frame(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidStackFrameException("No more frames on the stack");
        }
        stackFrameImpl.validateStackFrame();
        MethodImpl methodImpl = (MethodImpl)stackFrameImpl.location().method();
        ValueImpl valueImpl = ValueImpl.prepareForAssignment(value, methodImpl.getReturnValueContainer());
        try {
            JDWP.ThreadReference.ForceEarlyReturn.process(this.vm, this, valueImpl);
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 32: {
                    throw new NativeMethodException();
                }
                case 13: {
                    throw new IncompatibleThreadStateException("Thread not suspended");
                }
                case 15: {
                    throw new IncompatibleThreadStateException("Thread has not started or has finished");
                }
                case 31: {
                    throw new InvalidStackFrameException("No more frames on the stack");
                }
            }
            throw jDWPException.toJDIException();
        }
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 116;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(ThreadListener threadListener) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.listeners.add(new WeakReference<ThreadListener>(threadListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(ThreadListener threadListener) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            Iterator<WeakReference<ThreadListener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ThreadListener> weakReference = iterator.next();
                if (!threadListener.equals(weakReference.get())) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadAction(ThreadAction threadAction) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            Iterator<WeakReference<ThreadListener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ThreadListener> weakReference = iterator.next();
                ThreadListener threadListener = (ThreadListener)weakReference.get();
                if (threadListener != null) {
                    switch (threadAction.id()) {
                        case 2: {
                            if (threadListener.threadResumable(threadAction)) break;
                            iterator.remove();
                        }
                    }
                    continue;
                }
                iterator.remove();
            }
            this.resetLocalCache();
        }
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        String name = null;

        private Cache() {
        }
    }

    private static class LocalCache {
        JDWP.ThreadReference.Status status = null;
        List<StackFrame> frames = null;
        int framesStart = -1;
        int framesLength = 0;
        int frameCount = -1;
        List<ObjectReference> ownedMonitors = null;
        List<MonitorInfo> ownedMonitorsInfo = null;
        ObjectReference contendedMonitor = null;
        boolean triedCurrentContended = false;

        private LocalCache() {
        }
    }
}

