/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.sjavac.comp.FileObjectWithLocation;
import com.sun.tools.sjavac.comp.JavaFileObjectWithLocation;
import com.sun.tools.sjavac.comp.SmartFileObject;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@ClientCodeWrapper.Trusted
public class SmartFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    Set<URI> visibleSources = new HashSet<URI>();
    Map<String, Set<URI>> packageArtifacts = new HashMap<String, Set<URI>>();

    public SmartFileManager(JavaFileManager javaFileManager) {
        super(javaFileManager);
    }

    public void setVisibleSources(Set<URI> set) {
        this.visibleSources = set;
    }

    public void cleanArtifacts() {
        this.packageArtifacts = new HashMap<String, Set<URI>>();
    }

    public void setSymbolFileEnabled(boolean bl) {
        if (!(this.fileManager instanceof JavacFileManager)) {
            throw new IllegalStateException();
        }
        ((JavacFileManager)this.fileManager).setSymbolFileEnabled(bl);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        return super.inferBinaryName(location, SmartFileManager.locUnwrap(javaFileObject));
    }

    public Map<String, Set<URI>> getPackageArtifacts() {
        return this.packageArtifacts;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        Iterable<JavaFileObject> iterable = super.list(location, string, set, bl);
        if (this.visibleSources.isEmpty()) {
            return SmartFileManager.locWrapMany(iterable, location);
        }
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : iterable) {
            URI uRI = javaFileObject.toUri();
            String string2 = uRI.toString();
            if (!string2.startsWith("jar:") && !string2.endsWith(".class") && !this.visibleSources.contains(uRI)) continue;
            listBuffer.add(javaFileObject);
        }
        return SmartFileManager.locWrapMany(listBuffer, location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject javaFileObject = super.getJavaFileForInput(location, string, kind);
        if ((javaFileObject = SmartFileManager.locWrap(javaFileObject, location)) == null || this.visibleSources.isEmpty()) {
            return javaFileObject;
        }
        if (this.visibleSources.contains(javaFileObject.toUri()) || this.isModuleInfo(javaFileObject)) {
            return javaFileObject;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        JavaFileObject javaFileObject = super.getJavaFileForOutput(location, string, kind, fileObject);
        if ((javaFileObject = SmartFileManager.locWrap(javaFileObject, location)) == null) {
            return javaFileObject;
        }
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        String string3 = "";
        this.addArtifact(string3 + ":" + string2, javaFileObject.toUri());
        return javaFileObject;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        FileObject fileObject = super.getFileForInput(location, string, string2);
        if ((fileObject = SmartFileManager.locWrap(fileObject, location)) == null || this.visibleSources.isEmpty()) {
            return fileObject;
        }
        if (this.visibleSources.contains(fileObject.toUri()) || this.isModuleInfo(fileObject)) {
            return fileObject;
        }
        return null;
    }

    private boolean isModuleInfo(FileObject fileObject) {
        if (fileObject instanceof JavaFileObject) {
            JavaFileObject javaFileObject = (JavaFileObject)fileObject;
            return javaFileObject.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE) || javaFileObject.isNameCompatible("module-info", JavaFileObject.Kind.CLASS);
        }
        return false;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        FileObject fileObject2 = super.getFileForOutput(location, string, string2, fileObject);
        FileObject fileObject3 = SmartFileManager.locWrap(fileObject2, location);
        if (fileObject3 == null) {
            return fileObject3;
        }
        if (location.equals(StandardLocation.NATIVE_HEADER_OUTPUT) && fileObject2 instanceof JavaFileObject) {
            fileObject3 = new SmartFileObject((JavaFileObject)fileObject3);
            string = ":" + SmartFileManager.packageNameFromFileName(string2);
        }
        if (string.equals("")) {
            string = ":";
        }
        this.addArtifact(string, fileObject3.toUri());
        return fileObject3;
    }

    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) throws IOException {
        return super.getLocationForModule(location, SmartFileManager.locUnwrap(javaFileObject));
    }

    private static String packageNameFromFileName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(95);
        int n2 = 0;
        while (n != -1) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(string.substring(n2, n));
            if (n == string.length() - 1) break;
            n2 = n + 1;
            n = string.indexOf(95, n2);
        }
        return stringBuilder.toString();
    }

    void addArtifact(String string, URI uRI) {
        Set<URI> set = this.packageArtifacts.get(string);
        if (set == null) {
            set = new HashSet<URI>();
            this.packageArtifacts.put(string, set);
        }
        set.add(uRI);
    }

    public static JavaFileObject locWrap(JavaFileObject javaFileObject, JavaFileManager.Location location) {
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return javaFileObject;
        }
        return javaFileObject == null ? null : new JavaFileObjectWithLocation<JavaFileObject>(javaFileObject, location);
    }

    private static FileObject locWrap(FileObject fileObject, JavaFileManager.Location location) {
        if (fileObject instanceof JavaFileObject) {
            return SmartFileManager.locWrap((JavaFileObject)fileObject, location);
        }
        return fileObject == null ? null : new FileObjectWithLocation<FileObject>(fileObject, location);
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        return super.isSameFile(SmartFileManager.locUnwrap(fileObject), SmartFileManager.locUnwrap(fileObject2));
    }

    private static ListBuffer<JavaFileObject> locWrapMany(Iterable<JavaFileObject> iterable, JavaFileManager.Location location) {
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : iterable) {
            listBuffer.add(SmartFileManager.locWrap(javaFileObject, location));
        }
        return listBuffer;
    }

    private static FileObject locUnwrap(FileObject fileObject) {
        if (fileObject instanceof FileObjectWithLocation) {
            return ((FileObjectWithLocation)fileObject).getDelegate();
        }
        if (fileObject instanceof JavaFileObjectWithLocation) {
            return ((JavaFileObjectWithLocation)fileObject).getDelegate();
        }
        return fileObject;
    }

    private static JavaFileObject locUnwrap(JavaFileObject javaFileObject) {
        if (javaFileObject instanceof JavaFileObjectWithLocation) {
            return ((JavaFileObjectWithLocation)javaFileObject).getDelegate();
        }
        return javaFileObject;
    }
}

