/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.checkerframework.com.github.javaparser.utils.CodeGenerationUtils;

public class Log {
    private static Adapter CURRENT_ADAPTER = new SilentAdapter();

    public static void setAdapter(Adapter adapter) {
        CURRENT_ADAPTER = adapter;
    }

    public static void trace(String format, Object ... args) {
        CURRENT_ADAPTER.trace(CodeGenerationUtils.f(format, args));
    }

    public static void info(String format, Object ... args) {
        CURRENT_ADAPTER.info(CodeGenerationUtils.f(format, args));
    }

    public static void error(Throwable throwable) {
        CURRENT_ADAPTER.error(throwable, null);
    }

    public static void error(Throwable throwable, String format, Object ... args) {
        CURRENT_ADAPTER.error(throwable, CodeGenerationUtils.f(format, args));
    }

    public static void error(String format, Object ... args) {
        CURRENT_ADAPTER.error(null, CodeGenerationUtils.f(format, args));
    }

    public static interface Adapter {
        public void info(String var1);

        public void trace(String var1);

        public void error(Throwable var1, String var2);
    }

    public static class SilentAdapter
    implements Adapter {
        @Override
        public void info(String message) {
        }

        @Override
        public void trace(String message) {
        }

        @Override
        public void error(Throwable throwable, String f) {
        }
    }

    public static class StandardOutStandardErrorAdapter
    implements Adapter {
        @Override
        public void info(String message) {
            System.out.println(message);
        }

        @Override
        public void trace(String message) {
            System.out.println(message);
        }

        @Override
        public void error(Throwable throwable, String message) {
            if (message == null) {
                System.err.println(throwable.getMessage());
                this.printStackTrace(throwable);
            } else if (throwable == null) {
                System.err.println(message);
            } else {
                System.err.println(message + ":" + throwable.getMessage());
                this.printStackTrace(throwable);
            }
        }

        private void printStackTrace(Throwable throwable) {
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                throwable.printStackTrace(pw);
                this.trace(sw.toString());
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Error in logging library");
            }
        }
    }
}

