/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import com.sun.source.tree.AssertTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.framework.flow.CFTreeBuilder;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;

public class CFCFGBuilder
extends CFGBuilder {
    protected CFCFGBuilder() {
    }

    public static ControlFlowGraph build(CompilationUnitTree root, UnderlyingAST underlyingAST, BaseTypeChecker checker, AnnotatedTypeFactory factory, ProcessingEnvironment env) {
        boolean assumeAssertionsEnabled = checker.hasOption("assumeAssertionsAreEnabled");
        boolean assumeAssertionsDisabled = checker.hasOption("assumeAssertionsAreDisabled");
        if (assumeAssertionsEnabled && assumeAssertionsDisabled) {
            ErrorReporter.errorAbort("Assertions cannot be assumed to be enabled and disabled at the same time.");
        }
        CFTreeBuilder builder = new CFTreeBuilder(env);
        CFGBuilder.PhaseOneResult phase1result = new CFCFGTranslationPhaseOne(builder, checker, factory, assumeAssertionsEnabled, assumeAssertionsDisabled, env).process(root, underlyingAST);
        ControlFlowGraph phase2result = CFGBuilder.CFGTranslationPhaseTwo.process(phase1result);
        ControlFlowGraph phase3result = CFGBuilder.CFGTranslationPhaseThree.process(phase2result);
        return phase3result;
    }

    public static boolean assumeAssertionsActivatedForAssertTree(SourceChecker checker, AssertTree tree) {
        ExpressionTree detail = tree.getDetail();
        if (detail != null) {
            String msg = detail.toString();
            Collection<String> warningKeys = checker.getSuppressWarningsKeys();
            for (String warningKey : warningKeys) {
                String key = "@AssumeAssertion(" + warningKey + ")";
                if (!msg.contains(key)) continue;
                return true;
            }
        }
        return false;
    }

    protected static class CFCFGTranslationPhaseOne
    extends CFGBuilder.CFGTranslationPhaseOne {
        protected final BaseTypeChecker checker;
        protected final AnnotatedTypeFactory factory;

        public CFCFGTranslationPhaseOne(CFTreeBuilder builder, BaseTypeChecker checker, AnnotatedTypeFactory factory, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled, ProcessingEnvironment env) {
            super(builder, factory, assumeAssertionsEnabled, assumeAssertionsDisabled, env);
            this.checker = checker;
            this.factory = factory;
        }

        @Override
        protected boolean assumeAssertionsEnabledFor(AssertTree tree) {
            if (CFCFGBuilder.assumeAssertionsActivatedForAssertTree(this.checker, tree)) {
                return true;
            }
            return super.assumeAssertionsEnabledFor(tree);
        }

        @Override
        public void handleArtificialTree(Tree tree) {
            MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getCurrentPath());
            if (enclosingMethod != null) {
                ExecutableElement methodElement = TreeUtils.elementFromDeclaration(enclosingMethod);
                this.factory.setPathHack(tree, methodElement);
            } else {
                ClassTree enclosingClass = TreeUtils.enclosingClass(this.getCurrentPath());
                if (enclosingClass != null) {
                    TypeElement classElement = TreeUtils.elementFromDeclaration(enclosingClass);
                    this.factory.setPathHack(tree, classElement);
                }
            }
        }

        @Override
        protected VariableTree createEnhancedForLoopIteratorVariable(MethodInvocationTree iteratorCall, VariableElement variableElement) {
            boolean oldShouldCache = this.factory.shouldCache;
            this.factory.shouldCache = false;
            AnnotatedTypeMirror annotatedIteratorType = this.factory.getAnnotatedType(iteratorCall);
            this.factory.shouldCache = oldShouldCache;
            Tree annotatedIteratorTypeTree = ((CFTreeBuilder)this.treeBuilder).buildAnnotatedType(annotatedIteratorType);
            this.handleArtificialTree(annotatedIteratorTypeTree);
            VariableTree iteratorVariable = this.treeBuilder.buildVariableDecl(annotatedIteratorTypeTree, this.uniqueName("iter"), variableElement.getEnclosingElement(), (ExpressionTree)iteratorCall);
            return iteratorVariable;
        }

        @Override
        protected VariableTree createEnhancedForLoopArrayVariable(ExpressionTree expression, VariableElement variableElement) {
            boolean oldShouldCache = this.factory.shouldCache;
            this.factory.shouldCache = false;
            AnnotatedTypeMirror annotatedArrayType = this.factory.getAnnotatedType(expression);
            this.factory.shouldCache = oldShouldCache;
            if (annotatedArrayType.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)annotatedArrayType).isUninferredTypeArgument()) {
                TypeMirror type = TreeUtils.typeOf(expression);
                AnnotatedTypeMirror.AnnotatedArrayType newArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)AnnotatedTypeMirror.createType(type, this.factory, false);
                newArrayType.setComponentType(annotatedArrayType);
                newArrayType.addAnnotations(annotatedArrayType.getEffectiveAnnotations());
                annotatedArrayType = newArrayType;
            }
            assert (annotatedArrayType instanceof AnnotatedTypeMirror.AnnotatedArrayType) : "ArrayType must be represented by AnnotatedArrayType";
            Tree annotatedArrayTypeTree = ((CFTreeBuilder)this.treeBuilder).buildAnnotatedType(annotatedArrayType);
            this.handleArtificialTree(annotatedArrayTypeTree);
            VariableTree arrayVariable = this.treeBuilder.buildVariableDecl(annotatedArrayTypeTree, this.uniqueName("array"), variableElement.getEnclosingElement(), expression);
            return arrayVariable;
        }
    }
}

