/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.AnnotationUtils;

public class AnnotationMirrorMap<V>
implements Map<AnnotationMirror, V> {
    private final Map<AnnotationMirror, V> shadowMap = new TreeMap(AnnotationUtils.annotationOrdering());

    public AnnotationMirrorMap() {
    }

    public AnnotationMirrorMap(Map<AnnotationMirror, ? extends V> primaries) {
        this.putAll((Map<? extends AnnotationMirror, ? extends V>)primaries);
    }

    @Override
    public int size() {
        return this.shadowMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.shadowMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof AnnotationMirror) {
            return AnnotationUtils.containsSame(this.shadowMap.keySet(), (AnnotationMirror)key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.shadowMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        AnnotationMirror keyAnno;
        if (key instanceof AnnotationMirror && (keyAnno = AnnotationUtils.getSame(this.shadowMap.keySet(), (AnnotationMirror)key)) != null) {
            return this.shadowMap.get(keyAnno);
        }
        return null;
    }

    @Override
    public V put(AnnotationMirror key, V value) {
        V pre = this.get(key);
        this.remove(key);
        this.shadowMap.put(key, value);
        return pre;
    }

    @Override
    public V remove(Object key) {
        AnnotationMirror keyAnno;
        if (key instanceof AnnotationMirror && (keyAnno = AnnotationUtils.getSame(this.shadowMap.keySet(), (AnnotationMirror)key)) != null) {
            return this.shadowMap.remove(keyAnno);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends AnnotationMirror, ? extends V> m3) {
        for (Map.Entry<AnnotationMirror, V> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.shadowMap.clear();
    }

    @Override
    public Set<AnnotationMirror> keySet() {
        return new AnnotationMirrorSet(this.shadowMap.keySet());
    }

    @Override
    public Collection<V> values() {
        return this.shadowMap.values();
    }

    @Override
    public Set<Map.Entry<AnnotationMirror, V>> entrySet() {
        return this.shadowMap.entrySet();
    }
}

