/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io;

import java.io.PrintWriter;
import java.util.logging.Level;

public class DebugWriter {
    private PrintWriter out = new PrintWriter(System.out);
    private Level level = Level.WARNING;

    public DebugWriter or(final DebugWriter other) {
        return new DebugWriter(){

            @Override
            public boolean isEnabled() {
                return super.isEnabled() || other.isEnabled();
            }
        };
    }

    public static boolean anyEnabled(DebugWriter ... debugs) {
        for (DebugWriter debug : debugs) {
            if (!debug.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.level == Level.INFO;
    }

    public void setEnabled(boolean enabled) {
        this.level = enabled ? Level.INFO : Level.WARNING;
    }

    public void debug(String format, Object ... args) {
        if (this.isEnabled()) {
            this.out.print(String.format(format, args));
            this.out.flush();
        }
    }
}

