/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.rmi;

import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.MonitorStatusChangeEvent;
import sun.jvmstat.monitor.event.VmEvent;
import sun.jvmstat.monitor.event.VmListener;
import sun.jvmstat.monitor.remote.RemoteVm;
import sun.jvmstat.perfdata.monitor.AbstractMonitoredVm;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.protocol.rmi.PerfDataBuffer;

public class RemoteMonitoredVm
extends AbstractMonitoredVm {
    private ArrayList<VmListener> listeners;
    private NotifierTask notifierTask;
    private SamplerTask samplerTask;
    private Timer timer;
    private RemoteVm rvm;
    private ByteBuffer updateBuffer;

    public RemoteMonitoredVm(RemoteVm remoteVm, VmIdentifier vmIdentifier, Timer timer, int n) throws MonitorException {
        super(vmIdentifier, n);
        this.rvm = remoteVm;
        this.pdb = new PerfDataBuffer(remoteVm, vmIdentifier.getLocalVmId());
        this.listeners = new ArrayList();
        this.timer = timer;
    }

    public void attach() throws MonitorException {
        this.updateBuffer = this.pdb.getByteBuffer().duplicate();
        if (this.interval > 0) {
            this.samplerTask = new SamplerTask();
            this.timer.schedule((TimerTask)this.samplerTask, 0L, (long)this.interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        try {
            if (this.interval > 0) {
                if (this.samplerTask != null) {
                    this.samplerTask.cancel();
                    this.samplerTask = null;
                }
                if (this.notifierTask != null) {
                    this.notifierTask.cancel();
                    this.notifierTask = null;
                }
                this.sample();
            }
        }
        catch (RemoteException remoteException) {
            System.err.println("Could not read data for remote JVM " + this.vmid);
            remoteException.printStackTrace();
        }
        finally {
            super.detach();
        }
    }

    public void sample() throws RemoteException {
        assert (this.updateBuffer != null);
        ((PerfDataBuffer)this.pdb).sample(this.updateBuffer);
    }

    public RemoteVm getRemoteVm() {
        return this.rvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVmListener(VmListener vmListener) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(vmListener);
            if (this.notifierTask == null) {
                this.notifierTask = new NotifierTask();
                this.timer.schedule((TimerTask)this.notifierTask, 0L, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVmListener(VmListener vmListener) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(vmListener);
            if (this.listeners.isEmpty() && this.notifierTask != null) {
                this.notifierTask.cancel();
                this.notifierTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(int n) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            CountedTimerTask countedTimerTask;
            if (n == this.interval) {
                return;
            }
            int n2 = this.interval;
            super.setInterval(n);
            if (this.samplerTask != null) {
                this.samplerTask.cancel();
                countedTimerTask = this.samplerTask;
                this.samplerTask = new SamplerTask();
                CountedTimerTaskUtils.reschedule(this.timer, countedTimerTask, this.samplerTask, n2, n);
            }
            if (this.notifierTask != null) {
                this.notifierTask.cancel();
                countedTimerTask = this.notifierTask;
                this.notifierTask = new NotifierTask();
                CountedTimerTaskUtils.reschedule(this.timer, countedTimerTask, this.notifierTask, n2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorStatusChangedEvents(List list, List list2) {
        ArrayList arrayList = null;
        MonitorStatusChangeEvent monitorStatusChangeEvent = null;
        ArrayList<VmListener> arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (VmListener vmListener : arrayList) {
            if (monitorStatusChangeEvent == null) {
                monitorStatusChangeEvent = new MonitorStatusChangeEvent(this, list, list2);
            }
            vmListener.monitorStatusChanged(monitorStatusChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorsUpdatedEvents() {
        ArrayList arrayList = null;
        VmEvent vmEvent = null;
        ArrayList<VmListener> arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (VmListener vmListener : arrayList) {
            if (vmEvent == null) {
                vmEvent = new VmEvent(this);
            }
            vmListener.monitorsUpdated(vmEvent);
        }
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        @Override
        public void run() {
            super.run();
            try {
                MonitorStatus monitorStatus = RemoteMonitoredVm.this.getMonitorStatus();
                List list = monitorStatus.getInserted();
                List list2 = monitorStatus.getRemoved();
                if (!list.isEmpty() || !list2.isEmpty()) {
                    RemoteMonitoredVm.this.fireMonitorStatusChangedEvents(list, list2);
                }
            }
            catch (MonitorException monitorException) {
                System.err.println("Exception updating monitors for " + RemoteMonitoredVm.this.getVmIdentifier());
                monitorException.printStackTrace();
            }
        }
    }

    private class SamplerTask
    extends CountedTimerTask {
        private SamplerTask() {
        }

        @Override
        public void run() {
            super.run();
            try {
                RemoteMonitoredVm.this.sample();
                RemoteMonitoredVm.this.fireMonitorsUpdatedEvents();
            }
            catch (RemoteException remoteException) {
                System.err.println("Exception taking sample for " + RemoteMonitoredVm.this.getVmIdentifier());
                remoteException.printStackTrace();
                this.cancel();
            }
        }
    }
}

