/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.NameContext;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;

public class IDLNames
implements Constants {
    public static final byte[] ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] IDL_IDENTIFIER_CHARS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1};

    public static String getMemberOrMethodName(NameContext nameContext, String string, BatchEnvironment batchEnvironment) {
        String string2 = (String)batchEnvironment.namesCache.get(string);
        if (string2 == null) {
            string2 = nameContext.get(string);
            string2 = IDLNames.convertLeadingUnderscores(string2);
            string2 = IDLNames.convertIDLKeywords(string2);
            string2 = IDLNames.convertToISOLatin1(string2);
            batchEnvironment.namesCache.put(string, string2);
        }
        return string2;
    }

    public static String convertToISOLatin1(String string) {
        String string2 = IDLNames.replace(string, "x\\u", "U");
        string2 = IDLNames.replace(string2, "x\\U", "U");
        int n = string2.length();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c > '\u00ff' || IDL_IDENTIFIER_CHARS[c] == 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string2.substring(0, i));
                }
                stringBuffer.append("U");
                stringBuffer.append((char)ASCII_HEX[(c & 0xF000) >>> 12]);
                stringBuffer.append((char)ASCII_HEX[(c & 0xF00) >>> 8]);
                stringBuffer.append((char)ASCII_HEX[(c & 0xF0) >>> 4]);
                stringBuffer.append((char)ASCII_HEX[c & 0xF]);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer != null) {
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String convertIDLKeywords(String string) {
        for (int i = 0; i < IDL_KEYWORDS.length; ++i) {
            if (!string.equalsIgnoreCase(IDL_KEYWORDS[i])) continue;
            return "_" + string;
        }
        return string;
    }

    public static String convertLeadingUnderscores(String string) {
        if (string.startsWith("_")) {
            return "J" + string;
        }
        return string;
    }

    public static String getClassOrInterfaceName(Identifier identifier, BatchEnvironment batchEnvironment) throws Exception {
        String string;
        String string2 = identifier.getName().toString();
        String string3 = null;
        if (identifier.isQualified()) {
            string3 = identifier.getQualifier().toString();
        }
        if ((string = (String)batchEnvironment.namesCache.get(string2)) == null) {
            string = IDLNames.replace(string2, ". ", "__");
            string = IDLNames.convertToISOLatin1(string);
            NameContext nameContext = NameContext.forName(string3, false, batchEnvironment);
            nameContext.assertPut(string);
            string = IDLNames.getTypeOrModuleName(string);
            batchEnvironment.namesCache.put(string2, string);
        }
        return string;
    }

    public static String getExceptionName(String string) {
        String string2 = string;
        string2 = string.endsWith("Exception") ? IDLNames.stripLeadingUnderscore(string.substring(0, string.lastIndexOf("Exception")) + "Ex") : string + "Ex";
        return string2;
    }

    public static String[] getModuleNames(Identifier identifier, boolean bl, BatchEnvironment batchEnvironment) throws Exception {
        String[] stringArray;
        String[] stringArray2 = null;
        if (identifier.isQualified()) {
            stringArray = identifier.getQualifier();
            batchEnvironment.modulesContext.assertPut(stringArray.toString());
            int n = 1;
            Object object = stringArray;
            while (((Identifier)object).isQualified()) {
                object = ((Identifier)object).getQualifier();
                ++n;
            }
            stringArray2 = new String[n];
            int n2 = n - 1;
            object = stringArray;
            for (int i = 0; i < n; ++i) {
                String string = ((Identifier)object).getName().toString();
                String string2 = (String)batchEnvironment.namesCache.get(string);
                if (string2 == null) {
                    string2 = IDLNames.convertToISOLatin1(string);
                    string2 = IDLNames.getTypeOrModuleName(string2);
                    batchEnvironment.namesCache.put(string, string2);
                }
                stringArray2[n2--] = string2;
                object = ((Identifier)object).getQualifier();
            }
        }
        if (bl) {
            if (stringArray2 == null) {
                stringArray2 = IDL_BOXEDIDL_MODULE;
            } else {
                stringArray = new String[stringArray2.length + IDL_BOXEDIDL_MODULE.length];
                System.arraycopy(IDL_BOXEDIDL_MODULE, 0, stringArray, 0, IDL_BOXEDIDL_MODULE.length);
                System.arraycopy(stringArray2, 0, stringArray, IDL_BOXEDIDL_MODULE.length, stringArray2.length);
                stringArray2 = stringArray;
            }
        }
        return stringArray2;
    }

    public static String getArrayName(Type type, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("seq");
        stringBuffer.append(Integer.toString(n));
        stringBuffer.append("_");
        stringBuffer.append(IDLNames.replace(IDLNames.stripLeadingUnderscore(type.getIDLName()), " ", "_"));
        return stringBuffer.toString();
    }

    public static String[] getArrayModuleNames(Type type) {
        String[] stringArray;
        String[] stringArray2 = type.getIDLModuleNames();
        int n = stringArray2.length;
        if (n == 0) {
            stringArray = IDL_SEQUENCE_MODULE;
        } else {
            stringArray = new String[n + IDL_SEQUENCE_MODULE.length];
            System.arraycopy(IDL_SEQUENCE_MODULE, 0, stringArray, 0, IDL_SEQUENCE_MODULE.length);
            System.arraycopy(stringArray2, 0, stringArray, IDL_SEQUENCE_MODULE.length, n);
        }
        return stringArray;
    }

    private static int getInitialAttributeKind(CompoundType.Method method, BatchEnvironment batchEnvironment) throws ClassNotFound {
        int n = 0;
        if (!method.isConstructor()) {
            boolean bl = true;
            ValueType[] valueTypeArray = method.getExceptions();
            if (valueTypeArray.length > 0) {
                for (int i = 0; i < valueTypeArray.length; ++i) {
                    if (!valueTypeArray[i].isCheckedException() || valueTypeArray[i].isRemoteExceptionOrSubclass()) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = method.getEnclosing().isType(32768);
            }
            if (bl) {
                String string = method.getName();
                int n2 = string.length();
                int n3 = method.getArguments().length;
                Type type = method.getReturnType();
                boolean bl2 = type.isType(1);
                boolean bl3 = type.isType(2);
                if (string.startsWith("get") && n2 > 3 && n3 == 0 && !bl2) {
                    n = 2;
                } else if (string.startsWith("is") && n2 > 2 && n3 == 0 && bl3) {
                    n = 1;
                } else if (string.startsWith("set") && n2 > 3 && n3 == 1 && bl2) {
                    n = 5;
                }
            }
        }
        return n;
    }

    private static void setAttributeKinds(CompoundType.Method[] methodArray, int[] nArray, String[] stringArray) {
        int n;
        int n2;
        int n3 = methodArray.length;
        block5: for (n2 = 0; n2 < n3; ++n2) {
            switch (nArray[n2]) {
                case 2: {
                    stringArray[n2] = stringArray[n2].substring(3);
                    continue block5;
                }
                case 1: {
                    stringArray[n2] = stringArray[n2].substring(2);
                    continue block5;
                }
                case 5: {
                    stringArray[n2] = stringArray[n2].substring(3);
                }
            }
        }
        block6: for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[n2] != 1) continue;
            for (n = 0; n < n3; ++n) {
                Type type;
                Type type2;
                if (n == n2 || nArray[n] != 2 && nArray[n] != 5 || !stringArray[n2].equals(stringArray[n]) || (type2 = methodArray[n2].getReturnType()).equals(type = nArray[n] == 2 ? methodArray[n].getReturnType() : methodArray[n].getArguments()[0])) continue;
                nArray[n2] = 0;
                stringArray[n2] = methodArray[n2].getName();
                continue block6;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[n2] != 5) continue;
            n = -1;
            int n4 = -1;
            for (int i = 0; i < n3; ++i) {
                Type type;
                Type type3;
                if (i == n2 || !stringArray[n2].equals(stringArray[i]) || !(type3 = methodArray[i].getReturnType()).equals(type = methodArray[n2].getArguments()[0])) continue;
                if (nArray[i] == 1) {
                    n4 = i;
                    continue;
                }
                if (nArray[i] != 2) continue;
                n = i;
            }
            if (n > -1) {
                if (n4 > -1) {
                    nArray[n4] = 3;
                    methodArray[n4].setAttributePairIndex(n2);
                    methodArray[n2].setAttributePairIndex(n4);
                    nArray[n] = 0;
                    stringArray[n] = methodArray[n].getName();
                    continue;
                }
                nArray[n] = 4;
                methodArray[n].setAttributePairIndex(n2);
                methodArray[n2].setAttributePairIndex(n);
                continue;
            }
            if (n4 > -1) {
                nArray[n4] = 3;
                methodArray[n4].setAttributePairIndex(n2);
                methodArray[n2].setAttributePairIndex(n4);
                continue;
            }
            nArray[n2] = 0;
            stringArray[n2] = methodArray[n2].getName();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            String string;
            if (nArray[n2] != 0 && Character.isUpperCase((string = stringArray[n2]).charAt(0)) && (string.length() == 1 || Character.isLowerCase(string.charAt(1)))) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(0, Character.toLowerCase(string.charAt(0)));
                stringArray[n2] = stringBuffer.toString();
            }
            methodArray[n2].setAttributeKind(nArray[n2]);
        }
    }

    public static void setMethodNames(CompoundType compoundType, CompoundType.Method[] methodArray, BatchEnvironment batchEnvironment) throws Exception {
        int n;
        CompoundType.Method method;
        int n2;
        int n3;
        Object object;
        int n4 = methodArray.length;
        if (n4 == 0) {
            return;
        }
        String[] stringArray = new String[n4];
        for (int i = 0; i < n4; ++i) {
            stringArray[i] = methodArray[i].getName();
        }
        CompoundType compoundType2 = methodArray[0].getEnclosing();
        if (compoundType2.isType(4096) || compoundType2.isType(8192) || compoundType2.isType(32768)) {
            object = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                object[n3] = IDLNames.getInitialAttributeKind(methodArray[n3], batchEnvironment);
            }
            IDLNames.setAttributeKinds(methodArray, (int[])object, stringArray);
        }
        object = new NameContext(true);
        for (n3 = 0; n3 < n4; ++n3) {
            ((NameContext)object).put(stringArray[n3]);
        }
        n3 = 0;
        for (int i = 0; i < n4; ++i) {
            if (!methodArray[i].isConstructor()) {
                stringArray[i] = IDLNames.getMemberOrMethodName((NameContext)object, stringArray[i], batchEnvironment);
                continue;
            }
            stringArray[i] = "create";
            n3 = 1;
        }
        boolean[] blArray = new boolean[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            blArray[n2] = !methodArray[n2].isAttribute() && !methodArray[n2].isConstructor() && IDLNames.doesMethodCollide(stringArray[n2], methodArray[n2], methodArray, stringArray, true);
        }
        IDLNames.convertOverloadedMethods(methodArray, stringArray, blArray);
        for (n2 = 0; n2 < n4; ++n2) {
            blArray[n2] = !methodArray[n2].isAttribute() && methodArray[n2].isConstructor() && IDLNames.doesConstructorCollide(stringArray[n2], methodArray[n2], methodArray, stringArray, true);
        }
        IDLNames.convertOverloadedMethods(methodArray, stringArray, blArray);
        for (n2 = 0; n2 < n4; ++n2) {
            method = methodArray[n2];
            if (!method.isAttribute() || !IDLNames.doesMethodCollide(stringArray[n2], method, methodArray, stringArray, true)) continue;
            int n5 = n2;
            stringArray[n5] = stringArray[n5] + "__";
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                method = methodArray[n2];
                if (!method.isConstructor() || !IDLNames.doesConstructorCollide(stringArray[n2], method, methodArray, stringArray, false)) continue;
                int n6 = n2;
                stringArray[n6] = stringArray[n6] + "__";
            }
        }
        String string = compoundType.getIDLName();
        for (n = 0; n < n4; ++n) {
            if (!stringArray[n].equalsIgnoreCase(string) || methodArray[n].isAttribute()) continue;
            int n7 = n;
            stringArray[n7] = stringArray[n7] + "_";
        }
        for (n = 0; n < n4; ++n) {
            if (!IDLNames.doesMethodCollide(stringArray[n], methodArray[n], methodArray, stringArray, false)) continue;
            throw new Exception(methodArray[n].toString());
        }
        for (n = 0; n < n4; ++n) {
            CompoundType.Method method2 = methodArray[n];
            String string2 = stringArray[n];
            if (method2.isAttribute()) {
                string2 = ATTRIBUTE_WIRE_PREFIX[method2.getAttributeKind()] + IDLNames.stripLeadingUnderscore(string2);
                String string3 = stringArray[n];
                method2.setAttributeName(string3);
            }
            method2.setIDLName(string2);
        }
    }

    private static String stripLeadingUnderscore(String string) {
        if (string != null && string.length() > 1 && string.charAt(0) == '_') {
            return string.substring(1);
        }
        return string;
    }

    private static String stripTrailingUnderscore(String string) {
        if (string != null && string.length() > 1 && string.charAt(string.length() - 1) == '_') {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static void convertOverloadedMethods(CompoundType.Method[] methodArray, String[] stringArray, boolean[] blArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            CompoundType.Method method = methodArray[i];
            Type[] typeArray = method.getArguments();
            for (int j = 0; j < typeArray.length; ++j) {
                int n = i;
                stringArray[n] = stringArray[n] + "__";
                String string = typeArray[j].getQualifiedIDLName(false);
                string = IDLNames.replace(string, "::_", "_");
                string = IDLNames.replace(string, "::", "_");
                string = IDLNames.replace(string, " ", "_");
                int n2 = i;
                stringArray[n2] = stringArray[n2] + string;
            }
            if (typeArray.length == 0) {
                int n = i;
                stringArray[n] = stringArray[n] + "__";
            }
            stringArray[i] = IDLNames.stripLeadingUnderscore(stringArray[i]);
        }
    }

    private static boolean doesMethodCollide(String string, CompoundType.Method method, CompoundType.Method[] methodArray, String[] stringArray, boolean bl) {
        for (int i = 0; i < methodArray.length; ++i) {
            CompoundType.Method method2 = methodArray[i];
            if (method == method2 || method2.isConstructor() || bl && method2.isAttribute() || !string.equals(stringArray[i])) continue;
            int n = method.getAttributeKind();
            int n2 = method2.getAttributeKind();
            if (n != 0 && n2 != 0 && (n == 5 && n2 != 5 || n != 5 && n2 == 5 || n == 3 && n2 == 2 || n == 2 && n2 == 3)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesConstructorCollide(String string, CompoundType.Method method, CompoundType.Method[] methodArray, String[] stringArray, boolean bl) {
        for (int i = 0; i < methodArray.length; ++i) {
            CompoundType.Method method2 = methodArray[i];
            if (method == method2 || method2.isConstructor() != bl || !string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void setMemberNames(CompoundType compoundType, CompoundType.Member[] memberArray, CompoundType.Method[] methodArray, BatchEnvironment batchEnvironment) throws Exception {
        int n;
        String string;
        int n2;
        NameContext nameContext = new NameContext(true);
        for (n2 = 0; n2 < memberArray.length; ++n2) {
            nameContext.put(memberArray[n2].getName());
        }
        for (n2 = 0; n2 < memberArray.length; ++n2) {
            CompoundType.Member member = memberArray[n2];
            string = IDLNames.getMemberOrMethodName(nameContext, member.getName(), batchEnvironment);
            member.setIDLName(string);
        }
        String string2 = compoundType.getIDLName();
        for (n = 0; n < memberArray.length; ++n) {
            string = memberArray[n].getIDLName();
            if (!string.equalsIgnoreCase(string2)) continue;
            memberArray[n].setIDLName(string + "_");
        }
        for (n = 0; n < memberArray.length; ++n) {
            string = memberArray[n].getIDLName();
            for (int i = 0; i < memberArray.length; ++i) {
                if (n == i || !memberArray[i].getIDLName().equals(string)) continue;
                throw new Exception(string);
            }
        }
        do {
            n = 0;
            block6: for (int i = 0; i < memberArray.length; ++i) {
                String string3 = memberArray[i].getIDLName();
                for (int j = 0; j < methodArray.length; ++j) {
                    if (!methodArray[j].getIDLName().equals(string3)) continue;
                    memberArray[i].setIDLName(string3 + "_");
                    n = 1;
                    continue block6;
                }
            }
        } while (n != 0);
    }

    public static String getTypeName(int n, boolean bl) {
        String string = null;
        switch (n) {
            case 1: {
                string = "void";
                break;
            }
            case 2: {
                string = "boolean";
                break;
            }
            case 4: {
                string = "octet";
                break;
            }
            case 8: {
                string = "wchar";
                break;
            }
            case 16: {
                string = "short";
                break;
            }
            case 32: {
                string = "long";
                break;
            }
            case 64: {
                string = "long long";
                break;
            }
            case 128: {
                string = "float";
                break;
            }
            case 256: {
                string = "double";
                break;
            }
            case 1024: {
                string = "any";
                break;
            }
            case 2048: {
                string = "Object";
                break;
            }
            case 512: {
                string = bl ? "wstring" : "WStringValue";
            }
        }
        return string;
    }

    public static String getQualifiedName(String[] stringArray, String string) {
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    string2 = stringArray[0];
                    continue;
                }
                string2 = string2 + "::";
                string2 = string2 + stringArray[i];
            }
            string2 = string2 + "::";
            string2 = string2 + string;
        } else {
            string2 = string;
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2, 0);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            int n2 = string2.length();
            int n3 = 0;
            while (n >= 0) {
                stringBuffer.append(string.substring(n3, n));
                stringBuffer.append(string3);
                n3 = n + n2;
                n = string.indexOf(string2, n3);
            }
            if (n3 < string.length()) {
                stringBuffer.append(string.substring(n3));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getIDLRepositoryID(String string) {
        return "IDL:" + IDLNames.replace(string, "::", "/") + ":1.0";
    }

    private static String getTypeOrModuleName(String string) {
        String string2 = IDLNames.convertLeadingUnderscores(string);
        return IDLNames.convertIDLKeywords(string2);
    }
}

