/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jcmd;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.attach.HotSpotVirtualMachine;
import sun.tools.jcmd.Arguments;
import sun.tools.jstat.JStatLogger;

public class JCmd {
    public static void main(String[] stringArray) {
        VirtualMachineDescriptor virtualMachineDescriptor;
        Object object;
        List<VirtualMachineDescriptor> list;
        Arguments arguments = null;
        try {
            arguments = new Arguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error parsing arguments: " + illegalArgumentException.getMessage() + "\n");
            Arguments.usage();
            System.exit(1);
        }
        if (arguments.isShowUsage()) {
            Arguments.usage();
            System.exit(1);
        }
        if (arguments.isListProcesses()) {
            list = VirtualMachine.list();
            for (VirtualMachineDescriptor object22 : list) {
                System.out.println(object22.id() + " " + object22.displayName());
            }
            System.exit(0);
        }
        list = new ArrayList<VirtualMachineDescriptor>();
        if (arguments.getPid() == 0) {
            object = VirtualMachine.list();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                virtualMachineDescriptor = (VirtualMachineDescriptor)iterator.next();
                if (JCmd.isJCmdProcess(virtualMachineDescriptor)) continue;
                list.add((VirtualMachineDescriptor)((Object)virtualMachineDescriptor.id()));
            }
        } else if (arguments.getProcessSubstring() != null) {
            object = VirtualMachine.list();
            Iterator<VirtualMachineDescriptor> iterator = object.iterator();
            while (iterator.hasNext()) {
                virtualMachineDescriptor = iterator.next();
                if (JCmd.isJCmdProcess(virtualMachineDescriptor)) continue;
                try {
                    String string = JCmd.getMainClass(virtualMachineDescriptor);
                    if (string == null || string.indexOf(arguments.getProcessSubstring()) == -1) continue;
                    list.add((VirtualMachineDescriptor)((Object)virtualMachineDescriptor.id()));
                }
                catch (URISyntaxException | MonitorException exception) {
                    if (exception.getMessage() != null) {
                        System.err.println(exception.getMessage());
                        continue;
                    }
                    Throwable throwable = exception.getCause();
                    if (throwable != null && throwable.getMessage() != null) {
                        System.err.println(throwable.getMessage());
                        continue;
                    }
                    exception.printStackTrace();
                }
            }
            if (list.isEmpty()) {
                System.err.println("Could not find any processes matching : '" + arguments.getProcessSubstring() + "'");
                System.exit(1);
            }
        } else if (arguments.getPid() == -1) {
            System.err.println("Invalid pid specified");
            System.exit(1);
        } else {
            list.add((VirtualMachineDescriptor)((Object)(arguments.getPid() + "")));
        }
        for (String string : list) {
            System.out.println(string + ":");
            if (arguments.isListCounters()) {
                JCmd.listCounters(string);
                continue;
            }
            try {
                JCmd.executeCommandForPid(string, arguments.getCommand());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void executeCommandForPid(String string, String string2) throws AttachNotSupportedException, IOException, UnsupportedEncodingException {
        String[] stringArray;
        VirtualMachine virtualMachine = VirtualMachine.attach(string);
        HotSpotVirtualMachine hotSpotVirtualMachine = (HotSpotVirtualMachine)virtualMachine;
        for (String string3 : stringArray = string2.split("\\n")) {
            if (string3.trim().equals("stop")) break;
            try (InputStream inputStream = hotSpotVirtualMachine.executeJCmd(string3);){
                int n;
                byte[] byArray = new byte[256];
                do {
                    if ((n = inputStream.read(byArray)) <= 0) continue;
                    String string4 = new String(byArray, 0, n, "UTF-8");
                    System.out.print(string4);
                } while (n > 0);
            }
        }
        virtualMachine.detach();
    }

    private static void listCounters(String string) {
        VmIdentifier vmIdentifier = null;
        try {
            vmIdentifier = new VmIdentifier(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("Malformed VM Identifier: " + string);
            return;
        }
        try {
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmIdentifier);
            MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, -1);
            JStatLogger jStatLogger = new JStatLogger(monitoredVm);
            jStatLogger.printSnapShot("\\w*", new AscendingMonitorComparator(), false, true, System.out);
            monitoredHost.detach(monitoredVm);
        }
        catch (MonitorException monitorException) {
            monitorException.printStackTrace();
        }
    }

    private static boolean isJCmdProcess(VirtualMachineDescriptor virtualMachineDescriptor) {
        try {
            String string = JCmd.getMainClass(virtualMachineDescriptor);
            return string != null && string.equals(JCmd.class.getName());
        }
        catch (URISyntaxException | MonitorException exception) {
            return false;
        }
    }

    private static String getMainClass(VirtualMachineDescriptor virtualMachineDescriptor) throws URISyntaxException, MonitorException {
        try {
            String string = null;
            VmIdentifier vmIdentifier = new VmIdentifier(virtualMachineDescriptor.id());
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmIdentifier);
            MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, -1);
            string = MonitoredVmUtil.mainClass(monitoredVm, true);
            monitoredHost.detach(monitoredVm);
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    static class AscendingMonitorComparator
    implements Comparator<Monitor> {
        AscendingMonitorComparator() {
        }

        @Override
        public int compare(Monitor monitor2, Monitor monitor3) {
            String string = monitor2.getName();
            String string2 = monitor3.getName();
            return string.compareTo(string2);
        }
    }
}

