/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac;

import com.google.common.base.CaseFormat;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import uk.ac.cam.acr31.features.javac.Symbols;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;

class AstScanner {
    private final FeatureGraph featureGraph;
    private final EndPosTable endPosTable;

    private AstScanner(FeatureGraph featureGraph, EndPosTable endPosTable) {
        this.featureGraph = featureGraph;
        this.endPosTable = endPosTable;
    }

    static void addToGraph(JCTree.JCCompilationUnit compilationUnit, FeatureGraph featureGraph) {
        AstScanner scanner = new AstScanner(featureGraph, compilationUnit.endPositions);
        try {
            scanner.scanOrThrow(compilationUnit, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void scanOrThrow(JCTree node, GraphProtos.FeatureNode parent) throws InvocationTargetException, IllegalAccessException {
        GraphProtos.FeatureNode newNode = this.featureGraph.createFeatureNode(GraphProtos.FeatureNode.NodeType.AST_ELEMENT, node.getKind().toString(), node);
        if (parent != null) {
            this.featureGraph.addEdge(parent, newNode, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
        } else {
            this.featureGraph.setAstRoot(newNode);
        }
        Class<?> treeInterface = node.getClass().getInterfaces()[0];
        for (Method m3 : treeInterface.getDeclaredMethods()) {
            NewClassTree newClassTree;
            if (m3.getParameterCount() != 0 || CompilationUnitTree.class.isAssignableFrom(treeInterface) && (m3.getName().equals("getPackageName") || m3.getName().equals("getSourceFile") || m3.getName().equals("getLineMap")) || NewClassTree.class.isAssignableFrom(treeInterface) && (newClassTree = (NewClassTree)((Object)node)).getClassBody() != null && m3.getName().equals("getIdentifier")) continue;
            Object result = m3.invoke((Object)node, new Object[0]);
            ArrayDeque<JCTree> toProcess = new ArrayDeque<JCTree>();
            if (Tree.class.isAssignableFrom(m3.getReturnType())) {
                if (result != null && AstScanner.inSource((JCTree)result)) {
                    toProcess.add((JCTree)result);
                }
            } else if (List.class.isAssignableFrom(m3.getReturnType())) {
                if (result != null) {
                    for (Object o : (List)result) {
                        if (o instanceof JCTree) {
                            if (!AstScanner.inSource((JCTree)o)) continue;
                            toProcess.add((JCTree)o);
                            continue;
                        }
                        if (o instanceof List) {
                            if (!((List)o).isEmpty()) {
                                throw new AssertionError((Object)("Unimplemented traversal of lists of lists " + o.getClass()));
                            }
                            continue;
                        }
                        if (o != null) {
                            throw new AssertionError((Object)("Expected list element to be castable to JCTree or List but it was " + o.getClass()));
                        }
                    }
                }
            } else if (Set.class.isAssignableFrom(m3.getReturnType())) {
                Object o;
                GraphProtos.FeatureNode holderNode = this.featureGraph.createFeatureNode(GraphProtos.FeatureNode.NodeType.FAKE_AST, AstScanner.methodNameToNodeType(m3.getName()), -1, -1);
                this.featureGraph.addEdge(newNode, holderNode, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
                o = ((Set)result).iterator();
                while (o.hasNext()) {
                    Object o2 = o.next();
                    if (o2 instanceof JCTree) {
                        throw new AssertionError((Object)("Did not expect to find trees in a set but found " + o2.getClass()));
                    }
                    GraphProtos.FeatureNode valueNode = this.featureGraph.createFeatureNode(GraphProtos.FeatureNode.NodeType.AST_LEAF, StringEscapeUtils.escapeJava(Objects.toString(o2)), -1, -1);
                    this.featureGraph.addEdge(holderNode, valueNode, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
                }
            } else {
                String value = Objects.toString(result);
                if (m3.getName().equals("isStatic")) {
                    if (value.equals("false")) continue;
                    value = "static";
                }
                if (node.getKind() == Tree.Kind.METHOD && m3.getName().equals("getName") && value.equals("<init>")) {
                    value = Symbols.getSymbol(node).map(sym -> sym.owner.name.toString()).orElseThrow();
                }
                GraphProtos.FeatureNode holderNode = this.featureGraph.createFeatureNode(GraphProtos.FeatureNode.NodeType.FAKE_AST, AstScanner.methodNameToNodeType(m3.getName()), -1, -1);
                this.featureGraph.addEdge(newNode, holderNode, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
                GraphProtos.FeatureNode valueNode = this.featureGraph.createFeatureNode(GraphProtos.FeatureNode.NodeType.AST_LEAF, value, -1, -1);
                this.featureGraph.addEdge(holderNode, valueNode, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
            }
            if (toProcess.isEmpty()) continue;
            JCTree firstChild = (JCTree)toProcess.peekFirst();
            JCTree lastChild = (JCTree)toProcess.peekLast();
            GraphProtos.FeatureNode holderNode = this.featureGraph.createFeatureNode(GraphProtos.FeatureNode.NodeType.FAKE_AST, AstScanner.methodNameToNodeType(m3.getName()), firstChild.getStartPosition(), lastChild.getEndPosition(this.endPosTable));
            this.featureGraph.addEdge(newNode, holderNode, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
            for (JCTree t : toProcess) {
                this.scanOrThrow(t, holderNode);
            }
        }
    }

    private static String methodNameToNodeType(String name) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name.replaceAll("^get", ""));
    }

    private static boolean inSource(JCTree child) {
        Symbol.MethodSymbol sym;
        if (child instanceof JCTree.JCMethodDecl && (sym = ((JCTree.JCMethodDecl)child).sym) != null) {
            boolean synthetic = (sym.flags() & 0x1000L) != 0L;
            boolean generatedConstructor = (sym.flags() & 0x1000000000L) != 0L;
            return !synthetic && !generatedConstructor;
        }
        return true;
    }
}

