/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac;

import com.google.common.collect.ImmutableMap;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import org.checkerframework.dataflow.analysis.AnalysisResult;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.semantic.DataflowOutputs;
import uk.ac.cam.acr31.features.javac.semantic.PossibleTreeSet;
import uk.ac.cam.acr31.features.javac.semantic.PossibleTreeSetStore;
import uk.ac.cam.acr31.features.javac.syntactic.ScanContext;

public class DataflowOutputsScanner
extends TreeScanner<Void, ScanContext> {
    private final ImmutableMap<ClassTree, ImmutableMap<MethodTree, DataflowOutputs>> analysisResults;
    private final FeatureGraph graph;

    static void addToGraph(CompilationUnitTree tree, ImmutableMap<ClassTree, ImmutableMap<MethodTree, DataflowOutputs>> analysisResults, FeatureGraph graph) {
        DataflowOutputsScanner analysisOutputVariableScanner = new DataflowOutputsScanner(analysisResults, graph);
        tree.accept(analysisOutputVariableScanner, new ScanContext(null, null));
    }

    private DataflowOutputsScanner(ImmutableMap<ClassTree, ImmutableMap<MethodTree, DataflowOutputs>> analysisResults, FeatureGraph graph) {
        this.analysisResults = analysisResults;
        this.graph = graph;
    }

    @Override
    public Void visitClass(ClassTree node, ScanContext scanContext) {
        return (Void)super.visitClass(node, scanContext.withClassTree(node));
    }

    @Override
    public Void visitMethod(MethodTree node, ScanContext scanContext) {
        return (Void)super.visitMethod(node, scanContext.withMethodTree(node));
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, ScanContext scanContext) {
        this.apply(node, scanContext);
        return (Void)super.visitIdentifier(node, scanContext);
    }

    @Override
    public Void visitVariable(VariableTree node, ScanContext scanContext) {
        this.apply(node, scanContext);
        return (Void)super.visitVariable(node, scanContext);
    }

    private void apply(Tree node, ScanContext context) {
        if (context.classTree == null || context.methodTree == null) {
            return;
        }
        ImmutableMap<MethodTree, DataflowOutputs> map = this.analysisResults.get(context.classTree);
        if (map == null) {
            return;
        }
        DataflowOutputs a = map.get(context.methodTree);
        if (a == null) {
            return;
        }
        this.applyAnalysisResult(node, a.lastWrites, GraphProtos.FeatureEdge.EdgeType.LAST_WRITE);
        this.applyAnalysisResult(node, a.lastUses, GraphProtos.FeatureEdge.EdgeType.LAST_USE);
    }

    private void applyAnalysisResult(Tree node, AnalysisResult<PossibleTreeSet, PossibleTreeSetStore> r, GraphProtos.FeatureEdge.EdgeType edgeType) {
        PossibleTreeSet possibles = r.getValue(node);
        if (possibles != null) {
            for (Tree tree : possibles.nodes()) {
                this.graph.addIdentifierEdge(tree, node, edgeType);
            }
        }
    }
}

