/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import uk.ac.cam.acr31.features.javac.AstScanner;
import uk.ac.cam.acr31.features.javac.DataflowOutputsScanner;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.graph.ProtoOutput;
import uk.ac.cam.acr31.features.javac.lexical.Tokens;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.semantic.AssignabilityAnalysis;
import uk.ac.cam.acr31.features.javac.semantic.DataflowOutputs;
import uk.ac.cam.acr31.features.javac.semantic.TypeAnalysis;
import uk.ac.cam.acr31.features.javac.semantic.TypeScanner;
import uk.ac.cam.acr31.features.javac.syntactic.ComputedFromScanner;
import uk.ac.cam.acr31.features.javac.syntactic.FormalArgScanner;
import uk.ac.cam.acr31.features.javac.syntactic.GuardedByScanner;
import uk.ac.cam.acr31.features.javac.syntactic.LastLexicalUseScanner;
import uk.ac.cam.acr31.features.javac.syntactic.ReturnsToScanner;
import uk.ac.cam.acr31.features.javac.syntactic.SymbolScanner;

public class FeaturePlugin
implements Plugin {
    private static final String FEATURES_OUTPUT_DIRECTORY = "featuresOutputDirectory";
    private static final String ABORT_ON_ERROR = "abortOnError";
    private static final Comparator<GraphProtos.FeatureNode> TOKENS_LAST = Comparator.comparing(n -> {
        switch (n.getType()) {
            case TOKEN: {
                return 1;
            }
        }
        return 0;
    });
    private static final Comparator<GraphProtos.FeatureNode> BY_START_POSITION = Comparator.comparing(GraphProtos.FeatureNode::getStartPosition);
    private static final Comparator<GraphProtos.FeatureNode> BY_ID = Comparator.comparing(GraphProtos.FeatureNode::getId);

    @Override
    public String getName() {
        return "FeaturePlugin";
    }

    @Override
    public void init(JavacTask task, String ... args) {
        final Context context = ((BasicJavacTask)task).getContext();
        task.addTaskListener(new TaskListener(){

            @Override
            public void finished(TaskEvent e) {
                if (e.getKind() != TaskEvent.Kind.ANALYZE) {
                    return;
                }
                FeaturePlugin.process(e, context);
            }
        });
    }

    private static void process(TaskEvent taskEvent, Context context) {
        Options options = Options.instance(context);
        boolean abortOnError = options.getBoolean(ABORT_ON_ERROR);
        String featuresOutputDirectory = ".";
        if (options.isSet(FEATURES_OUTPUT_DIRECTORY)) {
            featuresOutputDirectory = options.get(FEATURES_OUTPUT_DIRECTORY);
        }
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)taskEvent.getCompilationUnit();
        try {
            FeatureGraph featureGraph = FeaturePlugin.createFeatureGraph(compilationUnit, context);
            FeaturePlugin.writeOutput(featureGraph, featuresOutputDirectory);
        }
        catch (AssertionError | RuntimeException e) {
            String message = "Feature extraction failed: " + taskEvent.getSourceFile().getName();
            if (abortOnError) {
                throw new RuntimeException(message, (Throwable)e);
            }
            System.out.println(message);
        }
    }

    private static void mkdirFor(File file) {
        File directory = file.getParentFile();
        if (directory.exists()) {
            return;
        }
        if (!directory.mkdirs()) {
            throw new IOError(new IOException("Failed to create directory for " + file));
        }
    }

    private static void writeOutput(FeatureGraph featureGraph, String featuresOutputDirectory) {
        File protoFile = new File(featuresOutputDirectory, featureGraph.getSourceFileName() + ".proto");
        FeaturePlugin.mkdirFor(protoFile);
        ProtoOutput.write(protoFile, featureGraph);
    }

    static FeatureGraph createFeatureGraph(JCTree.JCCompilationUnit compilationUnit, Context context) {
        FeatureGraph featureGraph = new FeatureGraph(compilationUnit.getSourceFile().getName(), compilationUnit.endPositions, compilationUnit.lineMap);
        AstScanner.addToGraph(compilationUnit, featureGraph);
        Tokens.addToGraph(compilationUnit.getSourceFile(), context, featureGraph);
        FeaturePlugin.linkTokensToAstNodes(featureGraph);
        featureGraph.pruneAstNodes();
        JavacProcessingEnvironment processingEnvironment = JavacProcessingEnvironment.instance(context);
        ImmutableMap<ClassTree, ImmutableMap<MethodTree, DataflowOutputs>> analysisResults = DataflowOutputs.create(compilationUnit, processingEnvironment);
        DataflowOutputsScanner.addToGraph(compilationUnit, analysisResults, featureGraph);
        TypeAnalysis typeAnalysis = new TypeAnalysis(compilationUnit, processingEnvironment);
        TypeScanner.addToGraph(compilationUnit, featureGraph, typeAnalysis);
        AssignabilityAnalysis.addToGraph(featureGraph, typeAnalysis);
        ComputedFromScanner.addToGraph(compilationUnit, featureGraph);
        LastLexicalUseScanner.addToGraph(compilationUnit, featureGraph);
        ReturnsToScanner.addToGraph(compilationUnit, featureGraph);
        FormalArgScanner.addToGraph(compilationUnit, featureGraph);
        GuardedByScanner.addToGraph(compilationUnit, featureGraph);
        SymbolScanner.addToGraph(compilationUnit, featureGraph);
        FeaturePlugin.linkCommentsToAstNodes(featureGraph);
        FeaturePlugin.checkSymbols(featureGraph);
        return featureGraph;
    }

    private static void checkSymbols(FeatureGraph graph) {
        graph.nodes().stream().filter(n -> n.getType().equals(GraphProtos.FeatureNode.NodeType.IDENTIFIER_TOKEN)).filter(n -> !graph.hasAncestor((GraphProtos.FeatureNode)n, GraphProtos.FeatureNode.NodeType.AST_ELEMENT, "PACKAGE")).filter(n -> !graph.hasAncestor((GraphProtos.FeatureNode)n, GraphProtos.FeatureNode.NodeType.AST_ELEMENT, "LABELED_STATEMENT")).forEach(token -> {
            if (graph.predecessors((GraphProtos.FeatureNode)token, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_SYMBOL).isEmpty()) {
                throw new AssertionError((Object)(token + " has no associated symbol"));
            }
        });
    }

    private static void removeIdentifierAstNodes(FeatureGraph graph) {
        for (GraphProtos.FeatureNode node : graph.astNodes()) {
            GraphProtos.FeatureEdge.EdgeType edgeType;
            if (!node.getContents().equals("IDENTIFIER")) continue;
            Set<GraphProtos.FeatureNode> sources = graph.predecessors(node, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
            Iterator iterator = ImmutableList.of(GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN, GraphProtos.FeatureEdge.EdgeType.AST_CHILD).iterator();
            while (iterator.hasNext() && !FeaturePlugin.removeNode(graph, node, sources, edgeType = (GraphProtos.FeatureEdge.EdgeType)iterator.next())) {
            }
        }
    }

    private static boolean removeNode(FeatureGraph graph, GraphProtos.FeatureNode node, Set<GraphProtos.FeatureNode> sources, GraphProtos.FeatureEdge.EdgeType edgeType) {
        Set<GraphProtos.FeatureNode> successors = graph.successors(node, edgeType);
        if (successors.isEmpty()) {
            return false;
        }
        GraphProtos.FeatureNode dest = Iterables.getOnlyElement(successors);
        graph.removeNode(node);
        for (GraphProtos.FeatureNode source : sources) {
            graph.addEdge(source, dest, edgeType);
        }
        graph.replaceNodeInNodeMap(node, dest);
        return true;
    }

    private static void linkTokensToAstNodes(FeatureGraph featureGraph) {
        ImmutableSet astNodes = ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(BY_START_POSITION.thenComparing(TOKENS_LAST).thenComparing(BY_ID)).addAll(featureGraph.astNodes())).addAll(featureGraph.tokens())).build();
        astNodes.stream().filter(node -> node.getType().equals(GraphProtos.FeatureNode.NodeType.AST_ELEMENT)).filter(node -> node.getContents().equals("VARIABLE")).forEach(arg_0 -> FeaturePlugin.lambda$linkTokensToAstNodes$11(featureGraph, (ImmutableSortedSet)astNodes, arg_0));
        for (GraphProtos.FeatureNode token : featureGraph.tokens()) {
            if (!featureGraph.predecessors(token, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN).isEmpty()) continue;
            Comparator<GraphProtos.FeatureNode> nodeSpan = Comparator.comparing(n -> n.getEndPosition() - n.getStartPosition());
            Comparator<GraphProtos.FeatureNode> nodeId = Comparator.comparingLong(GraphProtos.FeatureNode::getId).reversed();
            Optional<GraphProtos.FeatureNode> smallestEncompassingNode = ((ImmutableSortedSet)astNodes).headSet(token).stream().filter(n -> n.getType().equals(GraphProtos.FeatureNode.NodeType.AST_ELEMENT)).filter(n -> n.getEndPosition() >= token.getEndPosition()).min(nodeSpan.thenComparing(nodeId));
            if (!smallestEncompassingNode.isPresent()) continue;
            Optional<GraphProtos.FeatureNode> matchingLeaf = FeaturePlugin.findMatchingLeaf(smallestEncompassingNode.get(), token, featureGraph);
            if (matchingLeaf.isPresent()) {
                featureGraph.addEdge(matchingLeaf.get(), token, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN);
                continue;
            }
            featureGraph.addEdge(smallestEncompassingNode.get(), token, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN);
        }
    }

    private static Optional<GraphProtos.FeatureNode> findMatchingLeaf(GraphProtos.FeatureNode current, GraphProtos.FeatureNode token, FeatureGraph graph) {
        for (GraphProtos.FeatureNode child : graph.successors(current, GraphProtos.FeatureEdge.EdgeType.AST_CHILD)) {
            if (child.getType() != GraphProtos.FeatureNode.NodeType.FAKE_AST) continue;
            for (GraphProtos.FeatureNode possibleLeaf : graph.successors(child, GraphProtos.FeatureEdge.EdgeType.AST_CHILD)) {
                if (possibleLeaf.getType() != GraphProtos.FeatureNode.NodeType.AST_LEAF || !possibleLeaf.getContents().equalsIgnoreCase(token.getContents())) continue;
                return Optional.of(possibleLeaf);
            }
        }
        return Optional.empty();
    }

    private static void linkCommentsToAstNodes(FeatureGraph featureGraph) {
        for (GraphProtos.FeatureNode comment : featureGraph.comments()) {
            GraphProtos.FeatureNode successor = Iterables.getOnlyElement(featureGraph.successors(comment, GraphProtos.FeatureEdge.EdgeType.COMMENT));
            if (comment.getEndLineNumber() == successor.getStartLineNumber()) continue;
            GraphProtos.FeatureNode match = null;
            for (GraphProtos.FeatureNode astNode : featureGraph.nodes()) {
                int distance;
                if (astNode.getType().equals(GraphProtos.FeatureNode.NodeType.FAKE_AST) || (distance = astNode.getStartPosition() - comment.getEndPosition()) < 0) continue;
                int size = astNode.getEndPosition() - astNode.getStartPosition();
                if (match != null) {
                    int matchDistance = match.getStartPosition() - comment.getEndPosition();
                    int matchSize = match.getEndPosition() - match.getStartPosition();
                    if (distance < matchDistance) {
                        match = astNode;
                        continue;
                    }
                    if (distance != matchDistance || size <= matchSize) continue;
                    match = astNode;
                    continue;
                }
                match = astNode;
            }
            if (match == null) continue;
            featureGraph.removeEdge(GraphProtos.FeatureEdge.newBuilder().setSourceId(comment.getId()).setDestinationId(successor.getId()).setType(GraphProtos.FeatureEdge.EdgeType.COMMENT).build());
            featureGraph.addEdge(comment, match, GraphProtos.FeatureEdge.EdgeType.COMMENT);
        }
    }

    private static /* synthetic */ void lambda$linkTokensToAstNodes$11(FeatureGraph featureGraph, ImmutableSortedSet astNodes, GraphProtos.FeatureNode node) {
        JCTree.JCVariableDecl variableTree = (JCTree.JCVariableDecl)featureGraph.lookupTree(node);
        Name expectedName = variableTree.getName();
        Optional<GraphProtos.FeatureNode> matchingToken = astNodes.tailSet(node).stream().filter(target -> target.getType().equals(GraphProtos.FeatureNode.NodeType.IDENTIFIER_TOKEN)).filter(target -> expectedName.contentEquals(target.getContents())).findFirst();
        matchingToken.ifPresent(token -> FeaturePlugin.findMatchingLeaf(node, token, featureGraph).ifPresent(leaf -> featureGraph.addEdge((GraphProtos.FeatureNode)leaf, (GraphProtos.FeatureNode)token, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN)));
    }
}

