/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.graph;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;

public class FeatureGraph {
    private final String sourceFileName;
    private final MutableNetwork<GraphProtos.FeatureNode, GraphProtos.FeatureEdge> graph;
    private final BiMap<Tree, GraphProtos.FeatureNode> treeToNodeMap;
    private final EndPosTable endPosTable;
    private final LineMap lineMap;
    private final BiMap<Symbol, GraphProtos.FeatureNode> symbolToNodeMap;
    private final Map<TypeMirror, GraphProtos.FeatureNode> typeToNodeMap;
    private final Map<GraphProtos.FeatureNode, TypeMirror> nodeToSomeTypeMap;
    private int nodeIdCounter = 0;
    private GraphProtos.FeatureNode firstToken = null;
    private GraphProtos.FeatureNode astRoot = null;

    public FeatureGraph(String sourceFileName, EndPosTable endPosTable, LineMap lineMap) {
        this.sourceFileName = sourceFileName;
        this.graph = NetworkBuilder.directed().allowsSelfLoops(true).allowsParallelEdges(true).build();
        this.treeToNodeMap = HashBiMap.create();
        this.symbolToNodeMap = HashBiMap.create();
        this.typeToNodeMap = new HashMap<TypeMirror, GraphProtos.FeatureNode>();
        this.nodeToSomeTypeMap = new HashMap<GraphProtos.FeatureNode, TypeMirror>();
        this.endPosTable = endPosTable;
        this.lineMap = lineMap;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public GraphProtos.FeatureNode lookupNode(Tree tree) {
        return (GraphProtos.FeatureNode)this.treeToNodeMap.get(tree);
    }

    public Tree lookupTree(GraphProtos.FeatureNode node) {
        return (Tree)this.treeToNodeMap.inverse().get(node);
    }

    public void replaceNodeInNodeMap(GraphProtos.FeatureNode original, GraphProtos.FeatureNode replacement) {
        Tree tree = (Tree)this.treeToNodeMap.inverse().get(original);
        if (tree != null) {
            this.treeToNodeMap.put(tree, replacement);
        }
    }

    public GraphProtos.FeatureNode createFeatureNode(GraphProtos.FeatureNode.NodeType nodeType, String contents, Tree tree) {
        if (this.treeToNodeMap.containsKey(tree)) {
            return (GraphProtos.FeatureNode)this.treeToNodeMap.get(tree);
        }
        int startPosition = ((JCTree)tree).getStartPosition();
        int endPosition = ((JCTree)tree).getEndPosition(this.endPosTable);
        GraphProtos.FeatureNode result = this.createFeatureNode(nodeType, contents, startPosition, endPosition);
        this.treeToNodeMap.put(tree, result);
        return result;
    }

    public GraphProtos.FeatureNode createFeatureNode(GraphProtos.FeatureNode.NodeType nodeType, String contents, int startPosition, int endPosition) {
        int startLine = (int)this.lineMap.getLineNumber(startPosition);
        int endLine = (int)this.lineMap.getLineNumber(endPosition);
        return GraphProtos.FeatureNode.newBuilder().setId(this.nodeIdCounter++).setType(nodeType).setContents(contents).setStartPosition(startPosition).setEndPosition(endPosition).setStartLineNumber(startLine).setEndLineNumber(endLine).build();
    }

    public GraphProtos.FeatureNode createFeatureNode(GraphProtos.FeatureNode.NodeType nodeType, Symbol symbol) {
        if (this.symbolToNodeMap.containsKey(symbol)) {
            return (GraphProtos.FeatureNode)this.symbolToNodeMap.get(symbol);
        }
        GraphProtos.FeatureNode result = this.createFeatureNode(nodeType, FeatureGraph.getName(symbol), -1, -1);
        if (symbol.kind == Kinds.Kind.MTH) {
            GraphProtos.FeatureNode signature = this.createFeatureNode(GraphProtos.FeatureNode.NodeType.METHOD_SIGNATURE, symbol.toString(), -1, -1);
            this.addEdge(result, signature, GraphProtos.FeatureEdge.EdgeType.METHOD_SIGNATURE);
        }
        this.symbolToNodeMap.put(symbol, result);
        return result;
    }

    private static String getName(Symbol symbol) {
        if (symbol.owner != null && symbol.owner.kind == Kinds.Kind.MTH && symbol.kind == Kinds.Kind.VAR) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            return FeatureGraph.getName(varSymbol.owner) + "." + varSymbol.name + "@" + varSymbol.pos;
        }
        switch (1.$SwitchMap$com$sun$tools$javac$code$Kinds$Kind[symbol.kind.ordinal()]) {
            case 1: 
            case 2: {
                return symbol.flatName().toString();
            }
        }
        return FeatureGraph.getName(symbol.owner) + "." + symbol.toString();
    }

    public TypeMirror lookupTypeMirror(GraphProtos.FeatureNode node) {
        return this.nodeToSomeTypeMap.get(node);
    }

    public GraphProtos.FeatureNode createFeatureNodeForType(Types types, GraphProtos.FeatureNode.NodeType nodeType, TypeMirror type) {
        if (this.typeToNodeMap.containsKey(type)) {
            return this.typeToNodeMap.get(type);
        }
        for (TypeMirror existingType : this.typeToNodeMap.keySet()) {
            if (!types.isSameType(type, existingType)) continue;
            GraphProtos.FeatureNode result = this.typeToNodeMap.get(existingType);
            this.typeToNodeMap.put(type, result);
            return result;
        }
        GraphProtos.FeatureNode result = this.createFeatureNode(nodeType, type.toString(), -1, -1);
        this.typeToNodeMap.put(type, result);
        this.nodeToSomeTypeMap.put(result, type);
        return result;
    }

    public Set<GraphProtos.FeatureNode> nodes() {
        return this.graph.nodes();
    }

    private Set<GraphProtos.FeatureNode> nodes(GraphProtos.FeatureNode.NodeType ... nodeTypes) {
        ImmutableList<GraphProtos.FeatureNode.NodeType> nodes = ImmutableList.copyOf(nodeTypes);
        return this.graph.nodes().stream().filter(n -> nodes.contains(n.getType())).collect(ImmutableSet.toImmutableSet());
    }

    public GraphProtos.FeatureNode root() {
        return this.getAstRoot();
    }

    public Set<GraphProtos.FeatureNode> tokens() {
        return this.nodes(GraphProtos.FeatureNode.NodeType.TOKEN, GraphProtos.FeatureNode.NodeType.IDENTIFIER_TOKEN);
    }

    public Set<GraphProtos.FeatureNode> astNodes() {
        return this.nodes(GraphProtos.FeatureNode.NodeType.AST_ELEMENT, GraphProtos.FeatureNode.NodeType.FAKE_AST, GraphProtos.FeatureNode.NodeType.AST_LEAF);
    }

    public Set<GraphProtos.FeatureNode> comments() {
        return this.nodes(GraphProtos.FeatureNode.NodeType.COMMENT_BLOCK, GraphProtos.FeatureNode.NodeType.COMMENT_JAVADOC, GraphProtos.FeatureNode.NodeType.COMMENT_LINE);
    }

    public Set<GraphProtos.FeatureNode> symbols() {
        return this.nodes(GraphProtos.FeatureNode.NodeType.SYMBOL, GraphProtos.FeatureNode.NodeType.SYMBOL_MTH, GraphProtos.FeatureNode.NodeType.SYMBOL_TYP, GraphProtos.FeatureNode.NodeType.SYMBOL_VAR);
    }

    public Set<GraphProtos.FeatureNode> types() {
        return this.nodes(GraphProtos.FeatureNode.NodeType.TYPE);
    }

    public Set<GraphProtos.FeatureEdge> edges() {
        return this.graph.edges();
    }

    public Set<GraphProtos.FeatureEdge> edges(GraphProtos.FeatureEdge.EdgeType edgeType) {
        return this.graph.edges().stream().filter(e -> e.getType().equals(edgeType)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<GraphProtos.FeatureEdge> edges(GraphProtos.FeatureNode node) {
        return this.graph.incidentEdges(node);
    }

    public Set<GraphProtos.FeatureEdge> edges(GraphProtos.FeatureNode source, GraphProtos.FeatureNode destination) {
        return this.graph.edgesConnecting(source, destination);
    }

    public EndpointPair<GraphProtos.FeatureNode> incidentNodes(GraphProtos.FeatureEdge edge) {
        return this.graph.incidentNodes(edge);
    }

    public void removeNode(GraphProtos.FeatureNode node) {
        this.graph.removeNode(node);
    }

    public Set<GraphProtos.FeatureNode> successors(GraphProtos.FeatureNode node) {
        return this.graph.successors((Object)node);
    }

    public Set<GraphProtos.FeatureNode> successors(GraphProtos.FeatureNode node, GraphProtos.FeatureEdge.EdgeType ... edgeTypes) {
        ImmutableList<GraphProtos.FeatureEdge.EdgeType> edgeTypeList = ImmutableList.copyOf(edgeTypes);
        return this.graph.successors((Object)node).stream().filter(n -> this.graph.edgesConnecting(node, (GraphProtos.FeatureNode)n).stream().anyMatch(e -> edgeTypeList.contains(e.getType()))).collect(ImmutableSet.toImmutableSet());
    }

    public boolean hasAncestor(GraphProtos.FeatureNode node, GraphProtos.FeatureNode.NodeType ancestorType, String ancestorContents) {
        LinkedList<GraphProtos.FeatureNode> queue = new LinkedList<GraphProtos.FeatureNode>(this.predecessors(node));
        HashSet<GraphProtos.FeatureNode> visited = new HashSet<GraphProtos.FeatureNode>();
        while (!queue.isEmpty()) {
            GraphProtos.FeatureNode next = (GraphProtos.FeatureNode)queue.pop();
            if (visited.contains(next)) continue;
            if (next.getType() == ancestorType && next.getContents().equals(ancestorContents)) {
                return true;
            }
            visited.add(next);
            queue.addAll((Collection<GraphProtos.FeatureNode>)this.graph.predecessors((Object)next));
        }
        return false;
    }

    public Set<GraphProtos.FeatureNode> predecessors(GraphProtos.FeatureNode node) {
        return this.graph.predecessors((Object)node);
    }

    public Set<GraphProtos.FeatureNode> predecessors(GraphProtos.FeatureNode node, GraphProtos.FeatureEdge.EdgeType ... edgeTypes) {
        ImmutableList<GraphProtos.FeatureEdge.EdgeType> edgeTypeList = ImmutableList.copyOf(edgeTypes);
        return this.graph.predecessors((Object)node).stream().filter(n -> this.graph.edgesConnecting((GraphProtos.FeatureNode)n, node).stream().anyMatch(e -> edgeTypeList.contains(e.getType()))).collect(ImmutableSet.toImmutableSet());
    }

    public void pruneAstNodes() {
        this.nodes(GraphProtos.FeatureNode.NodeType.AST_LEAF).forEach(n -> {
            Set<GraphProtos.FeatureNode> successors = this.successors((GraphProtos.FeatureNode)n, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN);
            GraphProtos.FeatureNode predecessor = Iterables.getOnlyElement(this.predecessors((GraphProtos.FeatureNode)n, GraphProtos.FeatureEdge.EdgeType.AST_CHILD));
            for (GraphProtos.FeatureNode successor : successors) {
                this.addEdge(predecessor, successor, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN);
            }
            this.graph.removeNode((GraphProtos.FeatureNode)n);
            this.treeToNodeMap.inverse().remove(n);
        });
        this.nodes(GraphProtos.FeatureNode.NodeType.FAKE_AST).forEach(n -> {
            GraphProtos.FeatureNode successor;
            Set<GraphProtos.FeatureNode> successors = this.successors((GraphProtos.FeatureNode)n, GraphProtos.FeatureEdge.EdgeType.AST_CHILD);
            if (successors.size() == 1 && (successor = Iterables.getOnlyElement(successors)).getContents().equals(n.getContents())) {
                for (GraphProtos.FeatureNode predecessor : this.predecessors((GraphProtos.FeatureNode)n)) {
                    for (GraphProtos.FeatureEdge edge : ImmutableSet.copyOf(this.edges(predecessor, (GraphProtos.FeatureNode)n))) {
                        this.addEdge(predecessor, successor, edge.getType());
                    }
                }
                this.graph.removeNode((GraphProtos.FeatureNode)n);
                this.treeToNodeMap.inverse().remove(n);
            }
        });
        while (this.pruneLeavesOnce()) {
        }
    }

    public GraphProtos.FeatureNode toIdentifierNode(GraphProtos.FeatureNode node) {
        if (node.getType().equals(GraphProtos.FeatureNode.NodeType.IDENTIFIER_TOKEN)) {
            return node;
        }
        if (node.getType().equals(GraphProtos.FeatureNode.NodeType.AST_ELEMENT)) {
            LinkedList<GraphProtos.FeatureNode> toCheck = new LinkedList<GraphProtos.FeatureNode>();
            toCheck.add(node);
            while (!toCheck.isEmpty()) {
                GraphProtos.FeatureNode next = (GraphProtos.FeatureNode)toCheck.pop();
                Set<GraphProtos.FeatureNode> successors = this.successors(next, GraphProtos.FeatureEdge.EdgeType.AST_CHILD, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN);
                Optional<GraphProtos.FeatureNode> name = successors.stream().filter(n -> n.getType().equals(GraphProtos.FeatureNode.NodeType.IDENTIFIER_TOKEN)).findAny();
                if (name.isPresent()) {
                    return name.get();
                }
                toCheck.addAll(successors);
            }
            Optional<GraphProtos.FeatureNode> token = this.tokens().stream().filter(t -> t.getStartPosition() == node.getStartPosition()).findAny();
            if (token.isPresent()) {
                return token.get();
            }
        }
        throw new AssertionError((Object)("Need to support " + node.getContents()));
    }

    public void addEdge(Tree source, Tree dest, GraphProtos.FeatureEdge.EdgeType type) {
        GraphProtos.FeatureNode sourceNode = this.lookupNode(source);
        GraphProtos.FeatureNode destNode = this.lookupNode(dest);
        if (sourceNode == null || destNode == null) {
            return;
        }
        this.addEdge(sourceNode, destNode, type);
    }

    public void addEdge(GraphProtos.FeatureNode source, GraphProtos.FeatureNode dest, GraphProtos.FeatureEdge.EdgeType type) {
        this.graph.addEdge(source, dest, GraphProtos.FeatureEdge.newBuilder().setSourceId(source.getId()).setDestinationId(dest.getId()).setType(type).build());
    }

    public void addIdentifierEdge(Tree source, Tree dest, GraphProtos.FeatureEdge.EdgeType type) {
        GraphProtos.FeatureNode sourceNode = this.lookupNode(source);
        GraphProtos.FeatureNode destNode = this.lookupNode(dest);
        if (sourceNode == null || destNode == null) {
            return;
        }
        this.addEdge(this.toIdentifierNode(sourceNode), this.toIdentifierNode(destNode), type);
    }

    public void removeEdge(GraphProtos.FeatureEdge edge) {
        this.graph.removeEdge(edge);
    }

    GraphProtos.Graph toProtobuf() {
        return GraphProtos.Graph.newBuilder().setSourceFile(this.sourceFileName).addAllNode(this.nodes()).addAllEdge(this.edges()).setFirstToken(this.firstToken).setAstRoot(this.astRoot).build();
    }

    public Set<GraphProtos.FeatureNode> findNode(int start, int end) {
        return this.nodes().stream().filter(node -> node.getStartPosition() == start).filter(node -> node.getEndPosition() == end).collect(ImmutableSet.toImmutableSet());
    }

    public void setFirstToken(GraphProtos.FeatureNode firstToken) {
        this.firstToken = firstToken;
    }

    public GraphProtos.FeatureNode getFirstToken() {
        return this.firstToken;
    }

    public void setAstRoot(GraphProtos.FeatureNode astRoot) {
        this.astRoot = astRoot;
    }

    public GraphProtos.FeatureNode getAstRoot() {
        return this.astRoot;
    }

    private boolean pruneLeavesOnce() {
        ImmutableSet toRemove = this.graph.nodes().stream().filter(n -> n.getType().equals(GraphProtos.FeatureNode.NodeType.AST_ELEMENT) || n.getType().equals(GraphProtos.FeatureNode.NodeType.FAKE_AST)).filter(n -> this.graph.successors(n).isEmpty()).collect(ImmutableSet.toImmutableSet());
        toRemove.stream().filter(n -> n.getType().equals(GraphProtos.FeatureNode.NodeType.AST_LEAF)).findAny().ifPresent(n -> {
            throw new AssertionError((Object)("AST Leaf not matched to token: " + n));
        });
        toRemove.forEach(this.graph::removeNode);
        toRemove.forEach(n -> this.treeToNodeMap.inverse().remove(n));
        return !toRemove.isEmpty();
    }
}

