/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.lexical;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.util.Iterator;
import javax.tools.JavaFileObject;
import org.apache.commons.text.StringEscapeUtils;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;

public class Tokens {
    public static void addToGraph(JavaFileObject sourceFile, Context context, FeatureGraph featureGraph) {
        ErrorProneToken token;
        ImmutableList<ErrorProneToken> tokens = ErrorProneTokens.getTokens(Tokens.getSourceFileContent(sourceFile).toString(), context);
        GraphProtos.FeatureNode previousTokenNode = null;
        Iterator iterator = tokens.iterator();
        while (iterator.hasNext() && (token = (ErrorProneToken)iterator.next()).kind() != Tokens.TokenKind.EOF) {
            GraphProtos.FeatureNode tokenNode = featureGraph.createFeatureNode(Tokens.getNodeType(token), Tokens.tokenToString(token), token.pos(), token.endPos());
            if (previousTokenNode != null) {
                featureGraph.addEdge(previousTokenNode, tokenNode, GraphProtos.FeatureEdge.EdgeType.NEXT_TOKEN);
            } else {
                featureGraph.setFirstToken(tokenNode);
            }
            previousTokenNode = tokenNode;
            if (token.comments() == null) continue;
            for (Tokens.Comment comment : token.comments()) {
                if (comment.getText() == null) continue;
                GraphProtos.FeatureNode commentNode = featureGraph.createFeatureNode(Tokens.getCommentNodeType(comment), comment.getText(), comment.getSourcePos(0), comment.getSourcePos(comment.getText().length() - 1) + 1);
                featureGraph.addEdge(commentNode, tokenNode, GraphProtos.FeatureEdge.EdgeType.COMMENT);
            }
        }
    }

    private static CharSequence getSourceFileContent(JavaFileObject sourceFile) {
        try {
            return sourceFile.getCharContent(true);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException reading from " + sourceFile.getName());
        }
    }

    private static GraphProtos.FeatureNode.NodeType getCommentNodeType(Tokens.Comment comment) {
        Tokens.Comment.CommentStyle style = comment.getStyle();
        switch (style) {
            case LINE: {
                return GraphProtos.FeatureNode.NodeType.COMMENT_LINE;
            }
            case BLOCK: {
                return GraphProtos.FeatureNode.NodeType.COMMENT_BLOCK;
            }
            case JAVADOC: {
                return GraphProtos.FeatureNode.NodeType.COMMENT_JAVADOC;
            }
        }
        throw new IllegalArgumentException("Unrecognised comment type");
    }

    private static String tokenToString(ErrorProneToken token) {
        switch (String.valueOf((Object)token.kind().tag)) {
            case "STRING": {
                return "\"" + StringEscapeUtils.escapeJava(token.stringVal()) + "\"";
            }
            case "NUMERIC": {
                return token.stringVal();
            }
            case "NAMED": {
                return token.name().toString();
            }
        }
        return token.kind().name();
    }

    private static GraphProtos.FeatureNode.NodeType getNodeType(ErrorProneToken token) {
        switch (token.kind()) {
            case IDENTIFIER: 
            case SUPER: 
            case THIS: {
                return GraphProtos.FeatureNode.NodeType.IDENTIFIER_TOKEN;
            }
        }
        return GraphProtos.FeatureNode.NodeType.TOKEN;
    }
}

