/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.semantic;

import javax.lang.model.type.TypeMirror;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.semantic.TypeAnalysis;

public class AssignabilityAnalysis {
    private final FeatureGraph graph;
    private final TypeAnalysis analysis;

    public AssignabilityAnalysis(FeatureGraph graph, TypeAnalysis analysis) {
        this.graph = graph;
        this.analysis = analysis;
    }

    public static void addToGraph(FeatureGraph graph, TypeAnalysis analysis) {
        AssignabilityAnalysis assignabilityAnalysis = new AssignabilityAnalysis(graph, analysis);
        assignabilityAnalysis.performAnalysis();
    }

    private void performAnalysis() {
        for (GraphProtos.FeatureNode typeNode : this.graph.types()) {
            TypeMirror type = this.graph.lookupTypeMirror(typeNode);
            if (type == null) continue;
            for (GraphProtos.FeatureNode assignToTypeNode : this.graph.types()) {
                TypeMirror assignToType = this.graph.lookupTypeMirror(assignToTypeNode);
                if (assignToType == null || this.analysis.getTypes().isSameType(type, assignToType) || !this.analysis.isAssignable(type, assignToType)) continue;
                this.graph.addEdge(typeNode, assignToTypeNode, GraphProtos.FeatureEdge.EdgeType.ASSIGNABLE_TO);
            }
        }
    }
}

