/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.semantic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.AnalysisResult;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import uk.ac.cam.acr31.features.javac.semantic.LastUseTransferFunction;
import uk.ac.cam.acr31.features.javac.semantic.LastWriteTransferFunction;
import uk.ac.cam.acr31.features.javac.semantic.PossibleTreeSet;
import uk.ac.cam.acr31.features.javac.semantic.PossibleTreeSetStore;

public class DataflowOutputs {
    public final AnalysisResult<PossibleTreeSet, PossibleTreeSetStore> lastWrites;
    public final AnalysisResult<PossibleTreeSet, PossibleTreeSetStore> lastUses;

    private DataflowOutputs(AnalysisResult<PossibleTreeSet, PossibleTreeSetStore> lastWrites, AnalysisResult<PossibleTreeSet, PossibleTreeSetStore> lastUses) {
        this.lastWrites = lastWrites;
        this.lastUses = lastUses;
    }

    public static ImmutableMap<ClassTree, ImmutableMap<MethodTree, DataflowOutputs>> create(CompilationUnitTree compilationUnitTree, ProcessingEnvironment processingEnvironment) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ClassTree classTree : DataflowOutputs.getClasses(compilationUnitTree)) {
            ImmutableMap.Builder methodResult = ImmutableMap.builder();
            for (MethodTree methodTree : DataflowOutputs.getMethods(classTree)) {
                Optional<DataflowOutputs> results = DataflowOutputs.createForMethod(compilationUnitTree, classTree, methodTree, processingEnvironment);
                results.ifPresent(r -> methodResult.put(methodTree, r));
            }
            result.put(classTree, methodResult.build());
        }
        return result.build();
    }

    private static ImmutableList<ClassTree> getClasses(CompilationUnitTree t) {
        return t.getTypeDecls().stream().filter(typeDecl -> typeDecl.getKind().equals((Object)Tree.Kind.CLASS)).map(typeDecl -> (ClassTree)typeDecl).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<MethodTree> getMethods(ClassTree classTree) {
        return classTree.getMembers().stream().filter(member -> member.getKind().equals((Object)Tree.Kind.METHOD)).map(member -> (MethodTree)member).collect(ImmutableList.toImmutableList());
    }

    private static Optional<DataflowOutputs> createForMethod(CompilationUnitTree compilationUnitTree, ClassTree classTree, MethodTree methodTree, ProcessingEnvironment processingEnvironment) {
        ControlFlowGraph controlFlowGraph;
        try {
            controlFlowGraph = CFGBuilder.build(compilationUnitTree, methodTree, classTree, processingEnvironment);
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
        LastWriteTransferFunction lastWriteTransferFunction = new LastWriteTransferFunction();
        Analysis lastWriteAnalysis = new Analysis(lastWriteTransferFunction, processingEnvironment);
        lastWriteAnalysis.performAnalysis(controlFlowGraph);
        AnalysisResult<PossibleTreeSet, PossibleTreeSetStore> lastWrites = lastWriteAnalysis.getResult();
        LastUseTransferFunction lastUseTransferFunction = new LastUseTransferFunction();
        Analysis lastUseAnalysis = new Analysis(lastUseTransferFunction, processingEnvironment);
        lastUseAnalysis.performAnalysis(controlFlowGraph);
        AnalysisResult<PossibleTreeSet, PossibleTreeSetStore> lastUses = lastUseAnalysis.getResult();
        return Optional.of(new DataflowOutputs(lastWrites, lastUses));
    }
}

